/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.ColorProvider;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.IndiwareParser;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import org.apache.http.client.HttpResponseException;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class IndiwareMobileParser
extends BaseParser {
    private static final String PARAM_BASEURL = "baseurl";
    private static final int MAX_DAYS = 7;
    private JSONObject data;

    public IndiwareMobileParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        String baseurl = this.data.getString(PARAM_BASEURL) + "/";
        ArrayList<Document> docs = new ArrayList<Document>();
        HttpResponseException lastException = null;
        for (int i = 0; i < 7; ++i) {
            LocalDate date = LocalDate.now().plusDays(i);
            String dateStr = DateTimeFormat.forPattern((String)"yyyyMMdd").print((ReadablePartial)date);
            String filePrefix = this.scheduleData.getType() == SubstitutionSchedule.Type.TEACHER ? "PlanLe" : "PlanKl";
            String url = baseurl + "mobdaten/" + filePrefix + dateStr + "" + ".xml?_=" + System.currentTimeMillis();
            try {
                String xml = this.httpGet(url, "UTF-8");
                Document doc = Jsoup.parse((String)xml, (String)url, (Parser)Parser.xmlParser());
                if (!doc.select("kopf datei").text().equals(filePrefix + dateStr + ".xml")) continue;
                docs.add(doc);
                continue;
            }
            catch (HttpResponseException e) {
                lastException = e;
            }
        }
        if (docs.size() == 0 && lastException != null) {
            throw lastException;
        }
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        for (Document doc : docs) {
            v.addDay(IndiwareMobileParser.parseDay(doc, this.colorProvider, this.scheduleData));
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        v.setWebsite(baseurl + "plankl.html");
        return v;
    }

    static SubstitutionScheduleDay parseDay(Document doc, ColorProvider colorProvider, SubstitutionScheduleData scheduleData) {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        day.setDate(ParserUtils.parseDate(doc.select("Kopf > DatumPlan").text()));
        day.setLastChange(ParserUtils.parseDateTime(doc.select("Kopf > Zeitstempel").text()));
        for (Element klasse : doc.select("Klassen > Kl")) {
            String className = klasse.select("Kurz").first().text();
            HashSet<String> classes = new HashSet<String>();
            classes.add(className);
            for (Element lesson : klasse.select("Pl > Std")) {
                if (lesson.select("If:not(:empty), Le[LeAe], Ra[RaAe], Fa[FaAe]").size() == 0) continue;
                Substitution subst = new Substitution();
                subst.setLesson(IndiwareMobileParser.text(lesson.select("St")));
                if (scheduleData.getType() == SubstitutionSchedule.Type.STUDENT) {
                    subst.setTeachers(IndiwareMobileParser.split(IndiwareMobileParser.text(lesson.select("Le"))));
                    subst.setClasses(classes);
                } else {
                    subst.setClasses(IndiwareMobileParser.split(IndiwareMobileParser.text(lesson.select("Le"))));
                    subst.setTeachers(classes);
                }
                subst.setSubject(IndiwareMobileParser.text(lesson.select("Fa")));
                subst.setRoom(IndiwareMobileParser.text(lesson.select("Ra")));
                IndiwareParser.handleDescription(subst, IndiwareMobileParser.text(lesson.select("If")), scheduleData.getType() == SubstitutionSchedule.Type.TEACHER);
                if (subst.getType() == null) {
                    subst.setType("Vertretung");
                }
                subst.setColor(colorProvider.getColor(subst.getType()));
                day.addSubstitution(subst);
            }
        }
        for (Element info : doc.select("ZusatzInfo > ZiZeile")) {
            day.getMessages().add(info.text());
        }
        return day;
    }

    @NotNull
    private static HashSet<String> split(String text) {
        if (text != null) {
            return new HashSet<String>(Arrays.asList(text.split(",")));
        }
        return new HashSet<String>();
    }

    private static String text(Elements elem) {
        String text = elem.text().replace("&nbsp;", "").trim();
        if (!text.isEmpty()) {
            return text;
        }
        return null;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException, CredentialInvalidException {
        if (this.scheduleData.getType() == SubstitutionSchedule.Type.STUDENT) {
            return this.parseClasses("PlanKl");
        }
        return new ArrayList<String>();
    }

    @NotNull
    private List<String> parseClasses(String filePrefix) throws JSONException, IOException, CredentialInvalidException {
        String baseurl = this.data.getString(PARAM_BASEURL) + "/";
        HttpResponseException lastException = null;
        for (int i = -4; i < 7; ++i) {
            LocalDate date = LocalDate.now().plusDays(i);
            String dateStr = DateTimeFormat.forPattern((String)"yyyyMMdd").print((ReadablePartial)date);
            String url = baseurl + "mobdaten/" + filePrefix + dateStr + ".xml?_=" + System.currentTimeMillis();
            try {
                String xml = this.httpGet(url, "UTF-8");
                Document doc = Jsoup.parse((String)xml, (String)url, (Parser)Parser.xmlParser());
                ArrayList<String> classes = new ArrayList<String>();
                for (Element klasse : doc.select("Klassen > Kl")) {
                    classes.add(klasse.select("Kurz").first().text());
                }
                return classes;
            }
            catch (HttpResponseException e) {
                lastException = e;
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getAllTeachers() throws IOException, JSONException, CredentialInvalidException {
        if (this.scheduleData.getType() == SubstitutionSchedule.Type.TEACHER) {
            return this.parseClasses("PlanLe");
        }
        return null;
    }
}

