/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.IndiwareParser;
import me.vertretungsplan.parser.LoginHandler;
import org.apache.http.client.HttpResponseException;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public class IndiwareStundenplan24Parser
extends IndiwareParser {
    private static final int MAX_DAYS = 7;
    private static final String ENCODING = "UTF-8";

    public IndiwareStundenplan24Parser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        String baseurl;
        boolean isTeacher;
        if (this.data.has("schoolNumber")) {
            isTeacher = this.scheduleData.getType() == SubstitutionSchedule.Type.TEACHER;
            baseurl = "https://www.stundenplan24.de/" + this.data.getString("schoolNumber") + (isTeacher ? "/vplanle/" : "/vplan/");
            if (this.credential == null || !(this.credential instanceof UserPasswordCredential)) {
                throw new IOException("no login");
            }
            String login = ((UserPasswordCredential)this.credential).getUsername();
            String password = ((UserPasswordCredential)this.credential).getPassword();
            this.executor.auth(login, password);
        } else {
            baseurl = this.data.getString("baseurl") + "/";
            isTeacher = this.data.getString("baseurl").endsWith("vplanle");
            new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        }
        ArrayList<Document> docs = new ArrayList<Document>();
        for (int i = 0; i < 7; ++i) {
            LocalDate date = LocalDate.now().plusDays(i);
            String dateStr = DateTimeFormat.forPattern((String)"yyyyMMdd").print((ReadablePartial)date);
            String suffix = isTeacher ? "Le" : "Kl";
            String url = baseurl + "vdaten/Vplan" + suffix + dateStr + ".xml?_=" + System.currentTimeMillis();
            try {
                String xml = this.httpGet(url, ENCODING);
                Document doc = Jsoup.parse((String)xml, (String)url, (Parser)Parser.xmlParser());
                if (!doc.select("kopf datei").text().equals("Vplan" + suffix + dateStr + ".xml")) continue;
                docs.add(doc);
                continue;
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 404 || e.getStatusCode() == 300) continue;
                throw e;
            }
        }
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        for (Document doc : docs) {
            v.addDay(this.parseIndiwareDay((Element)doc, false));
        }
        v.setWebsite(baseurl);
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }
}

