/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.utils;

import com.paour.comparator.NaturalOrderComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.diff.SubstitutionDiff;
import name.fraser.neil.plaintext.DiffMatchPatch;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.Contract;

public class SubstitutionTextUtils {
    public static String getText(Substitution substitution) {
        String subjectAndTeacher = SubstitutionTextUtils.subjectAndTeacher(substitution);
        String room = SubstitutionTextUtils.room(substitution);
        String desc = SubstitutionTextUtils.hasData(substitution.getDesc()) ? substitution.getDesc() : "";
        return SubstitutionTextUtils.formatOutput(subjectAndTeacher, room, desc);
    }

    public static String getTeacherText(Substitution substitution) {
        String subjectAndClass = SubstitutionTextUtils.subjectAndClass(substitution);
        String room = SubstitutionTextUtils.room(substitution);
        String desc = SubstitutionTextUtils.hasData(substitution.getDesc()) ? substitution.getDesc() : "";
        return SubstitutionTextUtils.formatOutput(subjectAndClass, room, desc);
    }

    public static String getTeachers(Substitution substitution) {
        if (SubstitutionTextUtils.hasData(substitution.getTeacher()) && SubstitutionTextUtils.hasData(substitution.getPreviousTeacher()) && !substitution.getTeacher().equals(substitution.getPreviousTeacher())) {
            return substitution.getTeacher() + " statt " + substitution.getPreviousTeacher();
        }
        if (SubstitutionTextUtils.hasData(substitution.getTeacher())) {
            return substitution.getTeacher();
        }
        if (SubstitutionTextUtils.hasData(substitution.getPreviousTeacher())) {
            return substitution.getPreviousTeacher();
        }
        return "";
    }

    public static String getText(SubstitutionDiff diff) {
        Substitution oldSubst = diff.getOldSubstitution();
        Substitution newSubst = diff.getNewSubstitution();
        String subjectAndTeacher = SubstitutionTextUtils.diff(SubstitutionTextUtils.subjectAndTeacher(oldSubst), SubstitutionTextUtils.subjectAndTeacher(newSubst));
        String room = SubstitutionTextUtils.diff(SubstitutionTextUtils.room(oldSubst), SubstitutionTextUtils.room(newSubst));
        String desc = SubstitutionTextUtils.diff(oldSubst.getDesc(), newSubst.getDesc());
        return SubstitutionTextUtils.formatOutput(subjectAndTeacher, room, desc);
    }

    private static String room(Substitution substitution) {
        String room = substitution.getRoom();
        String previousRoom = substitution.getPreviousRoom();
        if (SubstitutionTextUtils.hasData(room) && SubstitutionTextUtils.hasData(previousRoom) && !room.equals(previousRoom)) {
            return String.format("%s statt %s", room, previousRoom);
        }
        if (SubstitutionTextUtils.hasData(room)) {
            return room;
        }
        if (SubstitutionTextUtils.hasData(previousRoom)) {
            return previousRoom;
        }
        return "";
    }

    private static String subjectAndTeacher(Substitution substitution) {
        String subject = substitution.getSubject();
        String previousSubject = substitution.getPreviousSubject();
        String teacher = substitution.getTeacher();
        String previousTeacher = substitution.getPreviousTeacher();
        if (SubstitutionTextUtils.hasData(subject) && SubstitutionTextUtils.hasData(previousSubject) && !subject.equals(previousSubject)) {
            return SubstitutionTextUtils.subjectAndTeacher(subject, previousSubject, teacher, previousTeacher);
        }
        if (SubstitutionTextUtils.hasData(subject) && SubstitutionTextUtils.hasData(previousSubject) && subject.equals(previousSubject) || SubstitutionTextUtils.hasData(subject) && !SubstitutionTextUtils.hasData(previousSubject)) {
            return SubstitutionTextUtils.subjectAndTeacher(subject, teacher, previousTeacher);
        }
        if (!SubstitutionTextUtils.hasData(subject) && SubstitutionTextUtils.hasData(previousSubject)) {
            return SubstitutionTextUtils.subjectAndTeacher(previousSubject, teacher, previousTeacher);
        }
        if (!SubstitutionTextUtils.hasData(subject) && !SubstitutionTextUtils.hasData(previousSubject)) {
            return SubstitutionTextUtils.subjectAndTeacher(teacher, previousTeacher);
        }
        throw new MissingCaseException();
    }

    private static String subjectAndClass(Substitution substitution) {
        String subject = substitution.getSubject();
        String previousSubject = substitution.getPreviousSubject();
        String klasse = SubstitutionTextUtils.joinClasses(substitution.getClasses());
        if (SubstitutionTextUtils.hasData(subject) && SubstitutionTextUtils.hasData(previousSubject) && !subject.equals(previousSubject)) {
            return SubstitutionTextUtils.subjectAndTeacher(subject, previousSubject, klasse, klasse);
        }
        if (SubstitutionTextUtils.hasData(subject) && SubstitutionTextUtils.hasData(previousSubject) && subject.equals(previousSubject) || SubstitutionTextUtils.hasData(subject) && !SubstitutionTextUtils.hasData(previousSubject)) {
            return SubstitutionTextUtils.subjectAndTeacher(subject, klasse, klasse);
        }
        if (!SubstitutionTextUtils.hasData(subject) && SubstitutionTextUtils.hasData(previousSubject)) {
            return SubstitutionTextUtils.subjectAndTeacher(previousSubject, klasse, klasse);
        }
        if (!SubstitutionTextUtils.hasData(subject) && !SubstitutionTextUtils.hasData(previousSubject)) {
            return SubstitutionTextUtils.subjectAndTeacher(klasse, klasse);
        }
        throw new MissingCaseException();
    }

    public static String joinClasses(Set<String> classes) {
        ArrayList<String> list = new ArrayList<String>(classes);
        Collections.sort(list, new NaturalOrderComparator());
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        String beginning = null;
        Pattern beginningRegex = Pattern.compile("^(.*\\d+)(\\w+)$");
        for (String string : list) {
            Matcher matcher;
            if (first) {
                matcher = beginningRegex.matcher(string);
                if (matcher.find()) {
                    beginning = matcher.group(1);
                }
                builder.append(string);
                first = false;
                continue;
            }
            matcher = beginningRegex.matcher(string);
            if (matcher.find()) {
                String newBeginning = matcher.group(1);
                if (newBeginning.equals(beginning)) {
                    builder.append(matcher.group(2));
                    continue;
                }
                builder.append(", ");
                builder.append(string);
                beginning = newBeginning;
                continue;
            }
            builder.append(", ");
            builder.append(string);
            beginning = null;
        }
        return builder.toString();
    }

    public static String joinTeachers(Set<String> teachers) {
        ArrayList<String> list = new ArrayList<String>(teachers);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String teacher : list) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(teacher);
        }
        return builder.toString();
    }

    private static String subjectAndTeacher(String subject, String previousSubject, String teacher, String previousTeacher) {
        if (SubstitutionTextUtils.hasData(teacher) && SubstitutionTextUtils.hasData(previousTeacher) && !teacher.equals(previousTeacher)) {
            return SubstitutionTextUtils.changedSubjectWithChangedTeacher(subject, previousSubject, teacher, previousTeacher);
        }
        if (SubstitutionTextUtils.hasData(teacher) && SubstitutionTextUtils.hasData(previousTeacher) && teacher.equals(previousTeacher) || SubstitutionTextUtils.hasData(teacher) && !SubstitutionTextUtils.hasData(previousTeacher)) {
            return SubstitutionTextUtils.changedSubjectWithTeacher(subject, previousSubject, teacher);
        }
        if (!SubstitutionTextUtils.hasData(teacher) && SubstitutionTextUtils.hasData(previousTeacher)) {
            return SubstitutionTextUtils.changedSubjectWithTeacher(subject, previousSubject, previousTeacher);
        }
        if (!SubstitutionTextUtils.hasData(teacher) && !SubstitutionTextUtils.hasData(previousTeacher)) {
            return SubstitutionTextUtils.changedSubject(subject, previousSubject);
        }
        throw new MissingCaseException();
    }

    private static String subjectAndTeacher(String subject, String teacher, String previousTeacher) {
        if (SubstitutionTextUtils.hasData(teacher) && SubstitutionTextUtils.hasData(previousTeacher) && !teacher.equals(previousTeacher)) {
            return SubstitutionTextUtils.subjectWithChangedTeacher(subject, teacher, previousTeacher);
        }
        if (SubstitutionTextUtils.hasData(teacher) && SubstitutionTextUtils.hasData(previousTeacher) && teacher.equals(previousTeacher) || SubstitutionTextUtils.hasData(teacher) && !SubstitutionTextUtils.hasData(previousTeacher)) {
            return SubstitutionTextUtils.subjectWithTeacher(subject, teacher);
        }
        if (!SubstitutionTextUtils.hasData(teacher) && SubstitutionTextUtils.hasData(previousTeacher)) {
            return SubstitutionTextUtils.subjectWithTeacher(subject, previousTeacher);
        }
        if (!SubstitutionTextUtils.hasData(teacher) && !SubstitutionTextUtils.hasData(previousTeacher)) {
            return subject;
        }
        throw new MissingCaseException();
    }

    private static String subjectAndTeacher(String teacher, String previousTeacher) {
        if (SubstitutionTextUtils.hasData(teacher) && SubstitutionTextUtils.hasData(previousTeacher) && !teacher.equals(previousTeacher)) {
            return SubstitutionTextUtils.changedTeacher(teacher, previousTeacher);
        }
        if (SubstitutionTextUtils.hasData(teacher) && SubstitutionTextUtils.hasData(previousTeacher) && teacher.equals(previousTeacher) || SubstitutionTextUtils.hasData(teacher) && !SubstitutionTextUtils.hasData(previousTeacher)) {
            return teacher;
        }
        if (!SubstitutionTextUtils.hasData(teacher) && SubstitutionTextUtils.hasData(previousTeacher)) {
            return previousTeacher;
        }
        if (!SubstitutionTextUtils.hasData(teacher) && !SubstitutionTextUtils.hasData(previousTeacher)) {
            return "";
        }
        throw new MissingCaseException();
    }

    private static String changedSubjectWithChangedTeacher(String subject, String previousSubject, String teacher, String previousTeacher) {
        return String.format("%s (%s) statt %s (%s)", subject, teacher, previousSubject, previousTeacher);
    }

    private static String subjectWithChangedTeacher(String subject, String teacher, String previousTeacher) {
        return String.format("%s (%s statt %s)", subject, teacher, previousTeacher);
    }

    private static String changedSubjectWithTeacher(String subject, String previousSubject, String teacher) {
        return String.format("%s statt %s (%s)", subject, previousSubject, teacher);
    }

    private static String subjectWithTeacher(String subject, String teacher) {
        return String.format("%s (%s)", subject, teacher);
    }

    private static String changedSubject(String subject, String previousSubject) {
        return String.format("%s statt %s", subject, previousSubject);
    }

    private static String changedTeacher(String teacher, String previousTeacher) {
        return String.format("%s statt %s", teacher, previousTeacher);
    }

    @Contract(pure=true)
    static boolean hasData(String string) {
        if (string != null) {
            String s = string.replaceAll("\\s", "");
            return !s.equals("") && !s.equals("---");
        }
        return false;
    }

    private static String diff(String oldS, String newS) {
        if (SubstitutionTextUtils.hasData(oldS) && SubstitutionTextUtils.hasData(newS)) {
            LinkedList<DiffMatchPatch.Diff> diffs = new DiffMatchPatch().diff_main(oldS, newS);
            StringBuilder builder = new StringBuilder();
            for (DiffMatchPatch.Diff diff : diffs) {
                String text = StringEscapeUtils.escapeHtml4((String)diff.text);
                switch (diff.operation) {
                    case INSERT: {
                        builder.append("<ins>").append(text).append("</ins>");
                        break;
                    }
                    case DELETE: {
                        builder.append("<del>").append(text).append("</del>");
                        break;
                    }
                    case EQUAL: {
                        builder.append(text);
                    }
                }
            }
            return builder.toString();
        }
        return SubstitutionTextUtils.commonDiff(oldS, newS);
    }

    private static String simpleDiff(String oldS, String newS) {
        if (SubstitutionTextUtils.hasData(oldS) && SubstitutionTextUtils.hasData(newS)) {
            if (oldS.equals(newS)) {
                return StringEscapeUtils.escapeHtml4((String)oldS);
            }
            return String.format("<del>%s</del><ins>%s</ins>", StringEscapeUtils.escapeHtml4((String)oldS), StringEscapeUtils.escapeHtml4((String)newS));
        }
        return SubstitutionTextUtils.commonDiff(oldS, newS);
    }

    private static String commonDiff(String oldS, String newS) {
        if (SubstitutionTextUtils.hasData(oldS)) {
            return String.format("<del>%s</del>", StringEscapeUtils.escapeHtml4((String)oldS));
        }
        if (SubstitutionTextUtils.hasData(newS)) {
            return String.format("<ins>%s</ins>", StringEscapeUtils.escapeHtml4((String)newS));
        }
        return "";
    }

    private static String formatOutput(String subjectAndTeacher, String room, String desc) {
        if (!(subjectAndTeacher.isEmpty() || room.isEmpty() || desc.isEmpty())) {
            return String.format("%s in %s \u2013 %s", subjectAndTeacher, room, desc);
        }
        if (!subjectAndTeacher.isEmpty() && !room.isEmpty()) {
            return String.format("%s in %s", subjectAndTeacher, room);
        }
        if (!room.isEmpty() && !desc.isEmpty()) {
            return String.format("%s \u2013 %s", room, desc);
        }
        if (!room.isEmpty()) {
            return room;
        }
        if (!subjectAndTeacher.isEmpty() && !desc.isEmpty()) {
            return String.format("%s \u2013 %s", subjectAndTeacher, desc);
        }
        if (!subjectAndTeacher.isEmpty()) {
            return subjectAndTeacher;
        }
        if (!desc.isEmpty()) {
            return desc;
        }
        return "";
    }

    private static class MissingCaseException
    extends RuntimeException {
        private MissingCaseException() {
        }
    }
}

