/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.AdditionalInfo;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.ContentType;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IphisParser
extends BaseParser {
    private static final String PARAM_URL = "url";
    private static final String PARAM_JWT_KEY = "jwt_key";
    private static final String PARAM_KUERZEL = "kuerzel";
    private String api;
    private String kuerzel;
    private String jwt_key;
    private String website;
    private JSONArray grades;
    private JSONArray teachers;
    private JSONArray messages;
    private String authToken;
    private LocalDateTime lastUpdate;

    public IphisParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        JSONObject data = scheduleData.getData();
        try {
            this.api = "https://" + data.getString(PARAM_URL) + "/remote/vertretungsplan/ssp";
            this.kuerzel = data.getString(PARAM_KUERZEL);
            this.jwt_key = data.getString(PARAM_JWT_KEY);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        SubstitutionSchedule substitutionSchedule = SubstitutionSchedule.fromData(this.scheduleData);
        if (this.login().booleanValue()) {
            this.getGrades();
            this.getTeachers();
            this.getMessages();
            JSONArray changes = this.getChanges();
            substitutionSchedule.setClasses(this.getAllClasses());
            substitutionSchedule.setTeachers(this.getAllTeachers());
            substitutionSchedule.setWebsite(this.website);
            this.parseIphis(substitutionSchedule, changes, this.grades, this.teachers, this.messages);
        }
        return substitutionSchedule;
    }

    @Override
    public LocalDateTime getLastChange() throws IOException, JSONException, CredentialInvalidException {
        if (this.lastUpdate == null) {
            this.login();
        }
        return this.lastUpdate;
    }

    private Boolean login() throws CredentialInvalidException, IOException {
        UserPasswordCredential userPasswordCredential = (UserPasswordCredential)this.credential;
        String username = userPasswordCredential.getUsername();
        String password = userPasswordCredential.getPassword();
        JSONObject payload = new JSONObject();
        try {
            payload.put("school", (Object)this.kuerzel);
            payload.put("user", (Object)username);
            payload.put("type", (Object)this.scheduleData.getType());
            payload.put("password", (Object)password);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.httpPost(this.api + "/login", "UTF-8", payload.toString(), ContentType.APPLICATION_JSON);
        String httpResponse = this.httpPost(this.api + "/login", "UTF-8", payload.toString(), ContentType.APPLICATION_JSON);
        try {
            JSONObject token = new JSONObject(httpResponse);
            String key = Base64.encodeBase64String((byte[])this.jwt_key.getBytes());
            Claims jwtToken = (Claims)Jwts.parser().setSigningKey(key).parseClaimsJws(token.getString("token")).getBody();
            assert (jwtToken.getSubject().equals("vertretungsplan.me"));
            this.authToken = token.getString("token");
            this.website = jwtToken.getIssuer();
            this.lastUpdate = new LocalDateTime(token.getLong("stand") * 1000L);
        }
        catch (SignatureException | JSONException e) {
            throw new CredentialInvalidException();
        }
        return true;
    }

    private JSONArray getChanges() throws IOException, CredentialInvalidException {
        String startBy = LocalDate.now().toString();
        String endBy = LocalDate.now().plusWeeks(1).toString();
        String url = this.api + "/vertretung/von/" + startBy + "/bis/" + endBy;
        return this.getJSONArray(url);
    }

    private void getMessages() throws IOException, JSONException, CredentialInvalidException {
        if (this.messages == null) {
            String url = this.api + "/nachrichten";
            this.messages = this.getJSONArray(url);
        }
    }

    private void getGrades() throws IOException, JSONException, CredentialInvalidException {
        if (this.grades == null) {
            String url = this.api + "/klassen";
            this.grades = this.getJSONArray(url);
        }
    }

    private void getTeachers() throws IOException, CredentialInvalidException {
        if (this.teachers == null) {
            String url = this.api + "/lehrer";
            this.teachers = this.getJSONArray(url);
        }
    }

    private JSONArray getJSONArray(String url) throws IOException, CredentialInvalidException {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + this.authToken);
            headers.put("Content-Type", "application/json");
            headers.put("Accept", "application/json");
            String httpResponse = this.httpGet(url, "UTF-8", headers);
            return new JSONArray(httpResponse);
        }
        catch (HttpResponseException httpResponseException) {
            if (httpResponseException.getStatusCode() == 404) {
                return null;
            }
            throw httpResponseException;
        }
        catch (JSONException e) {
            return new JSONArray();
        }
    }

    void parseIphis(SubstitutionSchedule substitutionSchedule, JSONArray changes, JSONArray grades, JSONArray teachers, JSONArray messages) throws IOException, JSONException {
        if (changes == null) {
            return;
        }
        HashMap<String, String> coursesHashMap = null;
        if (grades != null) {
            coursesHashMap = new HashMap<String, String>();
            for (int i = 0; i < grades.length(); ++i) {
                JSONObject grade = grades.getJSONObject(i);
                coursesHashMap.put(grade.getString("id"), grade.getString("name"));
            }
        }
        HashMap<String, String> teachersHashMap = null;
        if (teachers != null) {
            teachersHashMap = new HashMap<String, String>();
            for (int i = 0; i < teachers.length(); ++i) {
                JSONObject teacher = teachers.getJSONObject(i);
                teachersHashMap.put(teacher.getString("id"), teacher.getString("name"));
            }
        }
        ArrayList<AdditionalInfo> infos = new ArrayList<AdditionalInfo>(messages.length());
        for (int i = 0; i < messages.length(); ++i) {
            JSONObject message = messages.getJSONObject(i);
            AdditionalInfo info = new AdditionalInfo();
            info.setHasInformation(message.getBoolean("notification"));
            info.setTitle(message.getString("titel").trim());
            info.setText(message.getString("nachricht").trim());
            info.setFromSchedule(true);
            infos.add(info);
        }
        substitutionSchedule.getAdditionalInfos().addAll(infos);
        substitutionSchedule.setLastChange(this.lastUpdate);
        LocalDate currentDate = LocalDate.now();
        SubstitutionScheduleDay substitutionScheduleDay = new SubstitutionScheduleDay();
        substitutionScheduleDay.setDate(currentDate);
        for (int i = 0; i < changes.length(); ++i) {
            JSONObject change = changes.getJSONObject(i);
            LocalDate substitutionDate = new LocalDate((Object)change.getString("datum"));
            if (!substitutionDate.isEqual((ReadablePartial)currentDate)) {
                if (!substitutionScheduleDay.getSubstitutions().isEmpty()) {
                    substitutionSchedule.addDay(substitutionScheduleDay);
                }
                substitutionScheduleDay = new SubstitutionScheduleDay();
                substitutionScheduleDay.setDate(substitutionDate);
                currentDate = substitutionDate;
            }
            if (change.getInt("id") > 0) {
                Substitution substitution = this.getSubstitution(change, coursesHashMap, teachersHashMap);
                substitutionScheduleDay.addSubstitution(substitution);
                continue;
            }
            if (change.optString("nachricht").isEmpty()) continue;
            substitutionScheduleDay.addMessage(change.optString("nachricht"));
        }
        substitutionSchedule.addDay(substitutionScheduleDay);
    }

    private String[] getSQLArray(String data) {
        String[] retArray = new String[]{};
        Pattern pattern = Pattern.compile("\\{(.*?)}");
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            retArray = matcher.group(1).split(",");
        }
        return retArray;
    }

    private Substitution getSubstitution(JSONObject change, HashMap<String, String> gradesHashMap, HashMap<String, String> teachersHashMap) throws IOException, JSONException {
        String type;
        Substitution substitution = new Substitution();
        String[] classIds = this.getSQLArray(change.getString("id_klasse"));
        if (classIds.length > 0) {
            if (gradesHashMap == null) {
                throw new IOException("Change references a grade but grades are empty.");
            }
            HashSet<String> classes = new HashSet<String>();
            for (String classId : classIds) {
                if (classId.toLowerCase().equals("null")) continue;
                if (gradesHashMap.containsKey(classId)) {
                    classes.add(gradesHashMap.get(classId));
                    continue;
                }
                throw new IllegalArgumentException("unknown class ID " + classId + " referenced");
            }
            substitution.setClasses(classes);
        }
        if (!(type = change.getString("aenderungsgrund").trim()).isEmpty() && !type.toLowerCase().equals("null")) {
            substitution.setType(type);
        } else {
            substitution.setType("Vertretung");
        }
        substitution.setColor(this.colorProvider.getColor(type));
        String[] coveringTeacherIds = this.getSQLArray(change.getString("id_person_verantwortlich"));
        if (coveringTeacherIds.length > 0) {
            if (teachersHashMap == null) {
                throw new IOException("Change references a covering teacher but teachers are empty.");
            }
            HashSet<String> teachers = new HashSet<String>();
            for (String coveringTeacherId : coveringTeacherIds) {
                if (coveringTeacherId.toLowerCase().equals("null") || teachersHashMap.get(coveringTeacherId) == null) continue;
                teachers.add(teachersHashMap.get(coveringTeacherId));
            }
            substitution.setTeachers(teachers);
        }
        String[] teacherIds = this.getSQLArray(change.getString("id_person_verantwortlich_orig"));
        HashSet<String> coveringTeachers = new HashSet<String>();
        if (teacherIds.length > 0) {
            if (teachersHashMap == null) {
                throw new IOException("Change references a teacher but teachers are empty.");
            }
            for (String coveringTeacherId : coveringTeacherIds) {
                if (coveringTeacherId.toLowerCase().equals("null") || teachersHashMap.get(coveringTeacherId) == null) continue;
                coveringTeachers.add(teachersHashMap.get(coveringTeacherId));
            }
            substitution.setPreviousTeachers(coveringTeachers);
        }
        if (!change.optString("raum").isEmpty() && !change.optString("raum").toLowerCase().equals("null")) {
            substitution.setRoom(change.optString("raum"));
        } else if (!change.optString("raum_orig").isEmpty() && !change.optString("raum_orig").toLowerCase().equals("null")) {
            substitution.setRoom(change.optString("raum_orig"));
        }
        if (!change.optString("raum_orig").isEmpty() && !change.optString("raum_orig").toLowerCase().equals("null")) {
            substitution.setPreviousRoom(change.optString("raum_orig"));
        } else if (!change.optString("raum").isEmpty() && !change.optString("raum").toLowerCase().equals("null")) {
            substitution.setPreviousRoom(change.optString("raum"));
        }
        if (!change.optString("fach").isEmpty() && !change.optString("fach").toLowerCase().equals("null")) {
            substitution.setSubject(change.optString("fach"));
        }
        if (!change.optString("fach_orig").isEmpty() && !change.optString("fach_orig").toLowerCase().equals("null")) {
            substitution.setPreviousSubject(change.optString("fach_orig"));
        }
        if (!change.getString("information").isEmpty() && !change.getString("information").toLowerCase().equals("null")) {
            substitution.setDesc(change.getString("information").trim());
        }
        String startingHour = change.getString("zeit_von").replaceFirst("^0+(?!$)", "");
        String endingHour = change.getString("zeit_bis").replaceFirst("^0+(?!$)", "");
        if (!startingHour.equals("") || !endingHour.equals("")) {
            String lesson = "";
            if (!startingHour.equals("") && endingHour.equals("")) {
                lesson = "Ab " + startingHour;
            }
            if (startingHour.equals("") && !endingHour.equals("")) {
                lesson = "Bis " + endingHour;
            }
            if (!startingHour.equals("") && !endingHour.equals("")) {
                lesson = startingHour + " - " + endingHour;
            }
            if (startingHour.equals(endingHour)) {
                lesson = startingHour;
            }
            substitution.setLesson(lesson);
        }
        return substitution;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException, CredentialInvalidException {
        ArrayList<String> classesList = new ArrayList<String>();
        if (this.grades == null) {
            return null;
        }
        for (int i = 0; i < this.grades.length(); ++i) {
            JSONObject grade = this.grades.getJSONObject(i);
            classesList.add(grade.getString("name"));
        }
        return classesList;
    }

    @Override
    public List<String> getAllTeachers() throws IOException, JSONException, CredentialInvalidException {
        ArrayList<String> teachersList = new ArrayList<String>();
        if (this.teachers == null) {
            return null;
        }
        for (int i = 0; i < this.teachers.length(); ++i) {
            JSONObject teacher = this.teachers.getJSONObject(i);
            teachersList.add(teacher.getString("name"));
        }
        return teachersList;
    }
}

