/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.objects.credential.Credential;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.HttpResponseException;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LegionBoardParser
extends BaseParser {
    private static final String PARAM_API = "api";
    private static final String PARAM_WEBSITE = "website";
    private String api;
    private String website;

    public LegionBoardParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        JSONObject data = scheduleData.getData();
        try {
            this.api = data.getString(PARAM_API);
            this.website = data.getString(PARAM_WEBSITE);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        SubstitutionSchedule substitutionSchedule = SubstitutionSchedule.fromData(this.scheduleData);
        substitutionSchedule.setClasses(this.getAllClasses());
        substitutionSchedule.setTeachers(this.getAllTeachers());
        substitutionSchedule.setWebsite(this.website);
        JSONArray changes = this.getChanges();
        JSONArray courses = this.getCourses();
        JSONArray teachers = this.getTeachers();
        this.parseLegionBoard(substitutionSchedule, changes, courses, teachers);
        return substitutionSchedule;
    }

    private String getAuthenticationKey(Credential credential) {
        UserPasswordCredential userPasswordCredential = (UserPasswordCredential)credential;
        String username = userPasswordCredential.getUsername();
        String password = userPasswordCredential.getPassword();
        return DigestUtils.sha256Hex((String)(username.toLowerCase() + "//" + password));
    }

    private JSONArray getChanges() throws IOException, JSONException, CredentialInvalidException {
        String startBy = "now";
        String endBy = "i1w";
        String url = this.api + "/changes?startBy=" + "now" + "&endBy=" + "i1w" + "&k=" + this.getAuthenticationKey(this.getCredential());
        return this.getJSONArray(url);
    }

    private JSONArray getCourses() throws IOException, JSONException, CredentialInvalidException {
        String url = this.api + "/courses?k=" + this.getAuthenticationKey(this.getCredential());
        return this.getJSONArray(url);
    }

    private JSONArray getTeachers() throws IOException, JSONException, CredentialInvalidException {
        String url = this.api + "/teachers?k=" + this.getAuthenticationKey(this.getCredential());
        return this.getJSONArray(url);
    }

    private JSONArray getJSONArray(String url) throws IOException, JSONException, CredentialInvalidException {
        try {
            return new JSONArray(this.httpGet(url, "UTF-8"));
        }
        catch (HttpResponseException httpResponseException) {
            if (httpResponseException.getStatusCode() == 404) {
                return null;
            }
            throw httpResponseException;
        }
    }

    void parseLegionBoard(SubstitutionSchedule substitutionSchedule, JSONArray changes, JSONArray courses, JSONArray teachers) throws IOException, JSONException {
        if (changes == null) {
            return;
        }
        HashMap<String, String> coursesHashMap = null;
        if (courses != null) {
            coursesHashMap = new HashMap<String, String>();
            for (int i = 0; i < courses.length(); ++i) {
                JSONObject course = courses.getJSONObject(i);
                coursesHashMap.put(course.getString("id"), course.getString("name"));
            }
        }
        HashMap<String, String> teachersHashMap = null;
        if (teachers != null) {
            teachersHashMap = new HashMap<String, String>();
            for (int i = 0; i < teachers.length(); ++i) {
                JSONObject teacher = teachers.getJSONObject(i);
                teachersHashMap.put(teacher.getString("id"), teacher.getString("name"));
            }
        }
        LocalDate currentDate = LocalDate.now();
        SubstitutionScheduleDay substitutionScheduleDay = new SubstitutionScheduleDay();
        substitutionScheduleDay.setDate(currentDate);
        for (int i = 0; i < changes.length(); ++i) {
            LocalDate endingDate;
            JSONObject change = changes.getJSONObject(i);
            Substitution substitution = this.getSubstitution(change, coursesHashMap, teachersHashMap);
            LocalDate startingDate = new LocalDate((Object)change.getString("startingDate"));
            if (!startingDate.isEqual((ReadablePartial)(endingDate = new LocalDate((Object)change.getString("endingDate"))))) {
                if (!substitutionScheduleDay.getSubstitutions().isEmpty()) {
                    substitutionSchedule.addDay(substitutionScheduleDay);
                }
                for (int k = 0; k < 8; ++k) {
                    LocalDate date = LocalDate.now().plusDays(k);
                    if (!date.isAfter((ReadablePartial)startingDate) && !date.isEqual((ReadablePartial)startingDate) || !date.isBefore((ReadablePartial)endingDate) && !date.isEqual((ReadablePartial)endingDate)) continue;
                    substitutionScheduleDay = new SubstitutionScheduleDay();
                    substitutionScheduleDay.setDate(date);
                    substitutionScheduleDay.addSubstitution(substitution);
                    substitutionSchedule.addDay(substitutionScheduleDay);
                    currentDate = date;
                }
                continue;
            }
            if (!startingDate.isEqual((ReadablePartial)currentDate)) {
                if (!substitutionScheduleDay.getSubstitutions().isEmpty()) {
                    substitutionSchedule.addDay(substitutionScheduleDay);
                }
                substitutionScheduleDay = new SubstitutionScheduleDay();
                substitutionScheduleDay.setDate(startingDate);
                currentDate = startingDate;
            }
            substitutionScheduleDay.addSubstitution(substitution);
        }
        substitutionSchedule.addDay(substitutionScheduleDay);
    }

    private Substitution getSubstitution(JSONObject change, HashMap<String, String> coursesHashMap, HashMap<String, String> teachersHashMap) throws IOException, JSONException {
        String teacherId;
        Substitution substitution = new Substitution();
        String classId = change.getString("course");
        if (!classId.equals("0")) {
            if (coursesHashMap == null) {
                throw new IOException("Change references a course but courses are empty.");
            }
            String singleClass = coursesHashMap.get(classId);
            Object classes = new HashSet();
            ((HashSet)classes).add(singleClass);
            substitution.setClasses((Set<String>)classes);
        }
        String type = "Unknown";
        switch (change.getString("type")) {
            case "0": {
                type = "Entfall";
                break;
            }
            case "1": {
                type = "Vertretung";
                break;
            }
            case "2": {
                type = "Information";
            }
        }
        substitution.setType(type);
        substitution.setColor(this.colorProvider.getColor(type));
        String coveringTeacherId = change.getString("coveringTeacher");
        if (!coveringTeacherId.equals("0")) {
            if (teachersHashMap == null) {
                throw new IOException("Change references a covering teacher but teachers are empty.");
            }
            if (!teachersHashMap.get(coveringTeacherId).equals("-")) {
                substitution.setTeacher(teachersHashMap.get(coveringTeacherId));
            }
        }
        if (!(teacherId = change.getString("teacher")).equals("0")) {
            if (teachersHashMap == null) {
                throw new IOException("Change references a teacher but teachers are empty.");
            }
            if (!teachersHashMap.get(teacherId).equals("-")) {
                if (type.equals("Vertretung") || substitution.getTeacher() != null) {
                    substitution.setPreviousTeacher(teachersHashMap.get(teacherId));
                } else {
                    substitution.setTeacher(teachersHashMap.get(teacherId));
                }
            }
        }
        substitution.setDesc(change.getString("text"));
        String startingHour = change.getString("startingHour").replaceFirst("^0+(?!$)", "");
        String endingHour = change.getString("endingHour").replaceFirst("^0+(?!$)", "");
        if (!startingHour.equals("") || !endingHour.equals("")) {
            String lesson = "";
            if (!startingHour.equals("") && endingHour.equals("")) {
                lesson = "Ab " + startingHour;
            }
            if (startingHour.equals("") && !endingHour.equals("")) {
                lesson = "Bis " + endingHour;
            }
            if (!startingHour.equals("") && !endingHour.equals("")) {
                lesson = startingHour.equals(endingHour) ? startingHour : startingHour + " - " + endingHour;
            }
            substitution.setLesson(lesson);
        }
        return substitution;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException, CredentialInvalidException {
        ArrayList<String> classes = new ArrayList<String>();
        JSONArray courses = this.getCourses();
        if (courses == null) {
            return null;
        }
        for (int i = 0; i < courses.length(); ++i) {
            JSONObject course = courses.getJSONObject(i);
            if (course.getBoolean("archived")) continue;
            classes.add(course.getString("name"));
        }
        Collections.sort(classes);
        return classes;
    }

    @Override
    public List<String> getAllTeachers() throws IOException, JSONException, CredentialInvalidException {
        ArrayList<String> teachers = new ArrayList<String>();
        JSONArray jsonTeachers = this.getTeachers();
        if (jsonTeachers == null) {
            return null;
        }
        for (int i = 0; i < jsonTeachers.length(); ++i) {
            JSONObject teacher = jsonTeachers.getJSONObject(i);
            if (teacher.getBoolean("archived")) continue;
            teachers.add(teacher.getString("name"));
        }
        Collections.sort(teachers);
        return teachers;
    }
}

