/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.AdditionalInfo;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.objects.credential.PasswordCredential;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SchoolJoomlaParser
extends BaseParser {
    private static final String PARAM_BASEURL = "baseurl";
    private static final Pattern CLASSES_REGEX = Pattern.compile("(.*) \\[<I>(.*)</I>\\]");

    SchoolJoomlaParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        JSONObject config = this.getConfiguration();
        JSONObject data = this.getData();
        SubstitutionSchedule schedule = SubstitutionSchedule.fromData(this.scheduleData);
        schedule.setLastChange(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").parseLocalDateTime(data.getString("lastupdate")));
        if (this.scheduleData.getType() == SubstitutionSchedule.Type.STUDENT) {
            JSONObject substs = data.getJSONObject("vertretungsplan").getJSONObject("schuelervertretungen");
            Iterator datesIter = substs.keys();
            while (datesIter.hasNext()) {
                String dateStr = (String)datesIter.next();
                if (dateStr.equals("elementscount")) continue;
                LocalDate date = DateTimeFormat.forPattern((String)"yyyy-MM-dd").parseLocalDate(dateStr);
                SubstitutionScheduleDay day = new SubstitutionScheduleDay();
                day.setDate(date);
                JSONObject dayJson = substs.getJSONObject(dateStr);
                Iterator classesIter = dayJson.keys();
                while (classesIter.hasNext()) {
                    String klasse = (String)classesIter.next();
                    Matcher matcher = CLASSES_REGEX.matcher(klasse);
                    HashSet<String> classes = new HashSet<String>();
                    if (klasse.equals("elementscount")) continue;
                    if (matcher.matches()) {
                        String[] letters;
                        String year = matcher.group(1);
                        for (String letter : letters = matcher.group(2).split(", ")) {
                            classes.add(year + letter);
                        }
                    } else {
                        classes.add(klasse);
                    }
                    for (int i = 0; i < dayJson.getJSONArray(klasse).length(); ++i) {
                        String art;
                        JSONObject subst = dayJson.getJSONArray(klasse).getJSONObject(i);
                        Substitution s = new Substitution();
                        s.setClasses(classes);
                        s.setLesson(subst.getString("stunden"));
                        s.setPreviousSubject(this.emptyToNull(subst.getString("fach")));
                        s.setSubject(this.emptyToNull(subst.getString("vfach")));
                        s.setPreviousRoom(this.emptyToNull(subst.getString("raum")));
                        s.setRoom(this.emptyToNull(subst.getString("vraum")));
                        s.setPreviousTeacher(this.emptyToNull(subst.getString("lehrerkuerzel")));
                        s.setTeacher(this.emptyToNull(subst.getString("verlehrerkuerzel")));
                        s.setDesc(this.emptyToNull(subst.getString("kommentar")));
                        switch (art = subst.getString("art")) {
                            case "V": {
                                s.setType("Vertretung");
                                break;
                            }
                            case "C": {
                                s.setType("Entfall");
                                break;
                            }
                            case "R": {
                                s.setType("Verlegung");
                                break;
                            }
                            case "FC": {
                                s.setType("Entf\u00e4llt - Verlegung");
                                break;
                            }
                            case "EVA": {
                                s.setType("EVA");
                                break;
                            }
                            case "F": {
                                s.setType("Verlegt");
                                break;
                            }
                            case "A": 
                            case "S": {
                                s.setType("Sondereinsatz");
                                break;
                            }
                            case "E": {
                                s.setType("Klausur");
                                break;
                            }
                            default: {
                                throw new IOException("unknown: " + art);
                            }
                        }
                        s.setColor(this.colorProvider.getColor(s.getType()));
                        day.addSubstitution(s);
                    }
                }
                schedule.addDay(day);
            }
            JSONArray ticker = data.getJSONObject("vertretungsplan").getJSONArray("schuelernewsticker");
            if (ticker.length() > 0) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < ticker.length(); ++i) {
                    if (i > 0) {
                        builder.append("\n\n");
                    }
                    builder.append(ticker.getString(i));
                }
                AdditionalInfo info = new AdditionalInfo();
                info.setTitle("Newsticker");
                info.setText(builder.toString());
                info.setHasInformation(false);
                info.setFromSchedule(true);
                schedule.addAdditionalInfo(info);
            }
        } else if (this.scheduleData.getType() == SubstitutionSchedule.Type.TEACHER) {
            throw new IOException("not yet supported");
        }
        schedule.setClasses(this.getClasses(data));
        schedule.setTeachers(this.getAllTeachers());
        return schedule;
    }

    private String emptyToNull(String s) {
        return s.isEmpty() ? null : s;
    }

    private JSONObject getData() throws IOException, CredentialInvalidException, JSONException {
        return this.executeTask("getAllData");
    }

    private JSONObject getConfiguration() throws IOException, CredentialInvalidException, JSONException {
        return this.executeTask("getConfiguration");
    }

    @NotNull
    private JSONObject executeTask(String task) throws JSONException, IOException, CredentialInvalidException {
        JSONObject data;
        int error;
        String json;
        String baseurl = this.scheduleData.getData().getString(PARAM_BASEURL);
        String username = "";
        String password = "";
        if (this.credential != null) {
            if (this.credential instanceof UserPasswordCredential) {
                if (this.scheduleData.getType() != SubstitutionSchedule.Type.TEACHER) {
                    throw new IOException("student schedules only have passwords or no password");
                }
                username = ((UserPasswordCredential)this.credential).getUsername();
                password = ((UserPasswordCredential)this.credential).getPassword();
            } else if (this.credential instanceof PasswordCredential) {
                if (this.scheduleData.getType() != SubstitutionSchedule.Type.STUDENT) {
                    throw new IOException("teacher schedules need a username");
                }
                password = ((PasswordCredential)this.credential).getPassword();
            }
        }
        if (!(json = this.httpGet(baseurl + "/components/com_school_mobile/wserv/service" + ".php?select=&user=" + username + "&pw=" + password + "&task=" + task, "UTF-8")).startsWith("{") && json.contains("{")) {
            json = json.substring(json.indexOf("{"));
        }
        if ((error = (data = new JSONObject(json)).getInt("error")) != 0 || data.getJSONArray("errors").length() > 0) {
            switch (error) {
                case 12: 
                case 17: {
                    throw new CredentialInvalidException();
                }
                case 3002: {
                    if (this.scheduleData.getType() != SubstitutionSchedule.Type.TEACHER) break;
                    throw new CredentialInvalidException();
                }
                default: {
                    throw new IOException(data.getString("error_desc"));
                }
            }
        }
        return data;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException, CredentialInvalidException {
        JSONObject config = this.getConfiguration();
        JSONObject data = this.getData();
        return this.getClasses(data);
    }

    @NotNull
    private List<String> getClasses(JSONObject data) throws JSONException {
        ArrayList<String> classes = new ArrayList<String>();
        JSONArray klassenjgst = data.getJSONArray("klassenjgst");
        for (int i = 0; i < klassenjgst.length(); ++i) {
            classes.add(klassenjgst.getJSONObject(i).getString("name"));
        }
        return classes;
    }

    @Override
    public List<String> getAllTeachers() throws IOException, JSONException, CredentialInvalidException {
        return new ArrayList<String>();
    }
}

