/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import org.apache.http.client.fluent.Request;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CSVParser
extends BaseParser {
    private static final String PARAM_SEPARATOR = "separator";
    private static final String PARAM_SKIP_LINES = "skipLines";
    private static final String PARAM_COLUMNS = "columns";
    private static final String PARAM_WEBSITE = "website";
    private static final String PARAM_CLASSES_URL = "classesUrl";
    private static final String PARAM_CLASSES = "classes";
    private static final String PARAM_URL = "url";
    private JSONObject data;

    public CSVParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        String url = this.data.getString(PARAM_URL);
        String response = this.executor.execute(Request.Get((String)url)).returnContent().asString();
        return this.parseCSV(response);
    }

    @NotNull
    SubstitutionSchedule parseCSV(String response) throws JSONException, IOException {
        SubstitutionSchedule schedule = SubstitutionSchedule.fromData(this.scheduleData);
        String[] lines = response.split("\n");
        String separator = this.data.getString(PARAM_SEPARATOR);
        for (int i = this.data.optInt(PARAM_SKIP_LINES, 0); i < lines.length; ++i) {
            String[] columns = lines[i].split(separator);
            Substitution v = new Substitution();
            String dayName = null;
            String stand = "";
            int j = 0;
            for (String column : columns) {
                String type;
                switch (type = this.data.getJSONArray(PARAM_COLUMNS).getString(j)) {
                    case "lesson": {
                        v.setLesson(column);
                        break;
                    }
                    case "subject": {
                        v.setSubject(column);
                        break;
                    }
                    case "previousSubject": {
                        v.setPreviousSubject(column);
                        break;
                    }
                    case "type": {
                        v.setType(column);
                        v.setColor(this.colorProvider.getColor(column));
                        break;
                    }
                    case "type-entfall": {
                        if (column.equals("x")) {
                            v.setType("Entfall");
                            v.setColor(this.colorProvider.getColor("Entfall"));
                            break;
                        }
                        v.setType("Vertretung");
                        v.setColor(this.colorProvider.getColor("Vertretung"));
                        break;
                    }
                    case "room": {
                        v.setRoom(column);
                        break;
                    }
                    case "teacher": {
                        v.setTeacher(column);
                        break;
                    }
                    case "previousTeacher": {
                        v.setPreviousTeacher(column);
                        break;
                    }
                    case "desc": {
                        v.setDesc(column);
                        break;
                    }
                    case "desc-type": {
                        v.setDesc(column);
                        String recognizedType = CSVParser.recognizeType(column);
                        v.setType(recognizedType);
                        v.setColor(this.colorProvider.getColor(recognizedType));
                        break;
                    }
                    case "previousRoom": {
                        v.setPreviousRoom(column);
                        break;
                    }
                    case "class": {
                        v.getClasses().add(this.getClassName(column, this.data));
                        break;
                    }
                    case "day": {
                        dayName = column;
                        break;
                    }
                    case "stand": {
                        stand = column;
                        break;
                    }
                    case "ignore": {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown column type: " + column);
                    }
                }
                ++j;
            }
            if (v.getType() == null) {
                v.setType("Vertretung");
                v.setColor(this.colorProvider.getColor("Vertretung"));
            }
            if (dayName == null) continue;
            SubstitutionScheduleDay day = new SubstitutionScheduleDay();
            day.setDateString(dayName);
            day.setDate(ParserUtils.parseDate(dayName));
            day.setLastChangeString(stand);
            day.setLastChange(ParserUtils.parseDateTime(stand));
            day.addSubstitution(v);
            schedule.addDay(day);
        }
        if (this.scheduleData.getData().has(PARAM_WEBSITE)) {
            schedule.setWebsite(this.scheduleData.getData().getString(PARAM_WEBSITE));
        }
        schedule.setClasses(this.getAllClasses());
        schedule.setTeachers(this.getAllTeachers());
        return schedule;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        if (this.data.has(PARAM_CLASSES_URL)) {
            String url = this.data.getString(PARAM_CLASSES_URL);
            String response = this.executor.execute(Request.Get((String)url)).returnContent().asString();
            ArrayList<String> classes = new ArrayList<String>();
            for (String string : response.split("\n")) {
                classes.add(string.trim());
            }
            return classes;
        }
        JSONArray classesJson = this.data.getJSONArray(PARAM_CLASSES);
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < classesJson.length(); ++i) {
            classes.add(classesJson.getString(i));
        }
        return classes;
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

