/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.objects.diff;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.vertretungsplan.objects.AdditionalInfo;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.objects.diff.SubstitutionDiff;
import me.vertretungsplan.objects.diff.SubstitutionScheduleDayDiff;

public class SubstitutionScheduleDiff
implements Cloneable {
    private List<AdditionalInfo> newAdditionalInfos;
    private List<AdditionalInfo> removedAdditionalInfos;
    private List<SubstitutionScheduleDay> newDays;
    private List<SubstitutionScheduleDayDiff> editedDays;
    private List<SubstitutionScheduleDay> removedDays;

    public static SubstitutionScheduleDiff compare(SubstitutionSchedule a, SubstitutionSchedule b) {
        SubstitutionScheduleDiff diff = new SubstitutionScheduleDiff();
        diff.newAdditionalInfos = new ArrayList<AdditionalInfo>();
        diff.removedAdditionalInfos = new ArrayList<AdditionalInfo>();
        diff.newDays = new ArrayList<SubstitutionScheduleDay>();
        diff.editedDays = new ArrayList<SubstitutionScheduleDayDiff>();
        diff.removedDays = new ArrayList<SubstitutionScheduleDay>();
        for (AdditionalInfo newInfo : b.getAdditionalInfos()) {
            if (a.getAdditionalInfos().contains(newInfo)) continue;
            diff.newAdditionalInfos.add(newInfo);
        }
        for (AdditionalInfo oldInfo : a.getAdditionalInfos()) {
            if (b.getAdditionalInfos().contains(oldInfo)) continue;
            diff.removedAdditionalInfos.add(oldInfo);
        }
        for (SubstitutionScheduleDay newDay : b.getDays()) {
            SubstitutionScheduleDay oldDay = SubstitutionScheduleDiff.findSameDateDay(newDay, a.getDays());
            if (oldDay != null) {
                SubstitutionScheduleDayDiff dayDiff = SubstitutionScheduleDayDiff.compare(oldDay, newDay);
                if (!dayDiff.isNotEmpty()) continue;
                diff.editedDays.add(dayDiff);
                continue;
            }
            diff.newDays.add(newDay);
        }
        for (SubstitutionScheduleDay oldDay : a.getDays()) {
            SubstitutionScheduleDay newDay = SubstitutionScheduleDiff.findSameDateDay(oldDay, b.getDays());
            if (newDay != null) continue;
            diff.removedDays.add(oldDay);
        }
        return diff;
    }

    private static SubstitutionScheduleDay findSameDateDay(SubstitutionScheduleDay day, List<SubstitutionScheduleDay> days) {
        for (SubstitutionScheduleDay currentDay : days) {
            if (!currentDay.equalsByDate(day)) continue;
            return currentDay;
        }
        return null;
    }

    public static Set<SubstitutionDiff> filterByClass(String theClass, Set<SubstitutionDiff> substitutions) {
        if (theClass == null) {
            return substitutions;
        }
        HashSet<SubstitutionDiff> classSubstitutions = new HashSet<SubstitutionDiff>();
        for (SubstitutionDiff substitution : substitutions) {
            if (!substitution.getClasses().contains(theClass)) continue;
            classSubstitutions.add(substitution);
        }
        return classSubstitutions;
    }

    public static Set<SubstitutionDiff> filterBySubject(Set<String> excludedSubjects, Set<SubstitutionDiff> substitutions) {
        if (excludedSubjects == null || excludedSubjects.isEmpty()) {
            return substitutions;
        }
        HashSet<SubstitutionDiff> filteredSubstitutions = new HashSet<SubstitutionDiff>();
        for (SubstitutionDiff substitution : substitutions) {
            if (substitution.getNewSubstitution().getPreviousSubject() != null) {
                if (excludedSubjects.contains(substitution.getNewSubstitution().getPreviousSubject())) continue;
                filteredSubstitutions.add(substitution);
                continue;
            }
            if (substitution.getNewSubstitution().getSubject() == null || excludedSubjects.contains(substitution.getNewSubstitution().getSubject())) continue;
            filteredSubstitutions.add(substitution);
        }
        return filteredSubstitutions;
    }

    public static Set<SubstitutionDiff> filterByTeacher(String teacher, Set<SubstitutionDiff> substitutions) {
        if (teacher == null) {
            return substitutions;
        }
        HashSet<SubstitutionDiff> teacherSubstitutions = new HashSet<SubstitutionDiff>();
        for (SubstitutionDiff substitution : substitutions) {
            if (!teacher.equals(substitution.getOldSubstitution().getTeacher()) && !teacher.equals(substitution.getOldSubstitution().getPreviousTeacher()) && !teacher.equals(substitution.getNewSubstitution().getTeacher()) && !teacher.equals(substitution.getNewSubstitution().getPreviousTeacher())) continue;
            teacherSubstitutions.add(substitution);
        }
        return teacherSubstitutions;
    }

    public List<AdditionalInfo> getNewAdditionalInfos() {
        return this.newAdditionalInfos;
    }

    public void setNewAdditionalInfos(List<AdditionalInfo> newAdditionalInfos) {
        this.newAdditionalInfos = newAdditionalInfos;
    }

    public List<AdditionalInfo> getRemovedAdditionalInfos() {
        return this.removedAdditionalInfos;
    }

    public void setRemovedAdditionalInfos(List<AdditionalInfo> removedAdditionalInfos) {
        this.removedAdditionalInfos = removedAdditionalInfos;
    }

    public List<SubstitutionScheduleDay> getNewDays() {
        return this.newDays;
    }

    public void setNewDays(List<SubstitutionScheduleDay> newDays) {
        this.newDays = newDays;
    }

    public List<SubstitutionScheduleDayDiff> getEditedDays() {
        return this.editedDays;
    }

    public void setEditedDays(List<SubstitutionScheduleDayDiff> editedDays) {
        this.editedDays = editedDays;
    }

    public List<SubstitutionScheduleDay> getRemovedDays() {
        return this.removedDays;
    }

    public void setRemovedDays(List<SubstitutionScheduleDay> removedDays) {
        this.removedDays = removedDays;
    }

    public boolean isEmpty() {
        boolean dayDiffsEmpty = true;
        for (SubstitutionScheduleDayDiff dayDiff : this.editedDays) {
            if (!dayDiff.isNotEmpty()) continue;
            dayDiffsEmpty = false;
            break;
        }
        return this.newAdditionalInfos.isEmpty() && this.removedAdditionalInfos.isEmpty() && this.newDays.isEmpty() && this.removedDays.isEmpty() && dayDiffsEmpty;
    }

    public SubstitutionScheduleDiff clone() {
        try {
            return (SubstitutionScheduleDiff)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public SubstitutionScheduleDiff filteredByClassAndExcludedSubject(String theClass, Set<String> excludedSubjects) {
        SubstitutionScheduleDiff filteredScheduleDiff = this.clone();
        this.filterDaysClass(theClass, excludedSubjects, filteredScheduleDiff.getNewDays());
        this.filterDayDiffsClass(theClass, excludedSubjects, filteredScheduleDiff.getEditedDays());
        this.filterDaysClass(theClass, excludedSubjects, filteredScheduleDiff.getRemovedDays());
        return filteredScheduleDiff;
    }

    public SubstitutionScheduleDiff filteredByTeacherAndExcludedSubject(String teacher, Set<String> excludedSubjects) {
        SubstitutionScheduleDiff filteredScheduleDiff = this.clone();
        this.filterDaysTeacher(teacher, excludedSubjects, filteredScheduleDiff.getNewDays());
        this.filterDayDiffsTeacher(teacher, excludedSubjects, filteredScheduleDiff.getEditedDays());
        this.filterDaysTeacher(teacher, excludedSubjects, filteredScheduleDiff.getRemovedDays());
        return filteredScheduleDiff;
    }

    private void filterDayDiffsClass(String theClass, Set<String> excludedSubjects, List<SubstitutionScheduleDayDiff> dayDiffs) {
        for (int i = 0; i < dayDiffs.size(); ++i) {
            SubstitutionScheduleDayDiff dayDiff = dayDiffs.get(i);
            SubstitutionScheduleDayDiff filteredDayDiff = dayDiff.clone();
            filteredDayDiff.setNewSubstitutions(dayDiff.getNewSubstitutionsByClassAndExcludedSubject(theClass, excludedSubjects));
            filteredDayDiff.setRemovedSubstitutions(dayDiff.getRemovedSubstitutionsByClassAndExcludedSubject(theClass, excludedSubjects));
            filteredDayDiff.setEditedSubstitutions(dayDiff.getEditedSubstitutionsByClassAndExcludedSubject(theClass, excludedSubjects));
            dayDiffs.set(i, filteredDayDiff);
        }
    }

    private void filterDaysClass(String theClass, Set<String> excludedSubjects, List<SubstitutionScheduleDay> days) {
        for (int i = 0; i < days.size(); ++i) {
            SubstitutionScheduleDay day = days.get(i);
            SubstitutionScheduleDay filteredDay = day.clone();
            filteredDay.setSubstitutions(day.getSubstitutionsByClassAndExcludedSubject(theClass, excludedSubjects));
            days.set(i, filteredDay);
        }
    }

    private void filterDayDiffsTeacher(String teacher, Set<String> excludedSubjects, List<SubstitutionScheduleDayDiff> dayDiffs) {
        for (int i = 0; i < dayDiffs.size(); ++i) {
            SubstitutionScheduleDayDiff dayDiff = dayDiffs.get(i);
            SubstitutionScheduleDayDiff filteredDayDiff = dayDiff.clone();
            filteredDayDiff.setNewSubstitutions(dayDiff.getNewSubstitutionsByTeacherAndExcludedSubject(teacher, excludedSubjects));
            filteredDayDiff.setRemovedSubstitutions(dayDiff.getRemovedSubstitutionsByTeacherAndExcludedSubject(teacher, excludedSubjects));
            filteredDayDiff.setEditedSubstitutions(dayDiff.getEditedSubstitutionsByTeacherAndExcludedSubject(teacher, excludedSubjects));
            dayDiffs.set(i, filteredDayDiff);
        }
    }

    private void filterDaysTeacher(String teacher, Set<String> excludedSubjects, List<SubstitutionScheduleDay> days) {
        for (int i = 0; i < days.size(); ++i) {
            SubstitutionScheduleDay day = days.get(i);
            SubstitutionScheduleDay filteredDay = day.clone();
            filteredDay.setSubstitutions(day.getSubstitutionsByTeacherAndExcludedSubject(teacher, excludedSubjects));
            days.set(i, filteredDay);
        }
    }
}

