/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.objects;

import com.paour.comparator.NaturalOrderComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.vertretungsplan.objects.AdditionalInfo;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SubstitutionSchedule
implements Cloneable {
    static final DateTimeFormatter DAY_DATE_FORMAT = DateTimeFormat.forPattern((String)"EEEE, dd.MM.yyyy").withLocale(Locale.GERMAN);
    static final DateTimeFormatter LAST_CHANGE_DATE_FORMAT = DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm").withLocale(Locale.GERMAN);
    private Type type;
    private LocalDateTime lastChange;
    private String lastChangeString;
    private String website;
    private List<SubstitutionScheduleDay> days;
    private List<AdditionalInfo> additionalInfos;
    private List<String> classes;
    private List<String> teachers;

    public SubstitutionSchedule() {
        this.days = new ArrayList<SubstitutionScheduleDay>();
        this.additionalInfos = new ArrayList<AdditionalInfo>();
        this.classes = new ArrayList<String>();
        this.teachers = new ArrayList<String>();
    }

    public SubstitutionSchedule(SubstitutionSchedule other) {
        this.type = other.type;
        this.lastChange = other.lastChange;
        this.lastChangeString = other.lastChangeString;
        this.website = other.website;
        this.days = other.days;
        this.additionalInfos = other.additionalInfos;
        this.classes = other.classes;
        this.teachers = other.teachers;
    }

    public static SubstitutionSchedule fromData(SubstitutionScheduleData scheduleData) {
        SubstitutionSchedule schedule = new SubstitutionSchedule();
        schedule.setType(scheduleData.getType());
        return schedule;
    }

    public static Set<Substitution> filterByClass(String theClass, Set<Substitution> substitutions) {
        if (theClass == null) {
            return substitutions;
        }
        HashSet<Substitution> classSubstitutions = new HashSet<Substitution>();
        for (Substitution substitution : substitutions) {
            if (!substitution.getClasses().contains(theClass)) continue;
            classSubstitutions.add(substitution);
        }
        return classSubstitutions;
    }

    public static Set<Substitution> filterBySubject(Set<String> excludedSubjects, Set<Substitution> substitutions) {
        if (excludedSubjects == null || excludedSubjects.isEmpty()) {
            return substitutions;
        }
        HashSet<Substitution> filteredSubstitutions = new HashSet<Substitution>();
        for (Substitution substitution : substitutions) {
            if (substitution.getPreviousSubject() != null) {
                if (excludedSubjects.contains(substitution.getPreviousSubject())) continue;
                filteredSubstitutions.add(substitution);
                continue;
            }
            if (substitution.getSubject() == null || excludedSubjects.contains(substitution.getSubject())) continue;
            filteredSubstitutions.add(substitution);
        }
        return filteredSubstitutions;
    }

    public static Set<Substitution> filterByTeacher(String teacher, Set<Substitution> substitutions) {
        if (teacher == null) {
            return substitutions;
        }
        HashSet<Substitution> teacherSubstitutions = new HashSet<Substitution>();
        for (Substitution substitution : substitutions) {
            if (!teacher.equals(substitution.getTeacher()) && !teacher.equals(substitution.getPreviousTeacher())) continue;
            teacherSubstitutions.add(substitution);
        }
        return teacherSubstitutions;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public LocalDateTime getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(LocalDateTime lastChange) {
        this.lastChange = lastChange;
    }

    public String getLastChangeString() {
        if (this.lastChangeString != null) {
            return this.lastChangeString;
        }
        if (this.lastChange != null) {
            return LAST_CHANGE_DATE_FORMAT.print((ReadablePartial)this.lastChange);
        }
        return null;
    }

    public void setLastChangeString(String lastChangeString) {
        this.lastChangeString = lastChangeString;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public List<SubstitutionScheduleDay> getDays() {
        return this.days;
    }

    public void addDay(SubstitutionScheduleDay newDay) {
        if (this.lastChange == null && this.lastChangeString == null) {
            if (newDay.getLastChange() != null) {
                this.lastChange = newDay.getLastChange();
            } else if (newDay.getLastChangeString() != null) {
                this.lastChangeString = newDay.getLastChangeString();
            }
        } else if (this.lastChange != null && newDay.getLastChange() != null && newDay.getLastChange().isAfter((ReadablePartial)this.lastChange)) {
            this.lastChange = newDay.getLastChange();
        }
        this.addOrMergeDay(newDay);
        Collections.sort(this.days, new Comparator<SubstitutionScheduleDay>(){

            @Override
            public int compare(SubstitutionScheduleDay a, SubstitutionScheduleDay b) {
                if (a.getDate() != null && b.getDate() != null) {
                    return a.getDate().compareTo((ReadablePartial)b.getDate());
                }
                if (a.getDateString() != null && b.getDateString() != null) {
                    NaturalOrderComparator comp = new NaturalOrderComparator();
                    return comp.compare(a.getDateString(), b.getDateString());
                }
                if (a.getDateString() != null) {
                    return 1;
                }
                if (b.getDateString() != null) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private void addOrMergeDay(SubstitutionScheduleDay newDay) {
        for (SubstitutionScheduleDay day : this.days) {
            if (!day.equalsByDate(newDay)) continue;
            day.merge(newDay);
            return;
        }
        this.days.add(newDay);
    }

    public List<AdditionalInfo> getAdditionalInfos() {
        return this.additionalInfos;
    }

    public void addAdditionalInfo(AdditionalInfo info) {
        this.additionalInfos.add(info);
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    public List<String> getTeachers() {
        return this.teachers;
    }

    public void setTeachers(List<String> teachers) {
        this.teachers = teachers;
    }

    public SubstitutionSchedule clone() {
        try {
            return (SubstitutionSchedule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public SubstitutionSchedule filteredByClassAndExcludedSubject(String theClass, Set<String> excludedSubjects) {
        SubstitutionSchedule filteredSchedule = this.clone();
        this.filterByClassAndExcludedSubject(filteredSchedule, theClass, excludedSubjects);
        return filteredSchedule;
    }

    protected void filterByClassAndExcludedSubject(SubstitutionSchedule filteredSchedule, String theClass, Set<String> excludedSubjects) {
        for (int i = 0; i < filteredSchedule.getDays().size(); ++i) {
            SubstitutionScheduleDay day = filteredSchedule.getDays().get(i);
            SubstitutionScheduleDay filteredDay = day.clone();
            filteredDay.setSubstitutions(day.getSubstitutionsByClassAndExcludedSubject(theClass, excludedSubjects));
            filteredSchedule.getDays().set(i, filteredDay);
        }
        if (theClass != null) {
            ArrayList<String> classes = new ArrayList<String>();
            classes.add(theClass);
            filteredSchedule.setClasses(classes);
        }
    }

    public SubstitutionSchedule filteredByTeacherAndExcludedSubject(String teacher, Set<String> excludedSubjects) {
        SubstitutionSchedule filteredSchedule = this.clone();
        this.filterByTeacherAndExcludedSubject(filteredSchedule, teacher, excludedSubjects);
        return filteredSchedule;
    }

    protected void filterByTeacherAndExcludedSubject(SubstitutionSchedule filteredSchedule, String teacher, Set<String> excludedSubjects) {
        for (int i = 0; i < filteredSchedule.getDays().size(); ++i) {
            SubstitutionScheduleDay day = filteredSchedule.getDays().get(i);
            SubstitutionScheduleDay filteredDay = day.clone();
            filteredDay.setSubstitutions(day.getSubstitutionsByTeacherAndExcludedSubject(teacher, excludedSubjects));
            filteredSchedule.getDays().set(i, filteredDay);
        }
        if (teacher != null) {
            ArrayList<String> teachers = new ArrayList<String>();
            teachers.add(teacher);
            filteredSchedule.setTeachers(teachers);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("--------------------\n");
        builder.append("SubstitutionSchedule\n");
        builder.append("--------------------\n\n");
        builder.append("type: ").append((Object)this.type).append("\n");
        builder.append("last change: ").append(this.getLastChangeString()).append("\n");
        builder.append("website: ").append(this.website).append("\n");
        if (this.classes != null) {
            builder.append("classes: ").append(this.classes.toString()).append("\n");
        }
        if (this.teachers != null) {
            builder.append("teachers: ").append(this.teachers.toString()).append("\n");
        }
        builder.append("\n\n");
        builder.append("Schedule\n");
        builder.append("--------\n\n");
        for (SubstitutionScheduleDay day : this.days) {
            builder.append(day.toString(this.type)).append("\n\n");
        }
        if (this.additionalInfos.size() > 0) {
            builder.append("Additional Infos\n");
            builder.append("----------------\n\n");
            for (AdditionalInfo info : this.additionalInfos) {
                builder.append(info.getTitle()).append("\n").append(info.getText()).append("\n\n");
            }
        }
        return builder.toString();
    }

    public static enum Type {
        STUDENT,
        TEACHER;

    }
}

