/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.UntisCommonParser;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpResponseException;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.select.Elements;

public class DSBLightParser
extends UntisCommonParser {
    private static final String BASE_URL = "https://light.dsbcontrol.de/DSBlightWebsite/Homepage/";
    private static final String ENCODING = "UTF-8";
    private static final String PARAM_ID = "id";
    private static final String PARAM_LOGIN = "login";
    private static final String PARAM_CLASSES = "classes";
    private static final String PARAM_ENCODING = "encoding";
    private static final String PARAM_BASEURL = "baseurl";
    private static final String PARAM_IFRAME_INDEX = "iframeIndex";
    private JSONObject data;

    public DSBLightParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        String id = this.data.getString(PARAM_ID);
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        HashMap<String, String> referer = new HashMap<String, String>();
        String baseUrl = this.data.optString(PARAM_BASEURL, BASE_URL);
        referer.put("Referer", baseUrl + "/Player.aspx?ID=" + id);
        String response = this.httpGet(baseUrl + "/Player.aspx?ID=" + id, ENCODING, referer);
        Document doc = Jsoup.parse((String)response);
        String iframeUrl = doc.select("iframe").first().attr("src");
        response = this.httpGet(iframeUrl, ENCODING, referer);
        doc = Jsoup.parse((String)response);
        if (this.data.has(PARAM_LOGIN) && this.data.get(PARAM_LOGIN) instanceof Boolean && this.data.getBoolean(PARAM_LOGIN)) {
            if (!(this.credential instanceof UserPasswordCredential)) {
                throw new IllegalArgumentException("no login");
            }
            String username = ((UserPasswordCredential)this.credential).getUsername();
            String password = ((UserPasswordCredential)this.credential).getPassword();
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair("__VIEWSTATE", doc.select("#__VIEWSTATE").attr("value")));
            params.add((NameValuePair)new BasicNameValuePair("__VIEWSTATEGENERATOR", doc.select("#__VIEWSTATEGENERATOR").attr("value")));
            params.add((NameValuePair)new BasicNameValuePair("__EVENTVALIDATION", doc.select("#__EVENTVALIDATION").attr("value")));
            params.add((NameValuePair)new BasicNameValuePair("ctl02$txtBenutzername", username));
            params.add((NameValuePair)new BasicNameValuePair("ctl02$txtPasswort", password));
            params.add((NameValuePair)new BasicNameValuePair("ctl02$btnLogin", "weiter"));
            response = this.httpPost(iframeUrl, ENCODING, params, referer);
            doc = Jsoup.parse((String)response);
            if (doc.select("#ctl02_lblLoginFehlgeschlagen").size() > 0) {
                throw new CredentialInvalidException();
            }
        } else if (this.data.has(PARAM_LOGIN) && this.data.get(PARAM_LOGIN) instanceof JSONObject) {
            new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        }
        Elements iframes = doc.select("iframe");
        if (this.data.has(PARAM_IFRAME_INDEX)) {
            this.parsePreProgram(v, referer, (Element)iframes.get(this.data.getInt(PARAM_IFRAME_INDEX)));
        } else {
            for (Element iframe : iframes) {
                this.parsePreProgram(v, referer, iframe);
            }
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        v.setWebsite(baseUrl + "/Player.aspx?ID=" + id);
        return v;
    }

    private void parsePreProgram(SubstitutionSchedule v, Map<String, String> referer, Element iframe) throws IOException, CredentialInvalidException, JSONException {
        String response2;
        Pattern regex = Pattern.compile("location\\.href=\"([^\"]*)\"");
        Matcher matcher = regex.matcher(response2 = this.httpGet(iframe.attr("src"), ENCODING, referer));
        if (!matcher.find()) {
            throw new IOException("URL nicht gefunden");
        }
        String url = matcher.group(1);
        this.parseProgram(url, v, referer);
    }

    private void parseProgram(String url, SubstitutionSchedule schedule, Map<String, String> referer) throws IOException, JSONException, CredentialInvalidException {
        String response = this.httpGet(url, ENCODING, referer);
        this.parseProgram(url, response, schedule, referer, null);
    }

    private void parseProgram(String url, String html, SubstitutionSchedule schedule, Map<String, String> referer, String firstUrl) throws IOException, JSONException, CredentialInvalidException {
        Document doc = Jsoup.parse((String)html, (String)url);
        if (doc.select("iframe").attr("src").equals(firstUrl) || doc.select("iframe").size() == 0) {
            return;
        }
        for (Element iframe : doc.select("iframe")) {
            this.parseDay(iframe.attr("src"), referer, schedule, iframe.attr("src"));
        }
        if (firstUrl == null) {
            firstUrl = doc.select("iframe").attr("src");
        }
        if (doc.select("#hlNext").size() > 0) {
            String nextUrl = doc.select("#hlNext").first().attr("abs:href");
            try {
                String response = this.httpGet(nextUrl, ENCODING, referer);
                this.parseProgram(response, nextUrl, schedule, referer, firstUrl);
            }
            catch (HttpResponseException response) {
                // empty catch block
            }
        }
        if (html.contains("Timer1")) {
            List formData = ((FormElement)doc.select("form").first()).formData();
            ArrayList<NameValuePair> formParams = new ArrayList<NameValuePair>();
            for (Connection.KeyVal kv : formData) {
                formParams.add((NameValuePair)new BasicNameValuePair(kv.key(), kv.value()));
            }
            formParams.add((NameValuePair)new BasicNameValuePair("__EVENTTARGET", "Timer1"));
            formParams.add((NameValuePair)new BasicNameValuePair("__EVENTARGUMENT", ""));
            String response = this.httpPost(url, ENCODING, formParams, referer);
            this.parseProgram(url, response, schedule, referer, firstUrl);
        }
    }

    private void parseDay(String url, Map<String, String> referer, SubstitutionSchedule schedule, String startUrl) throws IOException, JSONException, CredentialInvalidException {
        String html = this.httpGet(url, this.data.optString(PARAM_ENCODING, null), referer);
        Document doc = Jsoup.parse((String)html);
        if (doc.title().toLowerCase().contains("untis") || doc.html().toLowerCase().contains("untis") || doc.select(".mon_list").size() > 0) {
            this.parseMultipleMonitorDays(schedule, doc, this.data);
            if (doc.select("meta[http-equiv=refresh]").size() > 0) {
                Element meta = doc.select("meta[http-equiv=refresh]").first();
                String attr = meta.attr("content").toLowerCase();
                String redirectUrl = url.substring(0, url.lastIndexOf("/") + 1) + attr.substring(attr.indexOf("url=") + 4);
                if (!redirectUrl.equals(startUrl)) {
                    this.parseDay(redirectUrl, referer, schedule, startUrl);
                }
            }
        }
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

