/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.networking.MultiTrustManager;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.credential.Credential;
import me.vertretungsplan.parser.CSVParser;
import me.vertretungsplan.parser.ColorProvider;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.DSBLightParser;
import me.vertretungsplan.parser.DSBMobileParser;
import me.vertretungsplan.parser.DaVinciParser;
import me.vertretungsplan.parser.DebuggingDataHandler;
import me.vertretungsplan.parser.ESchoolParser;
import me.vertretungsplan.parser.IndiwareMobileParser;
import me.vertretungsplan.parser.IndiwareParser;
import me.vertretungsplan.parser.IndiwareStundenplan24Parser;
import me.vertretungsplan.parser.LegionBoardParser;
import me.vertretungsplan.parser.ParserUtils;
import me.vertretungsplan.parser.SVPlanParser;
import me.vertretungsplan.parser.SchoolJoomlaParser;
import me.vertretungsplan.parser.SubstitutionScheduleParser;
import me.vertretungsplan.parser.TurboVertretungParser;
import me.vertretungsplan.parser.UntisInfoHeadlessParser;
import me.vertretungsplan.parser.UntisInfoParser;
import me.vertretungsplan.parser.UntisMonitorParser;
import me.vertretungsplan.parser.UntisSubstitutionParser;
import me.vertretungsplan.parser.WebUntisParser;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.universalchardet.UniversalDetector;

public abstract class BaseParser
implements SubstitutionScheduleParser {
    public static final String PARAM_CLASS_REGEX = "classRegex";
    private static final String PARAM_SSL_HOSTNAME = "sslHostname";
    protected SubstitutionScheduleData scheduleData;
    protected Executor executor;
    protected Credential credential;
    protected CookieStore cookieStore;
    protected ColorProvider colorProvider;
    protected CookieProvider cookieProvider;
    protected UniversalDetector encodingDetector;
    protected DebuggingDataHandler debuggingDataHandler;

    BaseParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        this.scheduleData = scheduleData;
        this.cookieProvider = cookieProvider;
        this.cookieStore = new BasicCookieStore();
        this.colorProvider = new ColorProvider(scheduleData);
        this.encodingDetector = new UniversalDetector(null);
        this.debuggingDataHandler = new NoOpDebuggingDataHandler();
        try {
            KeyStore ks = this.loadKeyStore();
            MultiTrustManager multiTrustManager = new MultiTrustManager();
            multiTrustManager.addTrustManager(BaseParser.getDefaultTrustManager());
            multiTrustManager.addTrustManager(BaseParser.trustManagerFromKeystore(ks));
            TrustManager[] trustManagers = new TrustManager[]{multiTrustManager};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, null);
            Object hostnameVerifier = scheduleData.getData() != null && scheduleData.getData().has(PARAM_SSL_HOSTNAME) ? new CustomHostnameVerifier(scheduleData.getData().getString(PARAM_SSL_HOSTNAME)) : new DefaultHostnameVerifier();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, (HostnameVerifier)hostnameVerifier);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).build();
            this.executor = Executor.newInstance((HttpClient)httpclient).use(this.cookieStore);
        }
        catch (IOException | GeneralSecurityException | JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static BaseParser getInstance(SubstitutionScheduleData data, @Nullable CookieProvider cookieProvider) {
        BaseParser parser = null;
        switch (data.getApi()) {
            case "untis-monitor": {
                parser = new UntisMonitorParser(data, cookieProvider);
                break;
            }
            case "untis-info": {
                parser = new UntisInfoParser(data, cookieProvider);
                break;
            }
            case "untis-info-headless": {
                parser = new UntisInfoHeadlessParser(data, cookieProvider);
                break;
            }
            case "untis-subst": {
                parser = new UntisSubstitutionParser(data, cookieProvider);
                break;
            }
            case "dsbmobile": {
                parser = new DSBMobileParser(data, cookieProvider);
                break;
            }
            case "dsblight": {
                parser = new DSBLightParser(data, cookieProvider);
                break;
            }
            case "svplan": {
                parser = new SVPlanParser(data, cookieProvider);
                break;
            }
            case "davinci": {
                parser = new DaVinciParser(data, cookieProvider);
                break;
            }
            case "eschool": {
                parser = new ESchoolParser(data, cookieProvider);
                break;
            }
            case "turbovertretung": {
                parser = new TurboVertretungParser(data, cookieProvider);
                break;
            }
            case "csv": {
                parser = new CSVParser(data, cookieProvider);
                break;
            }
            case "legionboard": {
                parser = new LegionBoardParser(data, cookieProvider);
                break;
            }
            case "indiware": {
                parser = new IndiwareParser(data, cookieProvider);
                break;
            }
            case "stundenplan24": {
                parser = new IndiwareStundenplan24Parser(data, cookieProvider);
                break;
            }
            case "indiware-mobile": {
                parser = new IndiwareMobileParser(data, cookieProvider);
                break;
            }
            case "webuntis": {
                parser = new WebUntisParser(data, cookieProvider);
                break;
            }
            case "schooljoomla": {
                parser = new SchoolJoomlaParser(data, cookieProvider);
            }
        }
        return parser;
    }

    private static X509TrustManager getDefaultTrustManager() throws GeneralSecurityException {
        return BaseParser.trustManagerFromKeystore(null);
    }

    private static X509TrustManager trustManagerFromKeystore(KeyStore keystore) throws GeneralSecurityException {
        TrustManager[] tms;
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "SunJSSE");
        trustManagerFactory.init(keystore);
        for (TrustManager tm : tms = trustManagerFactory.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)X509TrustManager.class.cast(tm);
        }
        throw new IllegalStateException("Could not locate X509TrustManager!");
    }

    protected static String recognizeType(String text) {
        if (text.toLowerCase().contains("f.a.") || text.toLowerCase().contains("f\u00e4llt aus") || text.toLowerCase().contains("faellt aus") || text.toLowerCase().contains("entf\u00e4llt") || text.toLowerCase().contains("entfall")) {
            return "Entfall";
        }
        if (BaseParser.equalsOneOf(text, "Raum\u00e4nderung", "Klasse frei", "Unterrichtstausch", "Freistunde", "Raumverlegung", "Selbstlernen", "Zusammenlegung", "HA", "Raum beachten", "Stundentausch", "Klausur", "Raum-Vertr.", "Betreuung", "Frei/Veranstaltung")) {
            return text;
        }
        if (text.contains("verschoben")) {
            return "Verlegung";
        }
        if (text.contains("ge\u00e4nderter Raum")) {
            return "Raum\u00e4nderung";
        }
        if (text.contains("frei")) {
            return "Entfall";
        }
        if (text.contains("Aufgaben")) {
            return "Aufgaben";
        }
        return null;
    }

    private static boolean equalsOneOf(String container, String ... strings) {
        for (String string : strings) {
            if (!container.equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public abstract SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException;

    public abstract List<String> getAllClasses() throws IOException, JSONException, CredentialInvalidException;

    public abstract List<String> getAllTeachers() throws IOException, JSONException, CredentialInvalidException;

    @Override
    public Credential getCredential() {
        return this.credential;
    }

    @Override
    public void setCredential(Credential credential) {
        if (!this.scheduleData.getAuthenticationData().getCredentialType().equals(credential.getClass())) {
            throw new IllegalArgumentException("Wrong credential type");
        }
        this.credential = credential;
    }

    public void setDebuggingDataHandler(DebuggingDataHandler handler) {
        this.debuggingDataHandler = handler;
    }

    protected String httpGet(String url, String encoding) throws IOException, CredentialInvalidException {
        return this.httpGet(url, encoding, null);
    }

    protected String httpGet(String url, String encoding, Map<String, String> headers) throws IOException, CredentialInvalidException {
        Request request = Request.Get((String)url).connectTimeout(15000).socketTimeout(15000);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return this.executeRequest(encoding, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String executeRequest(String encoding, Request request) throws IOException, CredentialInvalidException {
        try {
            byte[] bytes = this.executor.execute(request).returnContent().asBytes();
            encoding = this.getEncoding(encoding, bytes);
            String string = new String(bytes, encoding);
            return string;
        }
        catch (HttpResponseException e) {
            this.handleHttpResponseException(e);
            String string = null;
            return string;
        }
        finally {
            this.encodingDetector.reset();
        }
    }

    @NotNull
    private String getEncoding(String defaultEncoding, byte[] bytes) {
        this.encodingDetector.handleData(bytes, 0, bytes.length);
        this.encodingDetector.dataEnd();
        String encoding = this.encodingDetector.getDetectedCharset();
        if (encoding == null || encoding.equals("GB18030")) {
            encoding = defaultEncoding;
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        this.encodingDetector.reset();
        return encoding;
    }

    protected String httpPost(String url, String encoding, List<NameValuePair> formParams) throws IOException, CredentialInvalidException {
        return this.httpPost(url, encoding, formParams, null);
    }

    protected String httpPost(String url, String encoding, List<NameValuePair> formParams, Map<String, String> headers) throws IOException, CredentialInvalidException {
        Request request = Request.Post((String)url).bodyForm(formParams).connectTimeout(15000).socketTimeout(15000);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return this.executeRequest(encoding, request);
    }

    protected String httpPost(String url, String encoding, String body, ContentType contentType) throws IOException, CredentialInvalidException {
        return this.httpPost(url, encoding, body, contentType, null);
    }

    protected String httpPost(String url, String encoding, String body, ContentType contentType, Map<String, String> headers) throws IOException, CredentialInvalidException {
        Request request = Request.Post((String)url).bodyString(body, contentType).connectTimeout(15000).socketTimeout(15000);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return this.executeRequest(encoding, request);
    }

    private void handleHttpResponseException(HttpResponseException e) throws CredentialInvalidException, HttpResponseException {
        if (e.getStatusCode() == 401) {
            throw new CredentialInvalidException();
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        InputStream is = null;
        try {
            KeyStore ks = KeyStore.getInstance("BKS");
            is = this.getClass().getClassLoader().getResourceAsStream("trustStore.bks");
            if (is == null) {
                throw new RuntimeException();
            }
            ks.load(is, "Vertretungsplan".toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    String getClassName(String text, JSONObject data) throws JSONException {
        text = text.replace("(", "").replace(")", "");
        if (data.has(PARAM_CLASS_REGEX)) {
            Pattern pattern = Pattern.compile(data.getString(PARAM_CLASS_REGEX));
            Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                if (matcher.groupCount() > 0) {
                    return matcher.group(1);
                }
                return matcher.group();
            }
            return "";
        }
        return text;
    }

    protected boolean contains(JSONArray array, String string) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            if (!array.getString(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected List<String> getClassesFromJson() throws JSONException {
        JSONObject data = this.scheduleData.getData();
        return ParserUtils.getClassesFromJson(data);
    }

    @Override
    public boolean isPersonal() {
        return false;
    }

    private class NoOpDebuggingDataHandler
    implements DebuggingDataHandler {
        private NoOpDebuggingDataHandler() {
        }

        @Override
        public void columnTitles(List<String> columnTitles) {
        }
    }

    private class CustomHostnameVerifier
    implements HostnameVerifier {
        private String host;
        private DefaultHostnameVerifier defaultHostnameVerifier;

        public CustomHostnameVerifier(String host) {
            this.host = host;
            this.defaultHostnameVerifier = new DefaultHostnameVerifier();
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return this.defaultHostnameVerifier.verify(this.host, sslSession) | this.defaultHostnameVerifier.verify(this.host, sslSession);
        }
    }
}

