/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class SVPlanParser
extends BaseParser {
    private static final String PARAM_URLS = "urls";
    private static final String PARAM_ENCODING = "encoding";
    private static final String PARAM_CLASS_SEPARATOR = "classSeparator";
    private static final String PARAM_EXCLUDE_TEACHERS = "excludeTeachers";
    private static final String PARAM_REPEAT_CLASS = "repeatClass";
    private JSONObject data;

    public SVPlanParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        JSONArray urls = this.data.getJSONArray(PARAM_URLS);
        String encoding = this.data.optString(PARAM_ENCODING, null);
        ArrayList<Document> docs = new ArrayList<Document>();
        for (int i = 0; i < urls.length(); ++i) {
            String url;
            if (urls.get(i) instanceof JSONObject) {
                JSONObject obj = urls.getJSONObject(i);
                url = obj.getString("url");
                if (obj.has("postData")) {
                    JSONObject postParams = obj.getJSONObject("postData");
                    ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
                    for (String name : JSONObject.getNames((JSONObject)postParams)) {
                        String value = postParams.getString(name);
                        nvps.add((NameValuePair)new BasicNameValuePair(name, value));
                    }
                    docs.add(Jsoup.parse((String)this.httpPost(url, encoding, nvps).replace("&nbsp;", "")));
                    continue;
                }
                docs.add(Jsoup.parse((String)this.httpGet(url, encoding).replace("&nbsp;", "")));
                continue;
            }
            url = urls.getString(i);
            docs.add(Jsoup.parse((String)this.httpGet(url, encoding).replace("&nbsp;", "")));
        }
        SubstitutionSchedule v = this.parseSVPlanSchedule(docs);
        return v;
    }

    @NotNull
    SubstitutionSchedule parseSVPlanSchedule(List<Document> docs) throws IOException, JSONException {
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        for (Document doc : docs) {
            if (doc.select(".svp").size() > 0) {
                for (Element svp : doc.select(".svp")) {
                    this.parseSvPlanDay(v, svp, doc);
                }
                continue;
            }
            if (doc.select(".Trennlinie").size() > 0) {
                Element div = new Element(Tag.valueOf((String)"div"), "");
                for (Node node : doc.body().childNodesCopy()) {
                    if (node instanceof Element && ((Element)node).hasClass("Trennlinie") && div.select("table").size() > 0) {
                        this.parseSvPlanDay(v, div, doc);
                        div = new Element(Tag.valueOf((String)"div"), "");
                        continue;
                    }
                    div.appendChild(node);
                }
                this.parseSvPlanDay(v, div, doc);
                continue;
            }
            this.parseSvPlanDay(v, (Element)doc, doc);
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    private void parseSvPlanDay(SubstitutionSchedule v, Element svp, Document doc) throws IOException, JSONException {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        if (svp.select(".svp-plandatum-heute, .svp-plandatum-morgen, .Titel").size() > 0 || doc.title().startsWith("Vertretungsplan f\u00fcr ")) {
            this.setDate(svp, doc, day);
            if (svp.select(".svp-tabelle, table:has(.Klasse)").size() > 0) {
                Elements rows = svp.select(".svp-tabelle tr, table:has(.Klasse) tr");
                String lastLesson = "";
                String lastClass = "";
                for (Element row : rows) {
                    if (doc.select(".svp-header").size() > 0 && row.hasClass("svp-header") || row.select("th").size() > 0 || row.text().trim().equals("")) continue;
                    Substitution substitution = new Substitution();
                    for (Element column : row.select("td")) {
                        String type = column.className();
                        if (!this.hasData(column.text())) {
                            if ((type.startsWith("svp-stunde") || type.startsWith("Stunde")) && this.hasData(lastLesson)) {
                                substitution.setLesson(lastLesson);
                                continue;
                            }
                            if (!type.startsWith("svp-klasse") && !type.startsWith("Klasse") || !this.hasData(lastClass) || !this.data.optBoolean(PARAM_REPEAT_CLASS, true)) continue;
                            substitution.getClasses().addAll(this.getClasses(lastClass));
                            continue;
                        }
                        if (type.startsWith("svp-stunde") || type.startsWith("Stunde")) {
                            substitution.setLesson(column.text());
                            lastLesson = column.text();
                            continue;
                        }
                        if (type.startsWith("svp-klasse") || type.startsWith("Klasse")) {
                            substitution.getClasses().addAll(this.getClasses(column.text()));
                            lastClass = column.text();
                            continue;
                        }
                        if (type.startsWith("svp-esfehlt") || type.startsWith("Lehrer")) {
                            if (this.data.optBoolean(PARAM_EXCLUDE_TEACHERS)) continue;
                            substitution.setPreviousTeacher(column.text());
                            continue;
                        }
                        if (type.startsWith("svp-esvertritt") || type.startsWith("Vertretung")) {
                            if (this.data.optBoolean(PARAM_EXCLUDE_TEACHERS)) continue;
                            substitution.setTeacher(column.text().replaceAll(" \\+$", ""));
                            continue;
                        }
                        if (type.startsWith("svp-fach") || type.startsWith("Fach")) {
                            substitution.setSubject(column.text());
                            continue;
                        }
                        if (type.startsWith("svp-bemerkung") || type.startsWith("Anmerkung")) {
                            substitution.setDesc(column.text());
                            String recognizedType = SVPlanParser.recognizeType(column.text());
                            substitution.setType(recognizedType);
                            substitution.setColor(this.colorProvider.getColor(recognizedType));
                            continue;
                        }
                        if (!type.startsWith("svp-raum") && !type.startsWith("Raum")) continue;
                        substitution.setRoom(column.text());
                    }
                    if (substitution.getType() == null) {
                        substitution.setType("Vertretung");
                        substitution.setColor(this.colorProvider.getColor("Vertretung"));
                    }
                    day.addSubstitution(substitution);
                }
            }
            if (svp.select(".LehrerVerplant").size() > 0) {
                day.addMessage("<b>Verplante Lehrer:</b> " + svp.select(".LehrerVerplant").text());
            }
            if (svp.select(".Abwesenheiten").size() > 0) {
                day.addMessage("<b>Abwesenheiten:</b> " + svp.select(".Abwesenheiten").text());
            }
            if (svp.select("h2:contains(Mitteilungen)").size() > 0) {
                Element h2 = svp.select("h2:contains(Mitteilungen)").first();
                for (Element sibling = h2.nextElementSibling(); sibling != null && sibling.tagName().equals("p"); sibling = sibling.nextElementSibling()) {
                    for (String nachricht : TextNode.createFromEncoded((String)sibling.html(), null).getWholeText().split("<br />\\s*<br />")) {
                        if (!this.hasData(nachricht)) continue;
                        day.addMessage(nachricht);
                    }
                }
            } else if (svp.select(".Mitteilungen").size() > 0) {
                for (Element p : svp.select(".Mitteilungen")) {
                    for (String nachricht : TextNode.createFromEncoded((String)p.html(), null).getWholeText().split("<br />\\s*<br />")) {
                        if (!this.hasData(nachricht)) continue;
                        day.addMessage(nachricht);
                    }
                }
            }
        } else {
            throw new IOException("keine SVPlan-Tabelle gefunden");
        }
        v.addDay(day);
    }

    @NotNull
    List<String> getClasses(String text) throws JSONException {
        Pattern singlePattern = Pattern.compile("\\[(\\d+)\\]");
        Matcher singleMatcher = singlePattern.matcher(text);
        Pattern rangePattern = Pattern.compile("\\[(\\d+) ?- ?(\\d+)\\]");
        Matcher rangeMatcher = rangePattern.matcher(text);
        Pattern pattern2 = Pattern.compile("^(\\d+).*");
        if (rangeMatcher.matches()) {
            ArrayList<String> classes = new ArrayList<String>();
            int min = Integer.parseInt(rangeMatcher.group(1));
            int max = Integer.parseInt(rangeMatcher.group(2));
            for (String klasse : this.getAllClasses()) {
                int num;
                Matcher matcher2 = pattern2.matcher(klasse);
                if (!matcher2.matches() || min > (num = Integer.parseInt(matcher2.group(1))) || num > max) continue;
                classes.add(klasse);
            }
            return classes;
        }
        if (singleMatcher.matches()) {
            ArrayList<String> classes = new ArrayList<String>();
            int grade = Integer.parseInt(singleMatcher.group(1));
            for (String klasse : this.getAllClasses()) {
                Matcher matcher2 = pattern2.matcher(klasse);
                if (!matcher2.matches() || grade != Integer.parseInt(matcher2.group(1))) continue;
                classes.add(klasse);
            }
            return classes;
        }
        return Arrays.asList(text.split(this.data.optString(PARAM_CLASS_SEPARATOR, ", ")));
    }

    private void setDate(Element svp, Document doc, SubstitutionScheduleDay day) {
        String date = "Unbekanntes Datum";
        if (svp.select(".svp-plandatum-heute, .svp-plandatum-morgen, .Titel").size() > 0) {
            date = svp.select(".svp-plandatum-heute, .svp-plandatum-morgen, .Titel").text().replaceAll("Vertretungsplan (f\u00fcr )?", "").trim();
        } else if (doc.title().startsWith("Vertretungsplan f\u00fcr ")) {
            date = doc.title().substring("Vertretungsplan f\u00fcr ".length());
        }
        date = date.replaceAll("\\s+", " ");
        day.setDateString(date);
        day.setDate(ParserUtils.parseDate(date));
        if (svp.select(".svp-uploaddatum, .Stand").size() > 0) {
            String lastChange = svp.select(".svp-uploaddatum, .Stand").text().replace("Aktualisierung: ", "").replace("Stand: ", "");
            day.setLastChangeString(lastChange);
            day.setLastChange(ParserUtils.parseDateTime(lastChange));
        }
    }

    private void loadUrl(String url, String encoding, List<Document> docs) throws IOException, CredentialInvalidException {
    }

    @Override
    public List<String> getAllClasses() throws JSONException {
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }

    private boolean hasData(String text) {
        return !text.trim().equals("") && !text.trim().equals("---");
    }
}

