/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.ColorProvider;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import me.vertretungsplan.parser.UntisCommonParser;
import org.apache.http.client.HttpResponseException;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class UntisInfoParser
extends UntisCommonParser {
    public static final String PARAM_BASEURL = "baseurl";
    private static final String PARAM_ENCODING = "encoding";
    public static final String PARAM_CLASS_SELECT_REGEX = "classSelectRegex";
    public static final String PARAM_REMOVE_NON_MATCHING_CLASSES = "removeNonMatchingClasses";
    private static final String PARAM_SINGLE_CLASSES = "singleClasses";
    public static final String PARAM_W_AFTER_NUMBER = "wAfterNumber";
    private static final String PARAM_LETTER = "letter";
    private static final String PARAM_SCHEDULE_TYPE = "scheduleType";
    private static final String PARAM_SCHEDULE_BASEURL = "scheduleBaseurl";
    private String baseUrl;
    private JSONObject data;
    private String navbarDoc;

    public UntisInfoParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        try {
            this.data = scheduleData.getData();
            this.baseUrl = this.data.getString(PARAM_BASEURL);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private String getNavbarDoc() throws JSONException, IOException, CredentialInvalidException {
        if (this.navbarDoc == null) {
            String navbarUrl = this.baseUrl + "/frames/navbar.htm";
            this.navbarDoc = this.httpGet(navbarUrl, this.data.optString(PARAM_ENCODING, null));
        }
        return this.navbarDoc;
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        String lastChange;
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        Document navbarDoc = Jsoup.parse((String)this.getNavbarDoc().replace("&nbsp;", ""));
        Element select = navbarDoc.select("select[name=week]").first();
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        String info = navbarDoc.select(".description").text();
        try {
            lastChange = info.substring(info.indexOf("Stand:") + "Stand:".length()).trim();
        }
        catch (Exception e) {
            try {
                String infoHtml = this.httpGet(this.baseUrl + "/frames/title.htm", this.data.optString(PARAM_ENCODING, null));
                Document infoDoc = Jsoup.parse((String)infoHtml);
                String info2 = infoDoc.select(".description").text();
                lastChange = info2.substring(info2.indexOf("Stand:") + "Stand:".length()).trim();
            }
            catch (Exception e1) {
                lastChange = "";
            }
        }
        int successfulWeeks = 0;
        HttpResponseException lastException = null;
        for (Element option : select.children()) {
            String week = option.attr("value");
            String weekName = option.text();
            if (this.data.optBoolean(PARAM_SINGLE_CLASSES, this.data.optBoolean("single_classes", false)) || this.data.optString(PARAM_SCHEDULE_TYPE, "substitution").equals("timetable")) {
                int classNumber = 1;
                for (String klasse : this.getAllClasses()) {
                    String url = UntisInfoParser.getScheduleUrl(week, classNumber, this.data);
                    try {
                        this.parsePage(v, lastChange, klasse, url, weekName);
                    }
                    catch (HttpResponseException e) {
                        if (e.getStatusCode() == 500) {
                            ++classNumber;
                            continue;
                        }
                        throw e;
                    }
                    ++classNumber;
                }
                ++successfulWeeks;
                continue;
            }
            String url = UntisInfoParser.getScheduleUrl(week, 0, this.data);
            try {
                this.parsePage(v, lastChange, null, url, weekName);
                ++successfulWeeks;
            }
            catch (HttpResponseException e) {
                lastException = e;
            }
        }
        if (successfulWeeks == 0 && lastException != null) {
            throw lastException;
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        v.setWebsite(this.baseUrl + "/default.htm");
        return v;
    }

    @NotNull
    static String getScheduleUrl(String week, int number, JSONObject data) throws JSONException {
        String paddedNumber = String.format("%05d", number);
        String baseUrl = data.optString(PARAM_SCHEDULE_BASEURL, data.getString(PARAM_BASEURL) + "/");
        String letter = UntisInfoParser.getLetter(data);
        String url = data.optBoolean(PARAM_W_AFTER_NUMBER, data.optBoolean("w_after_number", false)) ? baseUrl + week + "/" + letter + "/" + letter + paddedNumber + ".htm" : baseUrl + letter + "/" + week + "/" + letter + paddedNumber + ".htm";
        return url;
    }

    private static String getLetter(JSONObject data) {
        String letter;
        switch (data.optString(PARAM_SCHEDULE_TYPE, "substitution")) {
            case "timetable": {
                letter = "c";
                break;
            }
            case "substitutionTeacher": {
                letter = "v";
                break;
            }
            default: {
                letter = "w";
            }
        }
        return data.optString(PARAM_LETTER, letter);
    }

    private void parsePage(SubstitutionSchedule v, String lastChange, String klasse, String url, String weekName) throws IOException, CredentialInvalidException, JSONException {
        Document doc = Jsoup.parse((String)this.httpGet(url, this.data.optString(PARAM_ENCODING, null)));
        switch (this.data.optString(PARAM_SCHEDULE_TYPE, "substitution")) {
            case "timetable": {
                this.parseTimetable(v, lastChange, doc, klasse, weekName);
                break;
            }
            default: {
                this.parseSubstitutionDays(v, lastChange, doc, klasse);
            }
        }
    }

    private void parseTimetable(SubstitutionSchedule v, String lastChange, Document doc, String klasse, String weekName) throws JSONException {
        v.setLastChange(ParserUtils.parseDateTime(lastChange));
        LocalDate weekStart = DateTimeFormat.forPattern((String)"d.M.yyyy").parseLocalDate(weekName);
        Element table = doc.select("table").first();
        ArrayList<SubstitutionScheduleDay> days = new ArrayList<SubstitutionScheduleDay>();
        for (int i = 0; i < table.select("tr").first().select("td:gt(0)").size(); ++i) {
            LocalDate date = weekStart.plusDays(i);
            SubstitutionScheduleDay day = null;
            for (SubstitutionScheduleDay d : v.getDays()) {
                if (!d.getDate().equals((Object)date)) continue;
                day = d;
                break;
            }
            if (day == null) {
                day = new SubstitutionScheduleDay();
                day.setDate(date);
                v.addDay(day);
            }
            days.add(day);
        }
        Elements rows = table.select("> tbody > tr:gt(0)");
        HashMap<Integer, String> lessons = new HashMap<Integer, String>();
        int i = 0;
        int lessonCounter = 1;
        while (i < rows.size()) {
            Element cell = ((Element)rows.get(i)).select("td").first();
            String lessonName = cell.text().trim();
            if (lessonName.length() > 3) {
                lessonName = String.valueOf(lessonCounter);
            }
            lessons.put(i, lessonName);
            i += this.getRowspan(cell);
            ++lessonCounter;
        }
        HashMap<Integer, Integer> columnsToSkip = new HashMap<Integer, Integer>();
        for (int j = 0; j < rows.size(); ++j) {
            columnsToSkip.put(j, 0);
        }
        for (int col = 1; col < days.size(); ++col) {
            Element cell;
            for (int row = 0; row < rows.size(); row += this.getRowspan(cell)) {
                cell = (Element)((Element)rows.get(row)).select("> td").get(col - (Integer)columnsToSkip.get(row));
                String lesson = this.getTimetableLesson(cell, row, lessons);
                ((SubstitutionScheduleDay)days.get(col - 1)).addAllSubstitutions(UntisInfoParser.parseTimetableCell(cell, lesson, klasse, this.data.getJSONArray("cellFormat"), this.colorProvider));
                for (int skippedRow = row + 1; skippedRow < row + this.getRowspan(cell); ++skippedRow) {
                    columnsToSkip.put(skippedRow, (Integer)columnsToSkip.get(skippedRow) + 1);
                }
            }
        }
    }

    private int getRowspan(Element cell) {
        return cell.hasAttr("rowspan") ? Integer.valueOf(cell.attr("rowspan")) : 1;
    }

    private String getTimetableLesson(Element cell, int row, Map<Integer, String> lessons) {
        String minLesson;
        int rowspan = this.getRowspan(cell);
        String maxLesson = minLesson = lessons.get(row);
        for (int i = row + 1; i < row + rowspan; ++i) {
            if (!lessons.containsKey(i)) continue;
            maxLesson = lessons.get(i);
        }
        if (minLesson.equals(maxLesson)) {
            return minLesson;
        }
        return String.format("%s - %s", minLesson, maxLesson);
    }

    private static List<Substitution> parseTimetableCell(Element cell, String lesson, String klasse, JSONArray cellFormat, ColorProvider colorProvider) throws JSONException {
        ArrayList<Substitution> substitutions = new ArrayList<Substitution>();
        if (cell.text().trim().equals("")) {
            return substitutions;
        }
        Elements rows = cell.select("table").first().select("tr");
        int cols = ((Element)rows.get(0)).select("td").size();
        int courseCount = cols / cellFormat.getJSONArray(0).length();
        for (int course = 0; course < courseCount; ++course) {
            Substitution s = new Substitution();
            s.setLesson(lesson);
            HashSet<String> classes = new HashSet<String>();
            classes.add(klasse);
            s.setClasses(classes);
            boolean isChange = false;
            for (int row = 0; row < cellFormat.length() && row < rows.size(); ++row) {
                JSONArray rowData = cellFormat.getJSONArray(row);
                Element tr = (Element)rows.get(row);
                for (int col = 0; col < rowData.length(); ++col) {
                    if (rowData.getString(col) == null) continue;
                    String type = rowData.getString(col);
                    try {
                        Element td = (Element)tr.select("td").get(col + course * cellFormat.getJSONArray(0).length());
                        if (td.select("font[color=#FF0000]").size() > 0) {
                            isChange = true;
                        }
                        UntisInfoParser.parseTimetableCellContent(s, type, td);
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        if (course != 0) continue;
                        throw e;
                    }
                }
            }
            if (s.getSubject() == null && s.getTeacher() == null && s.getRoom() == null) {
                s.setType("Entfall");
            } else {
                s.setType("Vertretung");
            }
            s.setColor(colorProvider.getColor(s.getType()));
            if (!isChange) continue;
            substitutions.add(s);
        }
        return substitutions;
    }

    private static void parseTimetableCellContent(Substitution s, String type, Element td) {
        String value = td.text();
        if (value.startsWith("*")) {
            value = value.substring(1);
        }
        if (value.equals("---.") || value.equals("---")) {
            value = null;
        }
        boolean striked = td.select("strike").text().equals(td.text());
        switch (type) {
            case "subject": {
                if (striked) {
                    s.setPreviousSubject(value);
                    break;
                }
                s.setSubject(value);
                break;
            }
            case "teacher": {
                if (striked) {
                    s.setPreviousTeacher(value);
                    break;
                }
                s.setTeacher(value);
                break;
            }
            case "room": {
                if (striked) {
                    s.setPreviousRoom(value);
                    break;
                }
                s.setRoom(value);
            }
        }
    }

    private void parseSubstitutionDays(SubstitutionSchedule v, String lastChange, Document doc, String klasse) throws JSONException, CredentialInvalidException, IOException {
        Elements days = doc.select("#vertretung > p > b, #vertretung > b, p:has(a[href^=#]) > b");
        if (days.size() > 0) {
            for (Element dayElem : days) {
                SubstitutionScheduleDay day = new SubstitutionScheduleDay();
                day.setLastChangeString(lastChange);
                day.setLastChange(ParserUtils.parseDateTime(lastChange));
                String date = dayElem.text();
                day.setDateString(date);
                day.setDate(ParserUtils.parseDate(date));
                Element next = dayElem.parent().tagName().equals("p") ? dayElem.parent().nextElementSibling().nextElementSibling() : dayElem.parent().select("p").first().nextElementSibling();
                this.parseDay(day, next, v, klasse);
            }
        } else if (doc.select("tr:has(td[align=center]):gt(0)").size() > 0) {
            this.parseSubstitutionTable(v, null, doc);
            v.setLastChangeString(lastChange);
            v.setLastChange(ParserUtils.parseDateTime(lastChange));
        }
    }

    @Override
    public List<String> getAllClasses() throws JSONException, IOException, CredentialInvalidException {
        if (super.getAllClasses() != null) {
            return super.getAllClasses();
        }
        return UntisInfoParser.parseClasses(this.getNavbarDoc(), this.data);
    }

    @NotNull
    static List<String> parseClasses(String navbarDoc, JSONObject data) throws JSONException, IOException {
        Pattern pattern = Pattern.compile("var classes = (\\[[^\\]]*\\]);");
        Matcher matcher = pattern.matcher(navbarDoc);
        if (matcher.find()) {
            JSONArray classesJson = new JSONArray(matcher.group(1));
            ArrayList<String> classes = new ArrayList<String>();
            for (int i = 0; i < classesJson.length(); ++i) {
                String className = classesJson.getString(i);
                if (data.optString(PARAM_CLASS_SELECT_REGEX, null) != null) {
                    Pattern classNamePattern = Pattern.compile(data.getString(PARAM_CLASS_SELECT_REGEX));
                    Matcher classNameMatcher = classNamePattern.matcher(className);
                    if (classNameMatcher.find()) {
                        if (classNameMatcher.groupCount() > 0) {
                            StringBuilder builder = new StringBuilder();
                            for (int j = 1; j <= classNameMatcher.groupCount(); ++j) {
                                if (classNameMatcher.group(j) == null) continue;
                                builder.append(classNameMatcher.group(j));
                            }
                            className = builder.toString();
                        } else {
                            className = classNameMatcher.group();
                        }
                    } else if (data.optBoolean(PARAM_REMOVE_NON_MATCHING_CLASSES, false)) continue;
                }
                classes.add(className);
            }
            return classes;
        }
        throw new IOException();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

