/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.util.HashMap;
import java.util.Iterator;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ColorProvider {
    private static final HashMap<String, String> colorNames = new HashMap();
    private static final String[] RED_VALUES = new String[]{"Entfall", "EVA", "Entf.", "Entf", "F\u00e4llt aus!", "F\u00e4llt aus", "entf\u00e4llt", "Freistunde", "Klasse frei", "Selbstlernen", "HA", "selb.Arb.", "Aufgaben", "selbst.", "Frei", "Ausfall", "Stillarbeit", "Absenz", "-> Entfall", "Freisetzung"};
    private static final String[] BLUE_VALUES = new String[]{"Vertretung", "Sondereins.", "Statt-Vertretung", "Betreuung", "V", "VTR", "Vertr."};
    private static final String[] YELLOW_VALUES = new String[]{"Tausch", "Verlegung", "Zusammenlegung", "Unterricht ge\u00e4ndert", "Unterrichtstausch", "ge\u00e4ndert", "statt", "Stundentausch"};
    private static final String[] GREEN_VALUES = new String[]{"Raum", "KLA", "Raum-Vtr.", "Raumtausch", "Raumverlegung", "Raum\u00e4nderung", "R. \u00c4nd.", "Raum beachten", "Raum-Vertr."};
    private static final String[] BROWN_VALUES = new String[]{"Veranst.", "Veranstaltung", "Frei/Veranstaltung", "Hochschultag"};
    private static final String[] ORANGE_VALUES = new String[]{"Klausur"};
    private static final String[] GRAY_VALUES = new String[]{"Pausenaufsicht"};
    private static final HashMap<String, String> defaultColorMap = new HashMap();
    private HashMap<String, String> colorMap = new HashMap();

    public ColorProvider(SubstitutionScheduleData data) {
        try {
            if (data.getData().has("colors")) {
                JSONObject colors = data.getData().getJSONObject("colors");
                Iterator keys = colors.keys();
                while (keys.hasNext()) {
                    String color = (String)keys.next();
                    JSONArray values = colors.getJSONArray(color);
                    if (colorNames.containsKey(color)) {
                        color = colorNames.get(color);
                    }
                    for (int i = 0; i < values.length(); ++i) {
                        this.colorMap.put(values.getString(i).toLowerCase(), color);
                    }
                }
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String getColor(String type) {
        if (type == null) {
            return null;
        }
        if (this.colorMap.containsKey(type.toLowerCase())) {
            return this.colorMap.get(type.toLowerCase());
        }
        if (defaultColorMap.containsKey(type.toLowerCase())) {
            return defaultColorMap.get(type.toLowerCase());
        }
        return colorNames.get("purple");
    }

    static {
        colorNames.put("red", "#F44336");
        colorNames.put("blue", "#2196F3");
        colorNames.put("yellow", "#FFA000");
        colorNames.put("green", "#4CAF50");
        colorNames.put("brown", "#795548");
        colorNames.put("orange", "#FF9800");
        colorNames.put("gray", "#9E9E9E");
        colorNames.put("purple", "#9C27B0");
        colorNames.put("pink", "#E91E63");
        colorNames.put("deep_purple", "#673AB7");
        colorNames.put("indigo", "#3F51B5");
        colorNames.put("light_blue", "#03A9F4");
        colorNames.put("cyan", "#00BCD4");
        colorNames.put("teal", "#009688");
        colorNames.put("light_green", "#8BC34A");
        colorNames.put("lime", "#CDDC39");
        colorNames.put("amber", "#FFC107");
        colorNames.put("deep_orange", "#FF5722");
        colorNames.put("blue_gray", "#607D8B");
        colorNames.put("black", "#000000");
        colorNames.put("white", "#FFFFFF");
        for (String string : RED_VALUES) {
            defaultColorMap.put(string.toLowerCase(), colorNames.get("red"));
        }
        for (String string : BLUE_VALUES) {
            defaultColorMap.put(string.toLowerCase(), colorNames.get("blue"));
        }
        for (String string : YELLOW_VALUES) {
            defaultColorMap.put(string.toLowerCase(), colorNames.get("yellow"));
        }
        for (String string : GREEN_VALUES) {
            defaultColorMap.put(string.toLowerCase(), colorNames.get("green"));
        }
        for (String string : BROWN_VALUES) {
            defaultColorMap.put(string.toLowerCase(), colorNames.get("brown"));
        }
        for (String string : ORANGE_VALUES) {
            defaultColorMap.put(string.toLowerCase(), colorNames.get("orange"));
        }
        for (String string : GRAY_VALUES) {
            defaultColorMap.put(string.toLowerCase(), colorNames.get("gray"));
        }
    }
}

