/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.objects;

import com.paour.comparator.NaturalOrderComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class SubstitutionScheduleDay
implements Cloneable {
    private LocalDate date;
    private String dateString;
    private LocalDateTime lastChange;
    private String lastChangeString;
    private Set<Substitution> substitutions = new HashSet<Substitution>();
    private List<String> messages = new ArrayList<String>();

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public String getDateString() {
        if (this.date != null) {
            return SubstitutionSchedule.DAY_DATE_FORMAT.print((ReadablePartial)this.date);
        }
        if (this.dateString != null) {
            return this.dateString;
        }
        return null;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    @Nullable
    public LocalDateTime getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(LocalDateTime lastChange) {
        this.lastChange = lastChange;
    }

    @Nullable
    public String getLastChangeString() {
        if (this.lastChange != null) {
            return SubstitutionSchedule.LAST_CHANGE_DATE_FORMAT.print((ReadablePartial)this.lastChange);
        }
        if (this.lastChangeString != null) {
            return this.lastChangeString;
        }
        return null;
    }

    public void setLastChangeString(String lastChangeString) {
        this.lastChangeString = lastChangeString;
    }

    public Set<Substitution> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(Set<Substitution> substitutions) {
        this.substitutions = substitutions;
    }

    public Set<Substitution> getSubstitutionsByClass(String theClass) {
        return SubstitutionSchedule.filterByClass(theClass, this.substitutions);
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public void addSubstitution(Substitution substitution) {
        for (Substitution s : this.getSubstitutions()) {
            if (s.equalsExcludingClasses(substitution)) {
                s.getClasses().addAll(substitution.getClasses());
                return;
            }
            if (s.equalsExcludingTeachers(substitution)) {
                s.getTeachers().addAll(substitution.getTeachers());
                return;
            }
            if (!s.equalsExcludingPreviousTeachers(substitution)) continue;
            s.getPreviousTeachers().addAll(substitution.getPreviousTeachers());
            return;
        }
        this.getSubstitutions().add(substitution);
    }

    public void addAllSubstitutions(Substitution ... substitutions) {
        for (Substitution s : substitutions) {
            this.addSubstitution(s);
        }
    }

    public void addAllSubstitutions(Collection<? extends Substitution> substitutions) {
        for (Substitution substitution : substitutions) {
            this.addSubstitution(substitution);
        }
    }

    public void merge(SubstitutionScheduleDay day) {
        if (day.getDate() != null && !day.getDate().equals((Object)this.getDate()) || day.getDateString() != null && !day.getDateString().equals(this.getDateString())) {
            throw new IllegalArgumentException("Cannot merge days with different dates");
        }
        this.addAllSubstitutions(day.getSubstitutions());
        for (String message : day.getMessages()) {
            if (this.messages.contains(message)) continue;
            this.messages.add(message);
        }
        if (day.getLastChange() != null && this.getLastChange() != null && day.getLastChange().isAfter((ReadablePartial)this.getLastChange())) {
            this.setLastChange(day.getLastChange());
        }
    }

    public boolean equalsByDate(SubstitutionScheduleDay other) {
        if (this.getDate() != null) {
            return this.getDate().equals((Object)other.getDate());
        }
        if (this.getDateString() != null) {
            return this.getDateString().equals(other.getDateString());
        }
        return other.getDate() == null && other.getDateString() == null;
    }

    public Set<Substitution> getSubstitutionsByClassAndExcludedSubject(String theClass, Set<String> excludedSubjects) {
        return SubstitutionSchedule.filterBySubject(excludedSubjects, SubstitutionSchedule.filterByClass(theClass, this.substitutions));
    }

    public Set<Substitution> getSubstitutionsByTeacherAndExcludedSubject(String teacher, Set<String> excludedSubjects) {
        return SubstitutionSchedule.filterBySubject(excludedSubjects, SubstitutionSchedule.filterByTeacher(teacher, this.substitutions));
    }

    public SubstitutionScheduleDay clone() {
        try {
            return (SubstitutionScheduleDay)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString(SubstitutionSchedule.Type type) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDateString()).append("\n");
        builder.append("----------------------\n\n");
        builder.append("last change: ").append(this.getLastChangeString()).append("\n\n");
        ArrayList<Substitution> sortedSubstitutions = new ArrayList<Substitution>(this.substitutions);
        Collections.sort(sortedSubstitutions, new Comparator<Substitution>(){

            @Override
            public int compare(Substitution o1, Substitution o2) {
                return new NaturalOrderComparator().compare(o1.getLesson(), o2.getLesson());
            }
        });
        for (Substitution subst : sortedSubstitutions) {
            builder.append(subst.toString(type)).append("\n");
        }
        builder.append("\n");
        for (String message : this.messages) {
            builder.append(message).append("\n");
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(SubstitutionSchedule.Type.STUDENT);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubstitutionScheduleDay that = (SubstitutionScheduleDay)o;
        return new EqualsBuilder().append((Object)this.date, (Object)that.date).append((Object)this.dateString, (Object)that.dateString).append((Object)this.lastChange, (Object)that.lastChange).append((Object)this.lastChangeString, (Object)that.lastChangeString).append(this.substitutions, that.substitutions).append(this.messages, that.messages).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.date).append((Object)this.dateString).append((Object)this.lastChange).append((Object)this.lastChangeString).append(this.substitutions).append(this.messages).toHashCode();
    }
}

