/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import org.apache.commons.codec.binary.Base32;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebUntisParser
extends BaseParser {
    private static final String PARAM_HOST = "host";
    private static final String PARAM_SCHOOLNAME = "schoolname";
    public static final String PARAM_PROTOCOL = "protocol";
    private final JSONObject data;
    private String sessionId;
    private UserData userData;
    private static final String USERAGENT = "vertretungsplan.me";
    private String sharedSecret;
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");
    public static final DateTimeFormatter TIME_FORMAT = DateTimeFormat.forPattern((String)"HHmm");

    WebUntisParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        try {
            this.login();
            SubstitutionSchedule schedule = SubstitutionSchedule.fromData(this.scheduleData);
            schedule.setLastChange(this.getLastImport());
            TimeGrid timegrid = new TimeGrid(this.getTimeGrid());
            LocalDate today = LocalDate.now();
            int daysToAdd = this.getDaysToAdd();
            LocalDate endDate = today.plusDays(6 + daysToAdd);
            try {
                schedule = this.parseScheduleUsingSubstitutions(schedule, timegrid, today, endDate);
            }
            catch (UnauthorizedException e) {
                schedule = this.parseScheduleUsingTimetable(schedule, timegrid, today, endDate);
            }
            schedule.setClasses(this.toNamesList(this.getClasses()));
            String protocol = this.data.optString(PARAM_PROTOCOL, "https") + "://";
            schedule.setWebsite(protocol + this.data.getString(PARAM_HOST) + "/WebUntis");
            try {
                this.addMessagesOfDay(schedule);
            }
            catch (UnauthorizedException ignored) {
                // empty catch block
            }
            this.logout();
            return schedule;
        }
        catch (UnauthorizedException e) {
            throw new IOException(e);
        }
    }

    private void addMessagesOfDay(SubstitutionSchedule schedule) throws JSONException, CredentialInvalidException, IOException, UnauthorizedException {
        for (int i = 0; i < 7; ++i) {
            LocalDate date = LocalDate.now().plusDays(i);
            JSONArray messages = this.getMessagesOfDay(date).getJSONObject("messageOfDayCollection").getJSONArray("messages");
            if (messages.length() <= 0) continue;
            SubstitutionScheduleDay day = WebUntisParser.getDayForDate(schedule, date);
            for (int j = 0; j < messages.length(); ++j) {
                day.addMessage(messages.getJSONObject(j).getString("text"));
            }
        }
    }

    private int getDaysToAdd() throws JSONException, CredentialInvalidException, IOException {
        LocalDate today = LocalDate.now();
        int daysToAdd = 0;
        try {
            JSONArray holidays = this.getHolidays();
            for (int i = 0; i < holidays.length(); ++i) {
                LocalDate startDate = DATE_FORMAT.parseLocalDate(String.valueOf(holidays.getJSONObject(i).getInt("startDate")));
                LocalDate endDate = DATE_FORMAT.parseLocalDate(String.valueOf(holidays.getJSONObject(i).getInt("endDate")));
                if (startDate.isAfter((ReadablePartial)today.plusDays(6)) || endDate.isBefore((ReadablePartial)today)) continue;
                if (startDate.isBefore((ReadablePartial)today)) {
                    daysToAdd += Days.daysBetween((ReadablePartial)today, (ReadablePartial)endDate).getDays() + 1;
                    continue;
                }
                daysToAdd += Days.daysBetween((ReadablePartial)startDate, (ReadablePartial)endDate).getDays() + 2;
            }
        }
        catch (UnauthorizedException unauthorizedException) {
            // empty catch block
        }
        return daysToAdd;
    }

    private SubstitutionSchedule parseScheduleUsingTimetable(SubstitutionSchedule schedule, TimeGrid timegrid, LocalDate startDate, LocalDate endDate) throws JSONException, UnauthorizedException, CredentialInvalidException, IOException {
        try {
            switch (this.scheduleData.getType()) {
                case TEACHER: {
                    if (this.userData.getPersonType() != 2) {
                        throw new CredentialInvalidException();
                    }
                    Map<Integer, String> teachers = this.idNameMap(this.getTeachers());
                    for (Map.Entry<Integer, String> entry : teachers.entrySet()) {
                        JSONArray json = this.getTimetable(startDate, endDate, new UserData(entry.getKey(), 2));
                        this.parseTimetable(json, schedule, timegrid);
                    }
                    break;
                }
                case STUDENT: {
                    Map<Integer, String> classes = this.idNameMap(this.getClasses());
                    for (Map.Entry<Integer, String> entry : classes.entrySet()) {
                        JSONArray json = this.getTimetable(startDate, endDate, new UserData(entry.getKey(), 1));
                        this.parseTimetable(json, schedule, timegrid);
                    }
                    break;
                }
            }
        }
        catch (UnauthorizedException e) {
            try {
                JSONArray json = this.getTimetable(startDate, endDate, this.userData);
                this.parseTimetable(json, schedule, timegrid);
            }
            catch (UnauthorizedException e1) {
                if (schedule.getType() != SubstitutionSchedule.Type.STUDENT || this.userData.klasseId == null) {
                    throw e1;
                }
                JSONArray json = this.getTimetable(startDate, endDate, new UserData(this.userData.klasseId, 1));
                this.parseTimetable(json, schedule, timegrid);
            }
        }
        return schedule;
    }

    private void parseTimetable(JSONArray json, SubstitutionSchedule schedule, TimeGrid timegrid) throws JSONException, CredentialInvalidException {
        for (int i = 0; i < json.length(); ++i) {
            JSONObject lesson = json.getJSONObject(i);
            if (!lesson.has("code") && !lesson.has("substText")) continue;
            Substitution subst = new Substitution();
            if (lesson.has("code")) {
                subst.setType(this.codeToType(lesson.getString("code")));
            } else {
                subst.setType("Vertretung");
            }
            subst.setColor(this.colorProvider.getColor(subst.getType()));
            this.parseClasses(lesson, subst);
            this.parseSubjects(lesson, subst);
            this.parseRooms(lesson, subst);
            this.parseTeachers(schedule, lesson, subst);
            if (lesson.has("lstext") && lesson.has("substText") && !lesson.getString("lstext").equals(lesson.getString("substText"))) {
                subst.setDesc(lesson.getString("lstext") + ", " + lesson.getString("substText"));
            } else if (lesson.has("lstext")) {
                subst.setDesc(lesson.getString("lstext"));
            } else if (lesson.has("substText")) {
                subst.setDesc(lesson.getString("substText"));
            }
            LocalDate date = DATE_FORMAT.parseLocalDate(String.valueOf(lesson.getInt("date")));
            LocalTime start = TIME_FORMAT.parseLocalTime(this.getParseableTime(lesson.getInt("startTime")));
            LocalTime end = TIME_FORMAT.parseLocalTime(this.getParseableTime(lesson.getInt("endTime")));
            TimeGrid.Day timegridDay = timegrid.getDay(date.getDayOfWeek());
            subst.setLesson(timegridDay != null ? timegridDay.getLesson(start, end) : "");
            SubstitutionScheduleDay day = WebUntisParser.getDayForDate(schedule, date);
            day.addSubstitution(subst);
        }
    }

    @NotNull
    private SubstitutionSchedule parseScheduleUsingSubstitutions(SubstitutionSchedule schedule, TimeGrid timegrid, LocalDate startDate, LocalDate endDate) throws CredentialInvalidException, IOException, JSONException, UnauthorizedException {
        JSONArray substitutions = this.getSubstitutions(startDate, endDate);
        HashMap days = new HashMap();
        for (int j = 0; j < substitutions.length(); ++j) {
            JSONObject substJson = substitutions.getJSONObject(j);
            Substitution substitution = new Substitution();
            if ("ex".equals(substJson.optString("lstype"))) {
                substitution.setType("Klausur");
            } else {
                substitution.setType(this.codeToType(substJson.getString("type")));
            }
            substitution.setColor(this.colorProvider.getColor(substitution.getType()));
            this.parseClasses(substJson, substitution);
            this.parseSubjects(substJson, substitution);
            this.parseRooms(substJson, substitution);
            this.parseTeachers(schedule, substJson, substitution);
            substitution.setDesc(substJson.optString("txt"));
            LocalDate date = DATE_FORMAT.parseLocalDate(String.valueOf(substJson.getInt("date")));
            LocalTime start = TIME_FORMAT.parseLocalTime(this.getParseableTime(substJson.getInt("startTime")));
            LocalTime end = TIME_FORMAT.parseLocalTime(this.getParseableTime(substJson.getInt("endTime")));
            TimeGrid.Day timegridDay = timegrid.getDay(date.getDayOfWeek());
            substitution.setLesson(timegridDay != null ? timegridDay.getLesson(start, end) : "");
            SubstitutionScheduleDay day = WebUntisParser.getDayForDate(schedule, date);
            day.addSubstitution(substitution);
        }
        return schedule;
    }

    private void parseTeachers(SubstitutionSchedule schedule, JSONObject substJson, Substitution substitution) throws JSONException, CredentialInvalidException {
        if (!substJson.has("te")) {
            return;
        }
        JSONArray teachersJson = substJson.getJSONArray("te");
        HashSet<String> teachers = new HashSet<String>();
        HashSet<String> previousTeachers = new HashSet<String>();
        for (int k = 0; k < teachersJson.length(); ++k) {
            JSONObject teacherJson = teachersJson.getJSONObject(k);
            if (schedule.getType().equals((Object)SubstitutionSchedule.Type.TEACHER) && !teacherJson.has("orgname") && !teacherJson.has("name")) {
                throw new CredentialInvalidException();
            }
            if (teacherJson.has("name")) {
                teachers.add(teacherJson.getString("name"));
            }
            if (!teacherJson.has("orgname")) continue;
            previousTeachers.add(teacherJson.getString("orgname"));
        }
        substitution.setTeachers(teachers);
        substitution.setPreviousTeachers(previousTeachers);
    }

    private void parseRooms(JSONObject substJson, Substitution substitution) throws JSONException {
        JSONArray roomsJson = substJson.getJSONArray("ro");
        StringBuilder room = null;
        StringBuilder previousRoom = null;
        for (int k = 0; k < roomsJson.length(); ++k) {
            JSONObject roomJson = roomsJson.getJSONObject(k);
            if (roomJson.has("name")) {
                if (room == null) {
                    room = new StringBuilder(roomJson.getString("name"));
                } else {
                    room.append(", ").append(roomJson.getString("name"));
                }
            }
            if (!roomJson.has("orgname")) continue;
            if (previousRoom == null) {
                previousRoom = new StringBuilder(roomJson.getString("orgname"));
                continue;
            }
            previousRoom.append(", ").append(roomJson.getString("orgname"));
        }
        substitution.setRoom(room != null ? room.toString() : null);
        substitution.setPreviousRoom(previousRoom != null ? previousRoom.toString() : null);
    }

    private void parseSubjects(JSONObject substJson, Substitution substitution) throws JSONException {
        JSONArray subjectsJson = substJson.getJSONArray("su");
        StringBuilder subject = null;
        for (int k = 0; k < subjectsJson.length(); ++k) {
            JSONObject subjectJson = subjectsJson.getJSONObject(k);
            if (!subjectJson.has("name")) continue;
            if (subject == null) {
                subject = new StringBuilder(subjectJson.getString("name"));
                continue;
            }
            subject.append(", ").append(subjectJson.getString("name"));
        }
        substitution.setSubject(subject != null ? subject.toString() : null);
    }

    private void parseClasses(JSONObject substJson, Substitution substitution) throws JSONException {
        HashSet<String> cls = new HashSet<String>();
        JSONArray classesJson = substJson.getJSONArray("kl");
        for (int k = 0; k < classesJson.length(); ++k) {
            cls.add(classesJson.getJSONObject(k).getString("name"));
        }
        substitution.setClasses(cls);
    }

    @NotNull
    private static SubstitutionScheduleDay getDayForDate(SubstitutionSchedule schedule, LocalDate date) {
        SubstitutionScheduleDay day = null;
        for (SubstitutionScheduleDay currentDay : schedule.getDays()) {
            if (!currentDay.getDate().equals((Object)date)) continue;
            day = currentDay;
            break;
        }
        if (day == null) {
            day = new SubstitutionScheduleDay();
            day.setDate(date);
            schedule.addDay(day);
        }
        return day;
    }

    @NotNull
    private Map<Integer, String> idNameMap(JSONArray subjects) throws JSONException {
        HashMap<Integer, String> subjectsMap = new HashMap<Integer, String>();
        for (int i = 0; i < subjects.length(); ++i) {
            JSONObject subject = subjects.getJSONObject(i);
            subjectsMap.put(subject.getInt("id"), subject.getString("name"));
        }
        return subjectsMap;
    }

    private String codeToType(String code) {
        switch (code) {
            case "cancel": {
                return "Entfall";
            }
            case "subst": 
            case "stxt": {
                return "Vertretung";
            }
            case "rmchg": {
                return "Raum\u00e4nderung";
            }
            case "add": {
                return "Sondereinsatz";
            }
            case "shift": {
                return "Verlegung";
            }
            case "free": {
                return "Freisetzung";
            }
            case "irregular": {
                return "Vertretung";
            }
            case "cancelled": {
                return "Entfall";
            }
        }
        System.err.println("unknown type: " + code);
        return code;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException, CredentialInvalidException {
        try {
            this.login();
            List<String> classes = this.toNamesList(this.getClasses());
            this.logout();
            return classes;
        }
        catch (UnauthorizedException e) {
            throw new CredentialInvalidException();
        }
    }

    @Override
    public List<String> getAllTeachers() throws IOException, JSONException, CredentialInvalidException {
        try {
            this.login();
            List<String> teachers = this.toNamesList(this.getTeachers());
            this.logout();
            return teachers;
        }
        catch (UnauthorizedException e) {
            throw new CredentialInvalidException();
        }
    }

    @NotNull
    private String getParseableTime(int value) {
        return String.format("%04d", value);
    }

    @Override
    public boolean isPersonal() {
        return true;
    }

    private JSONObject getMessagesOfDay(LocalDate date) throws JSONException, CredentialInvalidException, IOException, UnauthorizedException {
        this.loginInternal();
        JSONObject params = new JSONObject();
        params.put("date", (Object)date.toString());
        return (JSONObject)this.request("getMessagesOfDay", params, true);
    }

    private JSONArray getSubstitutions(LocalDate start, LocalDate end) throws CredentialInvalidException, IOException, JSONException, UnauthorizedException {
        JSONObject params = new JSONObject();
        params.put("startDate", (Object)DATE_FORMAT.print((ReadablePartial)start));
        params.put("endDate", (Object)DATE_FORMAT.print((ReadablePartial)end));
        params.put("departmentId", 0);
        return (JSONArray)this.request("getSubstitutions", params);
    }

    private JSONArray getTimetable(LocalDate start, LocalDate end, UserData userData) throws CredentialInvalidException, IOException, JSONException, UnauthorizedException {
        JSONObject params = new JSONObject();
        JSONObject options = new JSONObject();
        options.put("startDate", (Object)DATE_FORMAT.print((ReadablePartial)start));
        options.put("endDate", (Object)DATE_FORMAT.print((ReadablePartial)end));
        options.put("showBooking", true);
        options.put("showInfo", true);
        options.put("showSubstText", true);
        options.put("showLsText", true);
        options.put("showLsNumber", true);
        options.put("showStudentgroup", true);
        JSONArray fields = new JSONArray();
        fields.put((Object)"name");
        fields.put((Object)"longname");
        fields.put((Object)"id");
        options.put("klasseFields", (Object)fields);
        options.put("roomFields", (Object)fields);
        options.put("subjectFields", (Object)fields);
        options.put("teacherFields", (Object)fields);
        JSONObject element = new JSONObject();
        element.put("id", userData.getPersonId());
        element.put("type", userData.getPersonType());
        options.put("element", (Object)element);
        params.put("options", (Object)options);
        return (JSONArray)this.request("getTimetable", params);
    }

    private JSONArray getTimeGrid() throws JSONException, CredentialInvalidException, IOException, UnauthorizedException {
        return (JSONArray)this.request("getTimegridUnits");
    }

    private JSONArray getHolidays() throws JSONException, CredentialInvalidException, IOException, UnauthorizedException {
        return (JSONArray)this.request("getHolidays");
    }

    private LocalDateTime getLastImport() throws JSONException, CredentialInvalidException, IOException, UnauthorizedException {
        return new LocalDateTime(this.request("getLatestImportTime"));
    }

    private void login() throws JSONException, IOException, CredentialInvalidException, UnauthorizedException {
        if (this.sessionId != null && this.userData != null) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("user", (Object)((UserPasswordCredential)this.credential).getUsername());
        params.put("password", (Object)((UserPasswordCredential)this.credential).getPassword());
        params.put("client", (Object)USERAGENT);
        JSONObject response = (JSONObject)this.request("authenticate", params);
        if (!response.has("sessionId")) {
            throw new CredentialInvalidException();
        }
        this.sessionId = response.getString("sessionId");
        int klasseId = response.optInt("klasseId", -1);
        this.userData = new UserData(response.getInt("personId"), response.getInt("personType"), klasseId == -1 ? null : Integer.valueOf(klasseId));
    }

    private void loginInternal() throws JSONException, IOException, CredentialInvalidException, UnauthorizedException {
        if (this.sharedSecret != null) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("userName", (Object)((UserPasswordCredential)this.credential).getUsername());
        params.put("password", (Object)((UserPasswordCredential)this.credential).getPassword());
        params.put("client", (Object)USERAGENT);
        this.sharedSecret = (String)this.request("getAppSharedSecret", params, true);
    }

    private void logout() throws IOException, JSONException, CredentialInvalidException, UnauthorizedException {
        this.request("logout");
        this.sessionId = null;
        this.userData = null;
    }

    private JSONArray getClasses() throws IOException, JSONException, CredentialInvalidException, UnauthorizedException {
        return (JSONArray)this.request("getKlassen");
    }

    private JSONArray getTeachers() throws IOException, JSONException, CredentialInvalidException, UnauthorizedException {
        return (JSONArray)this.request("getTeachers");
    }

    @NotNull
    private List<String> toNamesList(JSONArray classesJson) throws JSONException {
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < classesJson.length(); ++i) {
            classes.add(classesJson.getJSONObject(i).getString("name"));
        }
        return classes;
    }

    private Object request(String method) throws IOException, JSONException, CredentialInvalidException, UnauthorizedException {
        return this.request(method, new JSONObject());
    }

    private Object request(String method, @NotNull JSONObject params) throws JSONException, IOException, CredentialInvalidException, UnauthorizedException {
        return this.request(method, params, false);
    }

    private Object request(String method, @NotNull JSONObject params, boolean internal) throws JSONException, IOException, CredentialInvalidException, UnauthorizedException {
        String host = this.data.getString(PARAM_HOST);
        String school = this.data.getString(PARAM_SCHOOLNAME);
        String protocol = this.data.optString(PARAM_PROTOCOL, "https") + "://";
        String url = protocol + host + "/WebUntis/jsonrpc" + (internal ? "_intern" : "") + ".do?school=" + URLEncoder.encode(school, "UTF-8");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", USERAGENT);
        if (internal && !method.equals("getAppSharedSecret")) {
            JSONObject auth = new JSONObject();
            long time = System.currentTimeMillis();
            auth.put("user", (Object)((UserPasswordCredential)this.credential).getUsername());
            try {
                auth.put("otp", this.authCodeInternal(time));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
            auth.put("clientTime", time);
            params.put("auth", (Object)auth);
        }
        JSONObject body = new JSONObject();
        body.put("id", (Object)ISODateTimeFormat.dateTime().print((ReadableInstant)DateTime.now()));
        body.put("method", (Object)method);
        if (internal) {
            JSONArray paramsArray = new JSONArray();
            paramsArray.put((Object)params);
            body.put("params", (Object)paramsArray);
        } else {
            body.put("params", (Object)params);
        }
        body.put("jsonrpc", (Object)"2.0");
        JSONObject response = new JSONObject(this.httpPost(url, "UTF-8", body.toString(), ContentType.APPLICATION_JSON, headers));
        if (!response.getString("id").equals(body.getString("id"))) {
            throw new IOException("wrong id returned by API");
        }
        if (!response.has("result")) {
            JSONObject error = response.getJSONObject("error");
            switch (error.getInt("code")) {
                case -32601: {
                    throw new IOException("Method not found");
                }
                case -8998: 
                case -8504: 
                case -8502: {
                    throw new CredentialInvalidException();
                }
                case -8520: {
                    throw new IOException("not logged in");
                }
                case -8509: {
                    throw new UnauthorizedException();
                }
            }
            throw new IOException(error.toString());
        }
        return response.get("result");
    }

    private int authCodeInternal(long time) throws NoSuchAlgorithmException, InvalidKeyException {
        long t = time / 30000L;
        byte[] key = new Base32().decode(this.sharedSecret.toUpperCase().getBytes());
        byte[] data = new byte[8];
        long value = t;
        int i = 8;
        while (true) {
            int i2 = i - 1;
            if (i <= 0) break;
            data[i2] = (byte)value;
            value >>>= 8;
            i = i2;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash = truncatedHash << 8 | (long)(hash[offset + i2] & 0xFF);
        }
        return (int)((truncatedHash & Integer.MAX_VALUE) % 1000000L);
    }

    private class UserData {
        public static final int TYPE_KLASSE = 1;
        public static final int TYPE_TEACHER = 2;
        public static final int TYPE_SUBJECT = 3;
        public static final int TYPE_ROOM = 4;
        public static final int TYPE_STUDENT = 5;
        private int personId;
        private int personType;
        private Integer klasseId;

        public UserData(int personId, int personType) {
            this.personId = personId;
            this.personType = personType;
            this.klasseId = null;
        }

        public UserData(int personId, int personType, int klasseId) {
            this.personId = personId;
            this.personType = personType;
            this.klasseId = klasseId;
        }

        public int getPersonId() {
            return this.personId;
        }

        public int getPersonType() {
            return this.personType;
        }

        public int getKlasseId() {
            return this.klasseId;
        }
    }

    private class UnauthorizedException
    extends Throwable {
        private UnauthorizedException() {
        }
    }

    private class TimeGrid {
        private final Map<Integer, Day> days = new HashMap<Integer, Day>();

        public TimeGrid(JSONArray timeGrid) throws JSONException {
            for (int i = 0; i < timeGrid.length(); ++i) {
                JSONObject day = timeGrid.getJSONObject(i);
                int weekday = day.getInt("day") - 1;
                if (weekday < 1) {
                    weekday += 7;
                }
                this.days.put(weekday, new Day(day));
            }
        }

        public Day getDay(int weekday) {
            return this.days.get(weekday);
        }

        private class Day {
            private final Map<LocalTime, String> startTimes = new HashMap<LocalTime, String>();
            private final Map<LocalTime, String> endTimes = new HashMap<LocalTime, String>();

            public Day(JSONObject day) throws JSONException {
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"HHmm");
                JSONArray units = day.getJSONArray("timeUnits");
                for (int i = 0; i < units.length(); ++i) {
                    JSONObject unit = units.getJSONObject(i);
                    String startTime = WebUntisParser.this.getParseableTime(unit.getInt("startTime"));
                    this.startTimes.put(fmt.parseLocalTime(startTime), unit.getString("name"));
                    String endTime = WebUntisParser.this.getParseableTime(unit.getInt("endTime"));
                    this.endTimes.put(fmt.parseLocalTime(endTime), unit.getString("name"));
                }
            }

            public String getLesson(LocalTime startTime, LocalTime endTime) {
                String startLesson = this.startTimes.get(startTime);
                String endLesson = this.endTimes.get(endTime);
                if (startLesson == null || endLesson == null) {
                    return "";
                }
                if (startLesson.equals(endLesson)) {
                    return String.valueOf(startLesson);
                }
                return startLesson + " - " + endLesson;
            }
        }
    }
}

