/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class IndiwareParser
extends BaseParser {
    private static final String PARAM_URLS = "urls";
    private static final String PARAM_ENCODING = "encoding";
    private static final String PARAM_EMBEDDED_CONTENT_SELECTOR = "embeddedContentSelector";
    protected JSONObject data;
    private static final int MAX_DAYS = 7;
    static final Pattern substitutionPattern = Pattern.compile("f\u00fcr ([^\\s]+) ((?:(?! ,).)+) ?,? ?(.*)");
    static final Pattern cancelPattern = Pattern.compile("([^\\s]+) (.+) f\u00e4llt (:?leider )?aus");
    static final Pattern delayPattern = Pattern.compile("([^\\s]+) (.+) (verlegt nach .*)");
    static final Pattern selfPattern = Pattern.compile("selbst\\. ?,? ?(.*)");
    static final Pattern coursePattern = Pattern.compile("(.*)/ (.*)");
    static final Pattern bracesPattern = Pattern.compile("^\\((.*)\\)$");

    public IndiwareParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        JSONArray urls = this.data.getJSONArray(PARAM_URLS);
        String encoding = this.data.optString(PARAM_ENCODING, null);
        ArrayList<String> docs = new ArrayList<String>();
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        int successfulSchedules = 0;
        IOException lastException = null;
        for (int i = 0; i < urls.length(); ++i) {
            if (urls.optJSONObject(i) != null) {
                try {
                    JSONObject obj = urls.getJSONObject(i);
                    String url = obj.getString("url");
                    if (!obj.has("postData")) continue;
                    JSONObject postParams = obj.getJSONObject("postData");
                    ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
                    for (String name : JSONObject.getNames((JSONObject)postParams)) {
                        String value = postParams.getString(name);
                        nvps.add((NameValuePair)new BasicNameValuePair(name, value));
                    }
                    docs.add(this.httpPost(url, encoding, nvps));
                    ++successfulSchedules;
                }
                catch (IOException e) {
                    lastException = e;
                }
                continue;
            }
            for (String url : ParserUtils.handleUrlWithDateFormat(urls.getString(i))) {
                try {
                    docs.add(this.httpGet(url, encoding));
                    ++successfulSchedules;
                }
                catch (IOException e) {
                    lastException = e;
                }
            }
        }
        if (successfulSchedules == 0 && lastException != null) {
            throw lastException;
        }
        for (String response : docs) {
            this.parseIndiwarePage(v, response);
        }
        v.setWebsite(urls.getString(0));
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    void parseIndiwarePage(SubstitutionSchedule v, String response) throws JSONException, IOException {
        Document doc;
        boolean html;
        if (response.contains("<html") || response.contains("<table")) {
            html = true;
            doc = Jsoup.parse((String)response);
        } else {
            html = false;
            doc = Jsoup.parse((String)response, (String)"", (Parser)Parser.xmlParser());
        }
        if (html && this.data.has(PARAM_EMBEDDED_CONTENT_SELECTOR)) {
            String selector = this.data.getString(PARAM_EMBEDDED_CONTENT_SELECTOR);
            Elements elems = doc.select(selector);
            if (elems.size() == 0) {
                throw new IOException("No elements found using " + selector);
            }
            for (Element elem : elems) {
                v.addDay(this.parseIndiwareDay(elem, true));
            }
        } else if (html && doc.select(".vpfuer").size() > 1) {
            String[] htmls = doc.html().split("<span class=\"vpfuer\">");
            for (int i = 1; i < htmls.length; ++i) {
                Document splitDoc = Jsoup.parse((String)htmls[i]);
                v.addDay(this.parseIndiwareDay((Element)splitDoc, true));
            }
        } else {
            v.addDay(this.parseIndiwareDay((Element)doc, html));
        }
    }

    SubstitutionScheduleDay parseIndiwareDay(Element doc, boolean html) {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        DataSource ds = html ? new HTMLDataSource(doc) : new XMLDataSource(doc);
        String date = ds.titel().text().replaceAll("\\(\\w-Woche\\)", "").trim();
        day.setDate(DateTimeFormat.forPattern((String)"EEEE, dd. MMMM yyyy").withLocale(Locale.GERMAN).parseLocalDate(date));
        String lastChange = ds.datum().text();
        day.setLastChange(DateTimeFormat.forPattern((String)"dd.MM.yyyy, HH:mm").withLocale(Locale.GERMAN).parseLocalDateTime(lastChange));
        if (ds.kopfinfos().size() > 0) {
            for (Element kopfinfo : ds.kopfinfos()) {
                String title = html ? kopfinfo.select("th").text() : IndiwareParser.kopfinfoTitle(kopfinfo.tagName()) + ":";
                StringBuilder message = new StringBuilder();
                if (title != null && !title.isEmpty()) {
                    message.append("<b>").append(title).append("</b>").append(" ");
                }
                message.append(html ? kopfinfo.select("td").text() : kopfinfo.text());
                day.addMessage(message.toString());
            }
        }
        if (ds.fuss() != null) {
            StringBuilder message = new StringBuilder();
            boolean first = true;
            for (Element fusszeile : ds.fusszeilen()) {
                if (first) {
                    first = false;
                } else {
                    message.append("\n");
                }
                message.append(fusszeile.text());
            }
            day.addMessage(message.toString());
        }
        ArrayList<String> columnTypes = null;
        if (html) {
            columnTypes = new ArrayList<String>();
            for (Element th : ((HTMLDataSource)ds).headers()) {
                columnTypes.add(th.className().replace("thplan", "").replace("thlplan", ""));
            }
        }
        for (Element aktion : ds.aktionen()) {
            Substitution substitution = new Substitution();
            String type = "Vertretung";
            String course = null;
            int i = 0;
            for (Element info : aktion.children()) {
                String columnType;
                String value = info.text().replace("\u00a0", "");
                if (value.equals("---")) {
                    ++i;
                    continue;
                }
                switch (columnType = html ? (String)columnTypes.get(i) : info.tagName()) {
                    case "klasse": {
                        HashSet<String> classes = new HashSet<String>();
                        for (String klasse : value.split(",")) {
                            Matcher courseMatcher = coursePattern.matcher(klasse);
                            if (courseMatcher.matches()) {
                                classes.add(courseMatcher.group(1));
                                course = courseMatcher.group(2);
                                continue;
                            }
                            classes.add(klasse);
                        }
                        substitution.setClasses(classes);
                        break;
                    }
                    case "stunde": {
                        substitution.setLesson(value);
                        break;
                    }
                    case "fach": {
                        String subject = this.subjectAndCourse(course, value);
                        if (columnTypes != null && columnTypes.contains("vfach")) {
                            substitution.setPreviousSubject(subject);
                            break;
                        }
                        substitution.setSubject(subject);
                        break;
                    }
                    case "vfach": {
                        substitution.setSubject(this.subjectAndCourse(course, value));
                    }
                    case "lehrer": {
                        Matcher bracesMatcher = bracesPattern.matcher(value);
                        if (bracesMatcher.matches()) {
                            value = bracesMatcher.group(1);
                        }
                        substitution.setTeacher(value);
                        break;
                    }
                    case "raum": {
                        if (columnTypes != null && columnTypes.contains("vraum")) {
                            substitution.setPreviousRoom(value);
                            break;
                        }
                        substitution.setRoom(value);
                        break;
                    }
                    case "vraum": {
                        substitution.setRoom(value);
                    }
                    case "info": {
                        Matcher substitutionMatcher = substitutionPattern.matcher(value);
                        Matcher cancelMatcher = cancelPattern.matcher(value);
                        Matcher delayMatcher = delayPattern.matcher(value);
                        Matcher selfMatcher = selfPattern.matcher(value);
                        if (substitutionMatcher.matches()) {
                            substitution.setPreviousSubject(substitutionMatcher.group(1));
                            substitution.setPreviousTeacher(substitutionMatcher.group(2));
                            if (substitutionMatcher.group(3).isEmpty()) break;
                            substitution.setDesc(substitutionMatcher.group(3));
                            break;
                        }
                        if (cancelMatcher.matches()) {
                            type = "Entfall";
                            substitution.setPreviousSubject(cancelMatcher.group(1));
                            substitution.setPreviousTeacher(cancelMatcher.group(2));
                            break;
                        }
                        if (delayMatcher.matches()) {
                            type = "Verlegung";
                            substitution.setPreviousSubject(delayMatcher.group(1));
                            substitution.setPreviousTeacher(delayMatcher.group(2));
                            substitution.setDesc(delayMatcher.group(3));
                            break;
                        }
                        if (selfMatcher.matches()) {
                            type = "selbst.";
                            if (selfMatcher.group(1).isEmpty()) break;
                            substitution.setDesc(selfMatcher.group(1));
                            break;
                        }
                        if (value.equals("f\u00e4llt aus") || value.equals("Klausur") || value.equals("Aufg.")) {
                            type = value;
                            break;
                        }
                        substitution.setDesc(value);
                    }
                }
                ++i;
            }
            substitution.setType(type);
            substitution.setColor(this.colorProvider.getColor(substitution.getType()));
            if (course != null && substitution.getSubject() == null) {
                substitution.setSubject(course);
            }
            day.addSubstitution(substitution);
        }
        return day;
    }

    @NotNull
    private String subjectAndCourse(String course, String subject) {
        StringBuilder subjectBuilder = new StringBuilder();
        subjectBuilder.append(subject);
        if (course != null) {
            subjectBuilder.append(" ").append(course);
        }
        return subjectBuilder.toString();
    }

    private static String kopfinfoTitle(String type) {
        switch (type) {
            case "abwesendl": {
                return "Abwesende Lehrer";
            }
            case "abwesendk": {
                return "Abwesende Klassen";
            }
            case "abwesendr": {
                return "Nicht verf\u00fcgbare R\u00e4ume";
            }
            case "aenderungl": {
                return "Lehrer mit \u00c4nderung";
            }
            case "aenderungk": {
                return "Klassen mit \u00c4nderung";
            }
        }
        return null;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() throws IOException, JSONException {
        return null;
    }

    private class HTMLDataSource
    implements DataSource {
        private Element doc;

        public HTMLDataSource(Element doc) {
            this.doc = doc;
        }

        @Override
        public Element titel() {
            return this.doc.select(".vpfuerdatum").first();
        }

        @Override
        public Element datum() {
            return this.doc.select(".vpdatum").first();
        }

        @Override
        public Elements kopfinfos() {
            return this.doc.select("table:has(th[class^=thkopf]) tr");
        }

        @Override
        public Element fuss() {
            return this.doc.select("table:not(:has(th[class^=thkopf])):not(:has(.tdaktionen)):not(span:contains(Aufsichten) + table)").first();
        }

        @Override
        public Elements fusszeilen() {
            return this.fuss().select("tr td");
        }

        @Override
        public Elements aktionen() {
            return this.doc.select("table:has(.tdaktionen) tr:gt(0)");
        }

        public Elements headers() {
            return this.doc.select("table:has(.tdaktionen) th");
        }
    }

    private class XMLDataSource
    implements DataSource {
        private Element vp;
        private Element kopf;

        public XMLDataSource(Element doc) {
            this.vp = doc.select("vp").first();
            this.kopf = this.vp.select("kopf").first();
        }

        @Override
        public Element titel() {
            return this.kopf.select("titel").first();
        }

        @Override
        public Element datum() {
            return this.kopf.select("datum").first();
        }

        @Override
        public Elements kopfinfos() {
            return this.kopf.select("kopfinfo > *");
        }

        @Override
        public Element fuss() {
            return this.vp.select("fuss").first();
        }

        @Override
        public Elements fusszeilen() {
            return this.fuss().select("fusszeile fussinfo");
        }

        @Override
        public Elements aktionen() {
            return this.vp.select("haupt > aktion");
        }
    }

    private static interface DataSource {
        public Element titel();

        public Element datum();

        public Elements kopfinfos();

        public Element fuss();

        public Elements fusszeilen();

        public Elements aktionen();
    }
}

