/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.credential.Credential;
import me.vertretungsplan.objects.credential.PasswordCredential;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.CookieProvider;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class LoginHandler {
    private static final String LOGIN_CONFIG = "login";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_PRE_URL = "preUrl";
    private static final String PARAM_URL = "url";
    private static final String PARAM_DATA = "data";
    private static final String PARAM_LOGIN = "login";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_CHECK_URL = "checkUrl";
    private static final String PARAM_CHECK_TEXT = "checkText";
    private SubstitutionScheduleData scheduleData;
    private Credential auth;
    private CookieProvider cookieProvider;

    LoginHandler(SubstitutionScheduleData scheduleData, Credential auth, @Nullable CookieProvider cookieProvider) {
        this.scheduleData = scheduleData;
        this.auth = auth;
        this.cookieProvider = cookieProvider;
    }

    void handleLogin(Executor executor, CookieStore cookieStore) throws JSONException, IOException, CredentialInvalidException {
        this.handleLogin(executor, cookieStore, false);
    }

    String handleLoginWithResponse(Executor executor, CookieStore cookieStore) throws JSONException, IOException, CredentialInvalidException {
        return this.handleLogin(executor, cookieStore, true);
    }

    private String handleLogin(Executor executor, CookieStore cookieStore, boolean needsResponse) throws JSONException, IOException, CredentialInvalidException {
        String type;
        String password;
        String login;
        if (this.auth == null) {
            return null;
        }
        if (!(this.auth instanceof UserPasswordCredential) && !(this.auth instanceof PasswordCredential)) {
            throw new IllegalArgumentException("Wrong authentication type");
        }
        if (this.auth instanceof UserPasswordCredential) {
            login = ((UserPasswordCredential)this.auth).getUsername();
            password = ((UserPasswordCredential)this.auth).getPassword();
        } else {
            login = null;
            password = ((PasswordCredential)this.auth).getPassword();
        }
        JSONObject data = this.scheduleData.getData();
        JSONObject loginConfig = data.getJSONObject("login");
        switch (type = loginConfig.optString(PARAM_TYPE, "post")) {
            case "post": {
                String response;
                List<Cookie> cookieList;
                List<Cookie> list = cookieList = this.cookieProvider != null ? this.cookieProvider.getCookies(this.auth) : null;
                if (cookieList != null && !needsResponse) {
                    for (Cookie cookie : cookieList) {
                        cookieStore.addCookie(cookie);
                    }
                    break;
                }
                executor.clearCookies();
                Document preDoc = null;
                if (loginConfig.has(PARAM_PRE_URL)) {
                    String preUrl = loginConfig.getString(PARAM_PRE_URL);
                    String preHtml = executor.execute(Request.Get((String)preUrl)).returnContent().asString();
                    preDoc = Jsoup.parse((String)preHtml);
                }
                String url = loginConfig.getString(PARAM_URL);
                JSONObject loginData = loginConfig.getJSONObject(PARAM_DATA);
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (String string : JSONObject.getNames((JSONObject)loginData)) {
                    String value = loginData.getString(string);
                    if (string.equals("_hiddeninputs")) {
                        for (Element hidden : preDoc.select(value + " input[type=hidden]")) {
                            nvps.add(new BasicNameValuePair(hidden.attr("name"), hidden.attr("value")));
                        }
                        continue;
                    }
                    if (value.equals("_login")) {
                        value = login;
                    } else if (value.equals("_password")) {
                        value = password;
                    } else if (value.equals("_password_md5")) {
                        value = DigestUtils.md5Hex((String)password);
                    }
                    nvps.add(new BasicNameValuePair(string, value));
                }
                Request request = Request.Post((String)url);
                if (loginConfig.optBoolean("form-data", false)) {
                    MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                    for (NameValuePair nameValuePair : nvps) {
                        builder.addTextBody(nameValuePair.getName(), nameValuePair.getValue());
                    }
                    request.body(builder.build());
                } else {
                    request.bodyForm(nvps, Charset.forName("UTF-8"));
                }
                String html = executor.execute(request).returnContent().asString();
                if (this.cookieProvider != null) {
                    this.cookieProvider.saveCookies(this.auth, cookieStore.getCookies());
                }
                String checkUrl = loginConfig.optString(PARAM_CHECK_URL, null);
                String string = loginConfig.optString(PARAM_CHECK_TEXT, null);
                if (checkUrl != null && string != null ? (response = executor.execute(Request.Get((String)checkUrl)).returnContent().asString()).contains(string) : string != null && html.contains(string)) {
                    throw new CredentialInvalidException();
                }
                return html;
            }
            case "basic": {
                String url;
                if (login == null) {
                    throw new IOException("wrong auth type");
                }
                executor.auth(login, password);
                if (!loginConfig.has(PARAM_URL) || executor.execute(Request.Get((String)(url = loginConfig.getString(PARAM_URL)))).returnResponse().getStatusLine().getStatusCode() == 200) break;
                throw new CredentialInvalidException();
            }
            case "ntlm": {
                String url;
                if (login == null) {
                    throw new IOException("wrong auth type");
                }
                executor.auth(login, password, null, null);
                if (!loginConfig.has(PARAM_URL) || executor.execute(Request.Get((String)(url = loginConfig.getString(PARAM_URL)))).returnResponse().getStatusLine().getStatusCode() == 200) break;
                throw new CredentialInvalidException();
            }
            case "fixed": {
                String loginFixed = loginConfig.optString("login", null);
                String passwordFixed = loginConfig.getString(PARAM_PASSWORD);
                if (Objects.equals(loginFixed, login) && Objects.equals(passwordFixed, password)) break;
                throw new CredentialInvalidException();
            }
        }
        return null;
    }
}

