/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.additionalinfo;

import java.io.IOException;
import me.vertretungsplan.additionalinfo.BaseAdditionalInfoParser;
import me.vertretungsplan.objects.AdditionalInfo;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public abstract class BaseRSSFeedParser
extends BaseAdditionalInfoParser {
    private static final int MAX_LENGTH = 100;
    private static final int MAX_ITEMS_COUNT = 5;

    protected abstract String getRSSUrl();

    protected String getTitle() {
        return "Neuigkeiten";
    }

    @Override
    public AdditionalInfo getAdditionalInfo() throws IOException {
        String xml = this.httpGet(this.getRSSUrl(), "UTF-8");
        return this.parse(xml);
    }

    @NotNull
    private AdditionalInfo parse(String xml) {
        AdditionalInfo info = new AdditionalInfo();
        info.setTitle(this.getTitle());
        Document doc = Jsoup.parse((String)xml, (String)"", (Parser)Parser.xmlParser());
        StringBuilder content = new StringBuilder();
        int count = 0;
        for (Element item : doc.select("item")) {
            if (count >= 5) break;
            if (count != 0) {
                content.append("<br><br>");
            }
            content.append("<b><a href=\"");
            content.append(item.select("link").text());
            content.append("\">");
            content.append(item.select("title").text());
            content.append("</a></b><br>");
            String text = Jsoup.parse((String)item.select("description").text()).text();
            String truncatedText = text.substring(0, Math.min(text.length(), 100));
            content.append(truncatedText);
            if (truncatedText.length() < text.length()) {
                content.append("\u2026");
            }
            ++count;
        }
        info.setText(content.toString());
        return info;
    }
}

