/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.additionalinfo;

import java.io.IOException;
import me.vertretungsplan.additionalinfo.WinterShParser;
import me.vertretungsplan.additionalinfo.amgrottweil.AmgRottweilIcalParser;
import me.vertretungsplan.additionalinfo.amgrottweil.AmgRottweilRSSParser;
import me.vertretungsplan.additionalinfo.amgrottweil.AmgRottweilStudentMessagesParser;
import me.vertretungsplan.additionalinfo.amgrottweil.AmgRottweilTeacherMessagesParser;
import me.vertretungsplan.additionalinfo.lsschleswig.LsSchleswigIcalParser;
import me.vertretungsplan.additionalinfo.lsschleswig.LsSchleswigRSSParser;
import me.vertretungsplan.objects.AdditionalInfo;
import org.apache.http.client.fluent.Request;

public abstract class BaseAdditionalInfoParser {
    protected BaseAdditionalInfoParser() {
    }

    public static BaseAdditionalInfoParser getInstance(String type) {
        BaseAdditionalInfoParser parser = null;
        switch (type) {
            case "winter-sh": {
                parser = new WinterShParser();
                break;
            }
            case "amgrottweil-rss": {
                parser = new AmgRottweilRSSParser();
                break;
            }
            case "amgrottweil-messages-student": {
                parser = new AmgRottweilStudentMessagesParser();
                break;
            }
            case "amgrottweil-messages-teacher": {
                parser = new AmgRottweilTeacherMessagesParser();
                break;
            }
            case "amgrottweil-ical": {
                parser = new AmgRottweilIcalParser();
                break;
            }
            case "lsschleswig-rss": {
                parser = new LsSchleswigRSSParser();
                break;
            }
            case "lsschleswig-ical": {
                parser = new LsSchleswigIcalParser();
            }
        }
        return parser;
    }

    public abstract AdditionalInfo getAdditionalInfo() throws IOException;

    protected String httpGet(String url, String encoding) throws IOException {
        return new String(Request.Get((String)url).execute().returnContent().asBytes(), encoding);
    }
}

