/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import org.apache.commons.codec.binary.Base32;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WebUntisParser
extends BaseParser {
    private static final String PARAM_HOST = "host";
    private static final String PARAM_SCHOOLNAME = "schoolname";
    public static final String PARAM_PROTOCOL = "protocol";
    private final JSONObject data;
    private String sessionId;
    private static final String USERAGENT = "vertretungsplan.me";
    private String sharedSecret;
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");

    WebUntisParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        this.login();
        SubstitutionSchedule schedule = SubstitutionSchedule.fromData(this.scheduleData);
        schedule.setLastChange(this.getLastImport());
        TimeGrid timegrid = new TimeGrid(this.getTimeGrid());
        JSONArray holidays = this.getHolidays();
        int daysToAdd = 0;
        LocalDate today = LocalDate.now();
        for (int i = 0; i < holidays.length(); ++i) {
            LocalDate startDate = DATE_FORMAT.parseLocalDate(String.valueOf(holidays.getJSONObject(i).getInt("startDate")));
            LocalDate endDate = DATE_FORMAT.parseLocalDate(String.valueOf(holidays.getJSONObject(i).getInt("endDate")));
            if (startDate.isAfter((ReadablePartial)today.plusDays(6)) || endDate.isBefore((ReadablePartial)today)) continue;
            if (startDate.isBefore((ReadablePartial)today)) {
                daysToAdd += Days.daysBetween((ReadablePartial)today, (ReadablePartial)endDate).getDays() + 1;
                continue;
            }
            daysToAdd += Days.daysBetween((ReadablePartial)startDate, (ReadablePartial)endDate).getDays() + 2;
        }
        JSONArray substitutions = this.getSubstitutions(today, today.plusDays(6 + daysToAdd));
        HashMap<LocalDate, SubstitutionScheduleDay> days = new HashMap<LocalDate, SubstitutionScheduleDay>();
        for (int j = 0; j < substitutions.length(); ++j) {
            JSONObject substJson = substitutions.getJSONObject(j);
            Substitution substitution = new Substitution();
            if ("ex".equals(substJson.optString("lstype"))) {
                substitution.setType("Klausur");
            } else {
                substitution.setType(this.codeToType(substJson.getString("type")));
            }
            substitution.setColor(this.colorProvider.getColor(substitution.getType()));
            HashSet<String> cls = new HashSet<String>();
            JSONArray classesJson = substJson.getJSONArray("kl");
            for (int k = 0; k < classesJson.length(); ++k) {
                cls.add(classesJson.getJSONObject(k).getString("name"));
            }
            substitution.setClasses(cls);
            JSONArray subjectsJson = substJson.getJSONArray("su");
            String subject = null;
            for (int k = 0; k < subjectsJson.length(); ++k) {
                JSONObject subjectJson = subjectsJson.getJSONObject(k);
                if (!subjectJson.has("name")) continue;
                subject = subject == null ? subjectJson.getString("name") : subject + ", " + subjectJson.getString("name");
            }
            substitution.setSubject(subject);
            JSONArray roomsJson = substJson.getJSONArray("ro");
            String room = null;
            String previousRoom = null;
            for (int k = 0; k < roomsJson.length(); ++k) {
                JSONObject roomJson = roomsJson.getJSONObject(k);
                if (roomJson.has("name")) {
                    room = room == null ? roomJson.getString("name") : room + ", " + roomJson.getString("name");
                }
                if (!roomJson.has("orgname")) continue;
                previousRoom = previousRoom == null ? roomJson.getString("orgname") : previousRoom + ", " + roomJson.getString("orgname");
            }
            substitution.setRoom(room);
            substitution.setPreviousRoom(previousRoom);
            JSONArray teachersJson = substJson.getJSONArray("te");
            HashSet<String> teachers = new HashSet<String>();
            HashSet<String> previousTeachers = new HashSet<String>();
            for (int k = 0; k < teachersJson.length(); ++k) {
                JSONObject teacherJson = teachersJson.getJSONObject(k);
                if (schedule.getType().equals((Object)SubstitutionSchedule.Type.TEACHER) && !teacherJson.has("orgname") && !teacherJson.has("name")) {
                    throw new CredentialInvalidException();
                }
                if (teacherJson.has("name")) {
                    teachers.add(teacherJson.getString("name"));
                }
                if (!teacherJson.has("orgname")) continue;
                previousTeachers.add(teacherJson.getString("orgname"));
            }
            substitution.setTeachers(teachers);
            substitution.setPreviousTeachers(previousTeachers);
            substitution.setDesc(substJson.optString("txt"));
            DateTimeFormatter timeFormat = DateTimeFormat.forPattern((String)"HHmm");
            LocalDate date = DATE_FORMAT.parseLocalDate(String.valueOf(substJson.getInt("date")));
            LocalTime start = timeFormat.parseLocalTime(this.getParseableTime(substJson.getInt("startTime")));
            LocalTime end = timeFormat.parseLocalTime(this.getParseableTime(substJson.getInt("endTime")));
            TimeGrid.Day timegridDay = timegrid.getDay(date.getDayOfWeek());
            substitution.setLesson(timegridDay != null ? timegridDay.getLesson(start, end) : "");
            SubstitutionScheduleDay day = WebUntisParser.getDayForDate(schedule, days, date);
            day.addSubstitution(substitution);
        }
        schedule.setClasses(this.toNamesList(this.getClasses()));
        String protocol = this.data.optString(PARAM_PROTOCOL, "https") + "://";
        schedule.setWebsite(protocol + this.data.getString(PARAM_HOST) + "/WebUntis");
        this.logout();
        for (int i = 0; i < 7; ++i) {
            LocalDate date = LocalDate.now().plusDays(i);
            JSONArray messages = this.getMessagesOfDay(date).getJSONObject("messageOfDayCollection").getJSONArray("messages");
            if (messages.length() <= 0) continue;
            SubstitutionScheduleDay day = WebUntisParser.getDayForDate(schedule, days, date);
            for (int j = 0; j < messages.length(); ++j) {
                day.addMessage(messages.getJSONObject(j).getString("text"));
            }
        }
        return schedule;
    }

    @NotNull
    private static SubstitutionScheduleDay getDayForDate(SubstitutionSchedule schedule, Map<LocalDate, SubstitutionScheduleDay> days, LocalDate date) {
        SubstitutionScheduleDay day = days.get(date);
        if (day == null) {
            day = new SubstitutionScheduleDay();
            day.setDate(date);
            schedule.addDay(day);
            days.put(date, day);
        }
        return day;
    }

    private JSONObject getMessagesOfDay(LocalDate date) throws JSONException, CredentialInvalidException, IOException {
        this.loginInternal();
        JSONObject params = new JSONObject();
        params.put("date", (Object)date.toString());
        return (JSONObject)this.request("getMessagesOfDay", params, true);
    }

    private JSONArray getSubstitutions(LocalDate start, LocalDate end) throws CredentialInvalidException, IOException, JSONException {
        JSONObject params = new JSONObject();
        params.put("startDate", (Object)DATE_FORMAT.print((ReadablePartial)start));
        params.put("endDate", (Object)DATE_FORMAT.print((ReadablePartial)end));
        params.put("departmentId", 0);
        return (JSONArray)this.request("getSubstitutions", params);
    }

    private JSONArray getTimeGrid() throws JSONException, CredentialInvalidException, IOException {
        return (JSONArray)this.request("getTimegridUnits");
    }

    private JSONArray getHolidays() throws JSONException, CredentialInvalidException, IOException {
        return (JSONArray)this.request("getHolidays");
    }

    private LocalDateTime getLastImport() throws JSONException, CredentialInvalidException, IOException {
        return new LocalDateTime(this.request("getLatestImportTime"));
    }

    @NotNull
    private Map<String, String> idNameMap(JSONArray subjects) throws JSONException {
        HashMap<String, String> subjectsMap = new HashMap<String, String>();
        for (int i = 0; i < subjects.length(); ++i) {
            JSONObject subject = subjects.getJSONObject(i);
            subjectsMap.put(subject.getString("id"), subject.getString("name"));
        }
        return subjectsMap;
    }

    private String codeToType(String code) {
        switch (code) {
            case "cancel": {
                return "Entfall";
            }
            case "subst": 
            case "stxt": {
                return "Vertretung";
            }
            case "rmchg": {
                return "Raum\u00e4nderung";
            }
            case "add": {
                return "Sondereinsatz";
            }
            case "shift": {
                return "Verlegung";
            }
            case "free": {
                return "Freisetzung";
            }
        }
        System.err.println("unknown type: " + code);
        return code;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException, CredentialInvalidException {
        this.login();
        List<String> classes = this.toNamesList(this.getClasses());
        this.logout();
        return classes;
    }

    @Override
    public List<String> getAllTeachers() throws IOException, JSONException, CredentialInvalidException {
        this.login();
        List<String> teachers = this.toNamesList(this.getTeachers());
        this.logout();
        return teachers;
    }

    private void login() throws JSONException, IOException, CredentialInvalidException {
        if (this.sessionId != null) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("user", (Object)((UserPasswordCredential)this.credential).getUsername());
        params.put("password", (Object)((UserPasswordCredential)this.credential).getPassword());
        params.put("client", (Object)USERAGENT);
        JSONObject response = (JSONObject)this.request("authenticate", params);
        if (!response.has("sessionId")) {
            throw new CredentialInvalidException();
        }
        this.sessionId = response.getString("sessionId");
    }

    private void logout() throws IOException, JSONException, CredentialInvalidException {
        this.request("logout");
        this.sessionId = null;
    }

    private JSONArray getClasses() throws IOException, JSONException, CredentialInvalidException {
        return (JSONArray)this.request("getKlassen");
    }

    private JSONArray getTeachers() throws IOException, JSONException, CredentialInvalidException {
        return (JSONArray)this.request("getTeachers");
    }

    @NotNull
    private List<String> toNamesList(JSONArray classesJson) throws JSONException {
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < classesJson.length(); ++i) {
            classes.add(classesJson.getJSONObject(i).getString("name"));
        }
        return classes;
    }

    private Object request(String method) throws IOException, JSONException, CredentialInvalidException {
        return this.request(method, new JSONObject());
    }

    private Object request(String method, @NotNull JSONObject params) throws JSONException, IOException, CredentialInvalidException {
        return this.request(method, params, false);
    }

    private Object request(String method, @NotNull JSONObject params, boolean internal) throws JSONException, IOException, CredentialInvalidException {
        String host = this.data.getString(PARAM_HOST);
        String school = this.data.getString(PARAM_SCHOOLNAME);
        String protocol = this.data.optString(PARAM_PROTOCOL, "https") + "://";
        String url = protocol + host + "/WebUntis/jsonrpc" + (internal ? "_intern" : "") + ".do?school=" + URLEncoder.encode(school, "UTF-8");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", USERAGENT);
        if (internal && !method.equals("getAppSharedSecret")) {
            JSONObject auth = new JSONObject();
            long time = System.currentTimeMillis();
            auth.put("user", (Object)((UserPasswordCredential)this.credential).getUsername());
            try {
                auth.put("otp", this.authCodeInternal(time));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
            auth.put("clientTime", time);
            params.put("auth", (Object)auth);
        }
        JSONObject body = new JSONObject();
        body.put("id", (Object)ISODateTimeFormat.dateTime().print((ReadableInstant)DateTime.now()));
        body.put("method", (Object)method);
        if (internal) {
            JSONArray paramsArray = new JSONArray();
            paramsArray.put((Object)params);
            body.put("params", (Object)paramsArray);
        } else {
            body.put("params", (Object)params);
        }
        body.put("jsonrpc", (Object)"2.0");
        JSONObject response = new JSONObject(this.httpPost(url, "UTF-8", body.toString(), ContentType.APPLICATION_JSON, headers));
        if (!response.getString("id").equals(body.getString("id"))) {
            throw new IOException("wrong id returned by API");
        }
        if (!response.has("result")) {
            JSONObject error = response.getJSONObject("error");
            switch (error.getInt("code")) {
                case -32601: {
                    throw new IOException("Method not found");
                }
                case -8998: 
                case -8504: 
                case -8502: {
                    throw new CredentialInvalidException();
                }
                case -8520: {
                    throw new IOException("not logged in");
                }
            }
            throw new IOException(error.toString());
        }
        return response.get("result");
    }

    @NotNull
    private String getParseableTime(int value) {
        return String.format("%04d", value);
    }

    private void loginInternal() throws JSONException, IOException, CredentialInvalidException {
        if (this.sharedSecret != null) {
            return;
        }
        JSONObject params = new JSONObject();
        params.put("userName", (Object)((UserPasswordCredential)this.credential).getUsername());
        params.put("password", (Object)((UserPasswordCredential)this.credential).getPassword());
        params.put("client", (Object)USERAGENT);
        this.sharedSecret = (String)this.request("getAppSharedSecret", params, true);
    }

    private int authCodeInternal(long time) throws NoSuchAlgorithmException, InvalidKeyException {
        long t = time / 30000L;
        byte[] key = new Base32().decode(this.sharedSecret.toUpperCase().getBytes());
        byte[] data = new byte[8];
        long value = t;
        int i = 8;
        while (true) {
            int i2 = i - 1;
            if (i <= 0) break;
            data[i2] = (byte)value;
            value >>>= 8;
            i = i2;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash = truncatedHash << 8 | (long)(hash[offset + i2] & 0xFF);
        }
        return (int)((truncatedHash & Integer.MAX_VALUE) % 1000000L);
    }

    private class TimeGrid {
        private final Map<Integer, Day> days = new HashMap<Integer, Day>();

        public TimeGrid(JSONArray timeGrid) throws JSONException {
            for (int i = 0; i < timeGrid.length(); ++i) {
                JSONObject day = timeGrid.getJSONObject(i);
                int weekday = day.getInt("day") - 1;
                if (weekday < 1) {
                    weekday += 7;
                }
                this.days.put(weekday, new Day(day));
            }
        }

        public Day getDay(int weekday) {
            return this.days.get(weekday);
        }

        private class Day {
            private final Map<LocalTime, String> startTimes = new HashMap<LocalTime, String>();
            private final Map<LocalTime, String> endTimes = new HashMap<LocalTime, String>();

            public Day(JSONObject day) throws JSONException {
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"HHmm");
                JSONArray units = day.getJSONArray("timeUnits");
                for (int i = 0; i < units.length(); ++i) {
                    JSONObject unit = units.getJSONObject(i);
                    String startTime = WebUntisParser.this.getParseableTime(unit.getInt("startTime"));
                    this.startTimes.put(fmt.parseLocalTime(startTime), unit.getString("name"));
                    String endTime = WebUntisParser.this.getParseableTime(unit.getInt("endTime"));
                    this.endTimes.put(fmt.parseLocalTime(endTime), unit.getString("name"));
                }
            }

            public String getLesson(LocalTime startTime, LocalTime endTime) {
                String startLesson = this.startTimes.get(startTime);
                String endLesson = this.endTimes.get(endTime);
                if (startLesson == null || endLesson == null) {
                    return "";
                }
                if (startLesson.equals(endLesson)) {
                    return String.valueOf(startLesson);
                }
                return startLesson + " - " + endLesson;
            }
        }
    }
}

