/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.objects.diff;

import java.util.Objects;
import java.util.Set;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.utils.SubstitutionTextUtils;

public class SubstitutionDiff {
    public static final int MAX_COMPLEXITY = 3;
    private Substitution oldSubstitution;
    private Substitution newSubstitution;

    public static SubstitutionDiff compare(Substitution oldSubstitution, Substitution newSubstitution) {
        SubstitutionDiff diff = new SubstitutionDiff();
        diff.oldSubstitution = oldSubstitution;
        diff.newSubstitution = newSubstitution;
        if (!oldSubstitution.getClasses().equals(newSubstitution.getClasses())) {
            throw new IllegalArgumentException("classes must be equal");
        }
        return diff;
    }

    public Substitution getOldSubstitution() {
        return this.oldSubstitution;
    }

    public void setOldSubstitution(Substitution oldSubstitution) {
        this.oldSubstitution = oldSubstitution;
    }

    public Substitution getNewSubstitution() {
        return this.newSubstitution;
    }

    public void setNewSubstitution(Substitution newSubstitution) {
        this.newSubstitution = newSubstitution;
    }

    public String getText() {
        return SubstitutionTextUtils.getText(this);
    }

    public void setText(String text) {
    }

    public int getComplexity() {
        int complexity = 0;
        if (!Objects.equals(this.oldSubstitution.getLesson(), this.newSubstitution.getLesson())) {
            ++complexity;
        }
        if (!Objects.equals(this.oldSubstitution.getType(), this.newSubstitution.getType())) {
            ++complexity;
        }
        if (!Objects.equals(this.oldSubstitution.getSubject(), this.newSubstitution.getSubject())) {
            ++complexity;
        }
        if (!Objects.equals(this.oldSubstitution.getPreviousSubject(), this.newSubstitution.getPreviousSubject())) {
            ++complexity;
        }
        if (!Objects.equals(this.oldSubstitution.getTeacher(), this.newSubstitution.getTeacher())) {
            ++complexity;
        }
        if (!Objects.equals(this.oldSubstitution.getPreviousTeacher(), this.newSubstitution.getPreviousTeacher())) {
            ++complexity;
        }
        if (!Objects.equals(this.oldSubstitution.getRoom(), this.newSubstitution.getRoom())) {
            ++complexity;
        }
        if (!Objects.equals(this.oldSubstitution.getPreviousRoom(), this.newSubstitution.getPreviousRoom())) {
            ++complexity;
        }
        if (!Objects.equals(this.oldSubstitution.getDesc(), this.newSubstitution.getDesc())) {
            ++complexity;
        }
        return complexity;
    }

    public Set<String> getClasses() {
        if (!this.oldSubstitution.getClasses().equals(this.newSubstitution.getClasses())) {
            throw new IllegalArgumentException("classes must be equal");
        }
        return this.oldSubstitution.getClasses();
    }
}

