/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.objects.diff;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.objects.diff.SubstitutionDiff;
import me.vertretungsplan.objects.diff.SubstitutionScheduleDiff;
import org.joda.time.LocalDate;

public class SubstitutionScheduleDayDiff
implements Cloneable {
    private LocalDate date;
    private String dateString;
    private Set<Substitution> newSubstitutions;
    private Set<SubstitutionDiff> editedSubstitutions;
    private Set<Substitution> removedSubstitutions;
    private List<String> newMessages;
    private List<String> removedMessages;

    public static SubstitutionScheduleDayDiff compare(SubstitutionScheduleDay a, SubstitutionScheduleDay b) {
        if (!a.equalsByDate(b)) {
            throw new IllegalArgumentException("Days must have the same date");
        }
        SubstitutionScheduleDayDiff diff = new SubstitutionScheduleDayDiff();
        diff.date = a.getDate();
        diff.dateString = a.getDateString();
        diff.newMessages = new ArrayList<String>();
        diff.removedMessages = new ArrayList<String>();
        diff.newSubstitutions = new HashSet<Substitution>();
        diff.editedSubstitutions = new HashSet<SubstitutionDiff>();
        diff.removedSubstitutions = new HashSet<Substitution>();
        for (String message : b.getMessages()) {
            if (a.getMessages().contains(message)) continue;
            diff.newMessages.add(message);
        }
        for (String message : a.getMessages()) {
            if (b.getMessages().contains(message)) continue;
            diff.removedMessages.add(message);
        }
        HashSet<Substitution> handledOldSubstitutions = new HashSet<Substitution>();
        for (Substitution newSubstitution : b.getSubstitutions()) {
            SubstitutionDiff substitutionDiff;
            if (a.getSubstitutions().contains(newSubstitution)) {
                handledOldSubstitutions.add(newSubstitution);
                continue;
            }
            Substitution oldSubstitution = SubstitutionScheduleDayDiff.findEqualSubtitutionExcludingClasses(newSubstitution, a.getSubstitutions(), handledOldSubstitutions);
            if (oldSubstitution != null) {
                HashSet<String> newClasses = new HashSet<String>();
                for (String currentClass : newSubstitution.getClasses()) {
                    if (oldSubstitution.getClasses().contains(currentClass)) continue;
                    newClasses.add(currentClass);
                }
                if (!newClasses.isEmpty()) {
                    diff.newSubstitutions.add(new Substitution(newSubstitution, newClasses));
                }
                HashSet<String> removedClasses = new HashSet<String>();
                for (String currentClass : oldSubstitution.getClasses()) {
                    if (newSubstitution.getClasses().contains(currentClass)) continue;
                    removedClasses.add(currentClass);
                }
                if (!removedClasses.isEmpty()) {
                    diff.removedSubstitutions.add(new Substitution(newSubstitution, removedClasses));
                }
                handledOldSubstitutions.add(oldSubstitution);
                continue;
            }
            oldSubstitution = SubstitutionScheduleDayDiff.findSimilarSubstitution(newSubstitution, a.getSubstitutions(), handledOldSubstitutions);
            if (oldSubstitution != null && (substitutionDiff = SubstitutionDiff.compare(oldSubstitution, newSubstitution)).getComplexity() <= 3) {
                diff.editedSubstitutions.add(substitutionDiff);
                handledOldSubstitutions.add(oldSubstitution);
                continue;
            }
            diff.newSubstitutions.add(newSubstitution);
        }
        for (Substitution oldSubstitution : a.getSubstitutions()) {
            if (handledOldSubstitutions.contains(oldSubstitution)) continue;
            diff.removedSubstitutions.add(oldSubstitution);
        }
        return diff;
    }

    private static int calculateSimilarityScore(Substitution a, Substitution b) {
        int score = 0;
        if (Objects.equals(a.getLesson(), b.getLesson())) {
            ++score;
        }
        if (Objects.equals(a.getType(), b.getType())) {
            ++score;
        }
        if (Objects.equals(a.getSubject(), b.getSubject())) {
            ++score;
        }
        if (Objects.equals(a.getPreviousSubject(), b.getPreviousSubject())) {
            ++score;
        }
        if (Objects.equals(a.getTeachers(), b.getTeachers())) {
            ++score;
        }
        if (Objects.equals(a.getPreviousTeachers(), b.getPreviousTeachers())) {
            ++score;
        }
        if (Objects.equals(a.getRoom(), b.getRoom())) {
            ++score;
        }
        if (Objects.equals(a.getPreviousRoom(), b.getPreviousRoom())) {
            ++score;
        }
        if (Objects.equals(a.getDesc(), b.getDesc())) {
            ++score;
        }
        return score;
    }

    private static Substitution findSimilarSubstitution(Substitution subst, Set<Substitution> substs, Set<Substitution> handledSubsts) {
        int maxScore = 0;
        Substitution maxScoreSubstitution = null;
        for (Substitution currentSubst : substs) {
            int score;
            if (!currentSubst.getClasses().equals(subst.getClasses()) || handledSubsts.contains(currentSubst) || (score = SubstitutionScheduleDayDiff.calculateSimilarityScore(currentSubst, subst)) <= maxScore) continue;
            maxScore = score;
            maxScoreSubstitution = currentSubst;
        }
        if (maxScore > 0) {
            return maxScoreSubstitution;
        }
        return null;
    }

    private static Substitution findEqualSubtitutionExcludingClasses(Substitution subst, Set<Substitution> substs, Set<Substitution> handledSubsts) {
        for (Substitution currentSubst : substs) {
            if (!currentSubst.equalsExcludingClasses(subst) || handledSubsts.contains(currentSubst)) continue;
            return currentSubst;
        }
        return null;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public Set<Substitution> getNewSubstitutions() {
        return this.newSubstitutions;
    }

    public void setNewSubstitutions(Set<Substitution> newSubstitutions) {
        this.newSubstitutions = newSubstitutions;
    }

    public Set<SubstitutionDiff> getEditedSubstitutions() {
        return this.editedSubstitutions;
    }

    public void setEditedSubstitutions(Set<SubstitutionDiff> editedSubstitutions) {
        this.editedSubstitutions = editedSubstitutions;
    }

    public Set<Substitution> getRemovedSubstitutions() {
        return this.removedSubstitutions;
    }

    public void setRemovedSubstitutions(Set<Substitution> removedSubstitutions) {
        this.removedSubstitutions = removedSubstitutions;
    }

    public List<String> getNewMessages() {
        return this.newMessages;
    }

    public void setNewMessages(List<String> newMessages) {
        this.newMessages = newMessages;
    }

    public List<String> getRemovedMessages() {
        return this.removedMessages;
    }

    public void setRemovedMessages(List<String> removedMessages) {
        this.removedMessages = removedMessages;
    }

    public boolean isNotEmpty() {
        return !this.newMessages.isEmpty() || !this.removedMessages.isEmpty() || !this.newSubstitutions.isEmpty() || !this.removedSubstitutions.isEmpty() || !this.editedSubstitutions.isEmpty();
    }

    public Set<Substitution> getNewSubstitutionsByClassAndExcludedSubject(String theClass, Set<String> excludedSubjects) {
        return SubstitutionSchedule.filterBySubject(excludedSubjects, SubstitutionSchedule.filterByClass(theClass, this.newSubstitutions));
    }

    public Set<Substitution> getRemovedSubstitutionsByClassAndExcludedSubject(String theClass, Set<String> excludedSubjects) {
        return SubstitutionSchedule.filterBySubject(excludedSubjects, SubstitutionSchedule.filterByClass(theClass, this.removedSubstitutions));
    }

    public Set<SubstitutionDiff> getEditedSubstitutionsByClassAndExcludedSubject(String theClass, Set<String> excludedSubjects) {
        return SubstitutionScheduleDiff.filterBySubject(excludedSubjects, SubstitutionScheduleDiff.filterByClass(theClass, this.editedSubstitutions));
    }

    public Set<Substitution> getNewSubstitutionsByTeacherAndExcludedSubject(String teacher, Set<String> excludedSubjects) {
        return SubstitutionSchedule.filterBySubject(excludedSubjects, SubstitutionSchedule.filterByTeacher(teacher, this.newSubstitutions));
    }

    public Set<Substitution> getRemovedSubstitutionsByTeacherAndExcludedSubject(String teacher, Set<String> excludedSubjects) {
        return SubstitutionSchedule.filterBySubject(excludedSubjects, SubstitutionSchedule.filterByTeacher(teacher, this.removedSubstitutions));
    }

    public Set<SubstitutionDiff> getEditedSubstitutionsByTeacherAndExcludedSubject(String teacher, Set<String> excludedSubjects) {
        return SubstitutionScheduleDiff.filterBySubject(excludedSubjects, SubstitutionScheduleDiff.filterByTeacher(teacher, this.editedSubstitutions));
    }

    public SubstitutionScheduleDayDiff clone() {
        try {
            return (SubstitutionScheduleDayDiff)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

