/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import com.mifmif.common.regex.Generex;
import com.paour.comparator.NaturalOrderComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class ParserUtils {
    private static List<DateTimeFormatter> dateTimeFormatters = new ArrayList<DateTimeFormatter>();
    private static List<DateTimeFormatter> dateFormatters = new ArrayList<DateTimeFormatter>();
    private static String[] dateFormats = new String[]{"dd.M.yyyy EEEE", "dd.M. EEEE", "d.M. EEEE", "EEEE, dd.M.yyyy", "EEEE, dd.M", "EEEE dd.M.yyyy", "EEEE dd.M", "EEEE', den 'dd.M.yyyy", "EEEE', den 'dd.M", "dd.M.yyyy", "dd.M.", "dd.MM.yyyy EEEE", "dd.MM EEEE", "EEEE, dd.MM.yyyy", "EEEE, dd.MM", "EEEE dd.MM.yyyy", "EEEE dd.MM", "EEEE', den 'dd.MM.yyyy", "EEEE', den 'dd.MM", "dd.MM.yyyy", "dd.MM.", "d.M.yyyy EEEE", "d.M. EEEE", "dd.MM. EEEE", "d.M. / EEEE", "dd.MM. / EEEE", "EEEE, d.M.yyyy", "EEEE, d.M", "EEEE d.M.yyyy", "EEEE d.M", "EEEE', den 'd.M.yyyy", "EEEE', den 'd.M", "d.M.yyyy", "d.M.", "EEEE, d. MMMM yyyy"};
    private static String[] separators = new String[]{" ", ", ", " 'um' "};
    private static String[] timeFormats = new String[]{"HH:mm", "HH:mm 'Uhr'", "(HH:mm 'Uhr')", "HH:mm:ss"};
    private static String[] dateTimeFormats = new String[dateFormats.length * timeFormats.length * separators.length];

    ParserUtils() {
    }

    static void init() {
        int i = 0;
        dateFormatters.clear();
        dateTimeFormatters.clear();
        for (String date : dateFormats) {
            dateFormatters.add(DateTimeFormat.forPattern((String)date).withLocale(Locale.GERMAN).withDefaultYear(DateTime.now().getYear()));
            for (String time : timeFormats) {
                for (String separator : separators) {
                    ParserUtils.dateTimeFormats[i] = date + separator + time;
                    dateTimeFormatters.add(DateTimeFormat.forPattern((String)dateTimeFormats[i]).withLocale(Locale.GERMAN).withDefaultYear(DateTime.now().getYear()));
                    ++i;
                }
            }
        }
    }

    private static void reinitIfNeeded() {
        if (dateFormatters.size() == 0 || dateFormatters.get(0).getDefaultYear() != DateTime.now().getYear()) {
            ParserUtils.init();
        }
    }

    static LocalDateTime parseDateTime(String string) {
        if (string == null) {
            return null;
        }
        ParserUtils.reinitIfNeeded();
        string = string.replace("Stand:", "").replace("Import:", "").trim();
        int i = 0;
        for (DateTimeFormatter f : dateTimeFormatters) {
            try {
                LocalDateTime dt = f.parseLocalDateTime(string);
                if (dateTimeFormats[i].contains("yyyy")) {
                    return dt;
                }
                Duration currentYearDifference = ParserUtils.abs(new Duration((ReadableInstant)DateTime.now(), (ReadableInstant)dt.toDateTime()));
                Duration lastYearDifference = ParserUtils.abs(new Duration((ReadableInstant)DateTime.now(), (ReadableInstant)dt.minusYears(1).toDateTime()));
                Duration nextYearDifference = ParserUtils.abs(new Duration((ReadableInstant)DateTime.now(), (ReadableInstant)dt.plusYears(1).toDateTime()));
                if (lastYearDifference.isShorterThan((ReadableDuration)currentYearDifference)) {
                    return DateTimeFormat.forPattern((String)dateTimeFormats[i]).withLocale(Locale.GERMAN).withDefaultYear(f.getDefaultYear() - 1).parseLocalDateTime(string);
                }
                if (nextYearDifference.isShorterThan((ReadableDuration)currentYearDifference)) {
                    return DateTimeFormat.forPattern((String)dateTimeFormats[i]).withLocale(Locale.GERMAN).withDefaultYear(f.getDefaultYear() + 1).parseLocalDateTime(string);
                }
                return dt;
            }
            catch (IllegalArgumentException e) {
                ++i;
            }
        }
        return null;
    }

    private static Duration abs(Duration duration) {
        Duration nothing = new Duration(0L);
        if (duration.isShorterThan((ReadableDuration)nothing)) {
            return duration.negated();
        }
        return duration;
    }

    static LocalDate parseDate(String string) {
        if (string == null) {
            return null;
        }
        ParserUtils.reinitIfNeeded();
        string = string.replace("Stand:", "").replace("Import:", "").replaceAll(", Woche [A-Z]", "").trim();
        int i = 0;
        for (DateTimeFormatter f : dateFormatters) {
            try {
                LocalDate d = f.parseLocalDate(string);
                if (dateFormats[i].contains("yyyy")) {
                    return d;
                }
                Duration currentYearDifference = ParserUtils.abs(new Duration((ReadableInstant)DateTime.now(), (ReadableInstant)d.toDateTimeAtCurrentTime()));
                Duration lastYearDifference = ParserUtils.abs(new Duration((ReadableInstant)DateTime.now(), (ReadableInstant)d.minusYears(1).toDateTimeAtCurrentTime()));
                Duration nextYearDifference = ParserUtils.abs(new Duration((ReadableInstant)DateTime.now(), (ReadableInstant)d.plusYears(1).toDateTimeAtCurrentTime()));
                if (lastYearDifference.isShorterThan((ReadableDuration)currentYearDifference)) {
                    return DateTimeFormat.forPattern((String)dateFormats[i]).withLocale(Locale.GERMAN).withDefaultYear(f.getDefaultYear() - 1).parseLocalDate(string);
                }
                if (nextYearDifference.isShorterThan((ReadableDuration)currentYearDifference)) {
                    return DateTimeFormat.forPattern((String)dateFormats[i]).withLocale(Locale.GERMAN).withDefaultYear(f.getDefaultYear() + 1).parseLocalDate(string);
                }
                return d;
            }
            catch (IllegalArgumentException e) {
                ++i;
            }
        }
        return null;
    }

    static List<String> handleUrlWithDateFormat(String url) {
        ArrayList<String> urls = new ArrayList<String>();
        Pattern dateFormatPattern = Pattern.compile("\\{date\\(([^)]+)\\)\\}");
        Matcher matcher = dateFormatPattern.matcher(url);
        if (matcher.find()) {
            String pattern = matcher.group(1);
            for (int j = 0; j < 7; ++j) {
                LocalDate date = LocalDate.now().plusDays(j);
                String dateStr = DateTimeFormat.forPattern((String)pattern).print((ReadablePartial)date);
                String urlWithDate = matcher.replaceFirst(dateStr);
                urls.add(urlWithDate);
            }
        } else {
            urls.add(url);
        }
        return urls;
    }

    static List<String> handleUrlsWithDateFormat(List<String> urls) {
        ArrayList<String> urlsWithDate = new ArrayList<String>();
        for (String url : urls) {
            urlsWithDate.addAll(ParserUtils.handleUrlWithDateFormat(url));
        }
        return urlsWithDate;
    }

    @Nullable
    static List<String> getClassesFromJson(JSONObject data) throws JSONException {
        if (data.has("classes")) {
            if (data.get("classes") instanceof JSONArray) {
                JSONArray classesJson = data.getJSONArray("classes");
                ArrayList<String> classes = new ArrayList<String>();
                for (int i = 0; i < classesJson.length(); ++i) {
                    classes.add(classesJson.getString(i));
                }
                return classes;
            }
            if (data.get("classes") instanceof String) {
                String regex = data.getString("classes");
                Generex generex = new Generex(regex);
                List classes = generex.getAllMatchedStrings();
                Collections.sort(classes, new NaturalOrderComparator());
                return classes;
            }
            return null;
        }
        return null;
    }
}

