/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.objects;

import java.util.HashSet;
import java.util.Set;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.utils.SubstitutionTextUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Substitution
implements Cloneable {
    private Set<String> classes;
    private String lesson;
    private String type;
    private String subject;
    private String previousSubject;
    private Set<String> teachers;
    private Set<String> previousTeachers;
    private String room;
    private String previousRoom;
    private String desc;
    private String color;
    private String substitutionFrom;
    private String teacherTo;

    public Substitution() {
        this.classes = new HashSet<String>();
        this.teachers = new HashSet<String>();
        this.previousTeachers = new HashSet<String>();
    }

    public Substitution(Substitution substitution, Set<String> classes) {
        this.classes = classes;
        this.lesson = substitution.lesson;
        this.type = substitution.type;
        this.subject = substitution.type;
        this.previousSubject = substitution.previousSubject;
        this.teachers = substitution.teachers;
        this.previousTeachers = substitution.previousTeachers;
        this.room = substitution.room;
        this.previousRoom = substitution.previousRoom;
        this.desc = substitution.desc;
        this.color = substitution.color;
        this.substitutionFrom = substitution.substitutionFrom;
        this.teacherTo = substitution.teacherTo;
    }

    public String getText() {
        return SubstitutionTextUtils.getText(this);
    }

    public String getTeacherText() {
        return SubstitutionTextUtils.getTeacherText(this);
    }

    public String getPreviousAndCurrentTeacherText() {
        return SubstitutionTextUtils.getTeachers(this);
    }

    public Set<String> getClasses() {
        return this.classes;
    }

    public void setClasses(Set<String> classes) {
        this.classes = classes;
    }

    public String getLesson() {
        return this.lesson;
    }

    public void setLesson(String lesson) {
        this.lesson = lesson;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPreviousSubject() {
        return this.previousSubject;
    }

    public void setPreviousSubject(String previousSubject) {
        this.previousSubject = previousSubject;
    }

    public String getTeacher() {
        return this.teachers.size() > 0 ? SubstitutionTextUtils.joinTeachers(this.teachers) : null;
    }

    public Set<String> getTeachers() {
        return this.teachers;
    }

    public void setTeacher(String teacher) {
        this.teachers.clear();
        if (teacher != null) {
            this.teachers.add(teacher);
        }
    }

    public void setTeachers(Set<String> teachers) {
        this.teachers = teachers;
    }

    public String getPreviousTeacher() {
        return this.previousTeachers.size() > 0 ? SubstitutionTextUtils.joinTeachers(this.previousTeachers) : null;
    }

    public Set<String> getPreviousTeachers() {
        return this.previousTeachers;
    }

    public void setPreviousTeacher(String previousTeacher) {
        this.previousTeachers.clear();
        if (previousTeacher != null) {
            this.previousTeachers.add(previousTeacher);
        }
    }

    public void setPreviousTeachers(Set<String> previousTeachers) {
        this.previousTeachers = previousTeachers;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getPreviousRoom() {
        return this.previousRoom;
    }

    public void setPreviousRoom(String previousRoom) {
        this.previousRoom = previousRoom;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getSubstitutionFrom() {
        return this.substitutionFrom;
    }

    public void setSubstitutionFrom(String substitutionFrom) {
        this.substitutionFrom = substitutionFrom;
    }

    public String getTeacherTo() {
        return this.teacherTo;
    }

    public void setTeacherTo(String teacherTo) {
        this.teacherTo = teacherTo;
    }

    public boolean equalsExcludingClasses(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Substitution that = (Substitution)o;
        return new EqualsBuilder().append((Object)this.lesson, (Object)that.lesson).append((Object)this.type, (Object)that.type).append((Object)this.subject, (Object)that.subject).append((Object)this.previousSubject, (Object)that.previousSubject).append(this.teachers, that.teachers).append(this.previousTeachers, that.previousTeachers).append((Object)this.room, (Object)that.room).append((Object)this.previousRoom, (Object)that.previousRoom).append((Object)this.desc, (Object)that.desc).append((Object)this.color, (Object)that.color).append((Object)this.substitutionFrom, (Object)that.substitutionFrom).append((Object)this.teacherTo, (Object)that.teacherTo).isEquals();
    }

    public boolean equalsExcludingTeachers(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Substitution that = (Substitution)o;
        return new EqualsBuilder().append((Object)this.lesson, (Object)that.lesson).append((Object)this.type, (Object)that.type).append((Object)this.subject, (Object)that.subject).append((Object)this.previousSubject, (Object)that.previousSubject).append(this.classes, that.classes).append(this.previousTeachers, that.previousTeachers).append((Object)this.room, (Object)that.room).append((Object)this.previousRoom, (Object)that.previousRoom).append((Object)this.desc, (Object)that.desc).append((Object)this.color, (Object)that.color).append((Object)this.substitutionFrom, (Object)that.substitutionFrom).append((Object)this.teacherTo, (Object)that.teacherTo).isEquals();
    }

    public boolean equalsExcludingPreviousTeachers(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Substitution that = (Substitution)o;
        return new EqualsBuilder().append((Object)this.lesson, (Object)that.lesson).append((Object)this.type, (Object)that.type).append((Object)this.subject, (Object)that.subject).append((Object)this.previousSubject, (Object)that.previousSubject).append(this.teachers, that.teachers).append(this.classes, that.classes).append((Object)this.room, (Object)that.room).append((Object)this.previousRoom, (Object)that.previousRoom).append((Object)this.desc, (Object)that.desc).append((Object)this.color, (Object)that.color).append((Object)this.substitutionFrom, (Object)that.substitutionFrom).append((Object)this.teacherTo, (Object)that.teacherTo).isEquals();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Substitution that = (Substitution)o;
        return new EqualsBuilder().append((Object)this.lesson, (Object)that.lesson).append((Object)this.type, (Object)that.type).append((Object)this.subject, (Object)that.subject).append((Object)this.previousSubject, (Object)that.previousSubject).append(this.teachers, that.teachers).append(this.previousTeachers, that.previousTeachers).append(this.classes, that.classes).append((Object)this.room, (Object)that.room).append((Object)this.previousRoom, (Object)that.previousRoom).append((Object)this.desc, (Object)that.desc).append((Object)this.color, (Object)that.color).append((Object)this.substitutionFrom, (Object)that.substitutionFrom).append((Object)this.teacherTo, (Object)that.teacherTo).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.lesson).append((Object)this.type).append((Object)this.subject).append((Object)this.previousSubject).append(this.teachers).append(this.previousTeachers).append(this.classes).append((Object)this.room).append((Object)this.previousRoom).append((Object)this.desc).append((Object)this.color).append((Object)this.substitutionFrom).append((Object)this.teacherTo).toHashCode();
    }

    public String toString() {
        return this.toString(SubstitutionSchedule.Type.STUDENT);
    }

    public String toString(SubstitutionSchedule.Type type) {
        switch (type) {
            case STUDENT: {
                return this.lesson + " " + this.classes.toString() + " " + this.getType() + " " + this.getText();
            }
            case TEACHER: {
                return this.lesson + " " + this.getPreviousAndCurrentTeacherText() + " " + this.getType() + " " + this.getTeacherText() + " (" + (this.substitutionFrom != null ? this.substitutionFrom : "") + "/" + (this.teacherTo != null ? this.teacherTo : "") + ")";
            }
        }
        return null;
    }

    public Substitution clone() throws CloneNotSupportedException {
        return (Substitution)super.clone();
    }
}

