/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.additionalinfo.amgrottweil;

import java.io.IOException;
import me.vertretungsplan.additionalinfo.BaseAdditionalInfoParser;
import me.vertretungsplan.objects.AdditionalInfo;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class AmgRottweilMessagesParser
extends BaseAdditionalInfoParser {
    static final String TITLE = "Nachrichten f\u00fcr Sch\u00fcler";

    @Override
    public AdditionalInfo getAdditionalInfo() throws IOException {
        String html = this.httpGet("https://www.amgrw.de/AMGaktuell/NachrichtenSchueler.php", "UTF-8");
        return this.parse(html);
    }

    @NotNull
    AdditionalInfo parse(String html) {
        Document doc = Jsoup.parse((String)html);
        Elements messages = doc.select("tr td:eq(1)");
        StringBuilder text = new StringBuilder();
        boolean first = true;
        for (Element message : messages) {
            if (first) {
                first = false;
            } else {
                text.append("<br><br>");
            }
            text.append(message.text());
        }
        AdditionalInfo info = new AdditionalInfo();
        info.setHasInformation(false);
        info.setTitle(TITLE);
        info.setText(text.toString());
        return info;
    }
}

