/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.additionalinfo;

import java.io.IOException;
import me.vertretungsplan.additionalinfo.WinterShParser;
import me.vertretungsplan.additionalinfo.amgrottweil.AmgRottweilMessagesParser;
import me.vertretungsplan.additionalinfo.amgrottweil.AmgRottweilRSSParser;
import me.vertretungsplan.additionalinfo.lsschleswig.LsSchleswigRSSParser;
import me.vertretungsplan.objects.AdditionalInfo;
import org.apache.http.client.fluent.Request;

public abstract class BaseAdditionalInfoParser {
    protected BaseAdditionalInfoParser() {
    }

    public static BaseAdditionalInfoParser getInstance(String type) {
        BaseAdditionalInfoParser parser = null;
        switch (type) {
            case "winter-sh": {
                parser = new WinterShParser();
                break;
            }
            case "amgrottweil-rss": {
                parser = new AmgRottweilRSSParser();
                break;
            }
            case "amgrottweil-messages": {
                parser = new AmgRottweilMessagesParser();
                break;
            }
            case "lsschleswig-rss": {
                parser = new LsSchleswigRSSParser();
            }
        }
        return parser;
    }

    public abstract AdditionalInfo getAdditionalInfo() throws IOException;

    protected String httpGet(String url, String encoding) throws IOException {
        return new String(Request.Get((String)url).execute().returnContent().asBytes(), encoding);
    }
}

