/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import me.vertretungsplan.parser.UntisCommonParser;
import org.joda.time.LocalDateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class UntisSubstitutionParser
extends UntisCommonParser {
    private String baseUrl;
    private JSONObject data;

    public UntisSubstitutionParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        try {
            this.data = scheduleData.getData();
            this.baseUrl = this.data.getString("baseurl");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        String encoding = this.data.getString("encoding");
        Document doc = Jsoup.parse((String)this.httpGet(this.baseUrl, encoding));
        Elements classes = doc.select("td a");
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        String lastChange = doc.select("td[align=right]:not(:has(b))").text();
        LocalDateTime lastChangeDate = ParserUtils.parseDateTime(lastChange);
        Pattern dayPattern = Pattern.compile("\\d\\d?.\\d\\d?. / \\w+");
        for (Element klasse : classes) {
            String date;
            Document classDoc = Jsoup.parse((String)this.httpGet(this.baseUrl.substring(0, this.baseUrl.lastIndexOf("/")) + "/" + klasse.attr("href"), encoding));
            int dateColumn = -1;
            JSONArray columns = this.data.getJSONArray("columns");
            for (int i = 0; i < columns.length(); ++i) {
                if (!columns.getString(i).equals("date")) continue;
                dateColumn = i;
                break;
            }
            Element table = classDoc.select("table[rules=all]").first();
            if (dateColumn == -1) {
                SubstitutionScheduleDay day = new SubstitutionScheduleDay();
                day.setLastChangeString(lastChange);
                day.setLastChange(lastChangeDate);
                String title = classDoc.select("font[size=5], font[size=4]").text();
                Matcher matcher = dayPattern.matcher(title);
                if (matcher.find()) {
                    date = matcher.group();
                    day.setDateString(date);
                    day.setDate(ParserUtils.parseDate(date));
                }
                this.parseVertretungsplanTable(table, this.data, day);
                v.addDay(day);
                continue;
            }
            for (Element line : table.select("tr.list.odd:not(:has(td.inline_header)), tr.list.even:not(:has(td.inline_header)), tr:has(td[align=center]:has(font[color]))")) {
                SubstitutionScheduleDay day = null;
                date = ((Element)line.select("td").get(dateColumn)).text().trim();
                for (SubstitutionScheduleDay search : v.getDays()) {
                    if (!search.getDateString().equals(date)) continue;
                    day = search;
                    break;
                }
                if (day == null) {
                    day = new SubstitutionScheduleDay();
                    day.setDateString(date);
                    day.setDate(ParserUtils.parseDate(date));
                    day.setLastChangeString(lastChange);
                    day.setLastChange(lastChangeDate);
                    v.addDay(day);
                }
                this.parseVertretungsplanTable(line, this.data, day);
            }
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    @Override
    public List<String> getAllClasses() throws JSONException, IOException {
        JSONArray classesJson = this.data.getJSONArray("classes");
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < classesJson.length(); ++i) {
            classes.add(classesJson.getString(i));
        }
        return classes;
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

