/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.List;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import me.vertretungsplan.parser.UntisCommonParser;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class UntisInfoHeadlessParser
extends UntisCommonParser {
    private String url;
    private JSONObject data;

    public UntisInfoHeadlessParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        try {
            this.data = scheduleData.getData();
            this.url = this.data.getString("url");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        Document doc = Jsoup.parse((String)this.httpGet(this.url, this.data.getString("encoding")));
        Elements dayElems = doc.select("#vertretung > p > b, #vertretung > b");
        for (Element dayElem : dayElems) {
            SubstitutionScheduleDay day = new SubstitutionScheduleDay();
            day.setLastChangeString("");
            String date = dayElem.text();
            day.setDateString(date);
            day.setDate(ParserUtils.parseDate(date));
            Element next = dayElem.parent().tagName().equals("p") ? dayElem.parent().nextElementSibling().nextElementSibling() : dayElem.parent().select("p").first().nextElementSibling();
            this.parseDay(day, next, v);
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

