/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.ColorProvider;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.ParserUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class DaVinciParser
extends BaseParser {
    private static final String ENCODING = "UTF-8";

    public DaVinciParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
    }

    public static void parseDaVinciTable(Element table, SubstitutionScheduleDay day, ColorProvider colorProvider) {
        DaVinciParser.parseDaVinciTable(table, day, null, colorProvider);
    }

    public static void parseDaVinciTable(Element table, SubstitutionScheduleDay day, String klasse, ColorProvider colorProvider) {
        ArrayList<String> headers = new ArrayList<String>();
        for (Element header : table.select("thead tr th, tr td[bgcolor=#9999FF]")) {
            headers.add(header.text());
        }
        HashSet<String> classes = new HashSet<String>();
        String lesson = null;
        Pattern previousCurrentPattern = Pattern.compile("\\+([^\\s]+) \\(([^)]+)\\)");
        for (Element row : table.select("tr:not(thead tr, tr:has(td[bgcolor=#9999FF]))")) {
            Substitution subst = new Substitution();
            Elements columns = row.select("td");
            block32: for (int i = 0; i < headers.size(); ++i) {
                String value = ((Element)columns.get(i)).text().replace("\u00a0", "");
                String header = (String)headers.get(i);
                if (value.isEmpty()) {
                    if (header.equals("Klasse")) {
                        subst.setClasses(classes);
                    }
                    if (header.equals("Pos") || header.equals("Stunde")) {
                        subst.setLesson(lesson);
                    }
                    if (!header.equals("Art") && !header.equals("Merkmal")) continue;
                    subst.setType("Vertretung");
                    continue;
                }
                Matcher matcher = previousCurrentPattern.matcher(value);
                switch (header) {
                    case "Klasse": {
                        classes = new HashSet<String>(Arrays.asList(value.split(",")));
                        subst.setClasses(classes);
                        continue block32;
                    }
                    case "Pos": 
                    case "Stunde": {
                        lesson = value;
                        subst.setLesson(lesson);
                        continue block32;
                    }
                    case "VLehrer K\u00fcrzel": 
                    case "VLehrer": 
                    case "Vertreter": {
                        if (value.startsWith("*")) continue block32;
                        if (value.equals("Raum\u00e4nderung")) {
                            subst.setType(value);
                            continue block32;
                        }
                        subst.setTeacher(value);
                        continue block32;
                    }
                    case "Lehrer": 
                    case "Lehrer K\u00fcrzel": {
                        if (matcher.find()) {
                            subst.setTeacher(matcher.group(1));
                            subst.setPreviousTeacher(matcher.group(2));
                            continue block32;
                        }
                        subst.setPreviousTeacher(value);
                        continue block32;
                    }
                    case "VFach": {
                        subst.setSubject(value);
                        continue block32;
                    }
                    case "Fach": {
                        if (matcher.find()) {
                            subst.setSubject(matcher.group(1));
                            subst.setPreviousSubject(matcher.group(2));
                            continue block32;
                        }
                        subst.setPreviousSubject(value);
                        continue block32;
                    }
                    case "VRaum": {
                        subst.setRoom(value);
                        continue block32;
                    }
                    case "Raum": {
                        if (matcher.find()) {
                            subst.setRoom(matcher.group(1));
                            subst.setPreviousRoom(matcher.group(2));
                            continue block32;
                        }
                        subst.setPreviousRoom(value);
                        continue block32;
                    }
                    case "Art": 
                    case "Merkmal": {
                        subst.setType(value);
                        continue block32;
                    }
                    case "Info": 
                    case "Mitteilung": {
                        subst.setDesc(value);
                        if (!headers.contains("Art") && headers.contains("Merkmal")) continue block32;
                    }
                }
            }
            if (klasse != null) {
                HashSet<String> fixedClasses = new HashSet<String>();
                fixedClasses.add(klasse);
                subst.setClasses(fixedClasses);
            }
            if (subst.getType() == null) {
                String recognizedType = null;
                if (subst.getDesc() != null) {
                    recognizedType = DaVinciParser.recognizeType(subst.getDesc());
                }
                subst.setType(recognizedType != null ? recognizedType : "Vertretung");
            }
            subst.setColor(colorProvider.getColor(subst.getType()));
            day.addSubstitution(subst);
        }
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        SubstitutionSchedule schedule = SubstitutionSchedule.fromData(this.scheduleData);
        String url = this.scheduleData.getData().getString("url");
        Document doc = Jsoup.parse((String)this.httpGet(url, ENCODING));
        if (doc.select("ul.classes").size() > 0) {
            Elements classes = doc.select("ul.classes li a");
            for (Element klasse : classes) {
                String classUrl = new URL(new URL(url), klasse.attr("href")).toString();
                Document classDoc = Jsoup.parse((String)this.httpGet(classUrl, ENCODING));
                schedule.addDay(this.parseDay(classDoc));
            }
        } else if (doc.select("ul.month").size() > 0) {
            Elements days = doc.select("ul.month li input[onclick]");
            for (Element day : days) {
                String urlFromOnclick = this.urlFromOnclick(day.attr("onclick"));
                if (urlFromOnclick == null) continue;
                String dayUrl = new URL(new URL(url), urlFromOnclick).toString();
                Document dayDoc = Jsoup.parse((String)this.httpGet(dayUrl, ENCODING));
                schedule.addDay(this.parseDay(dayDoc));
            }
        } else if (doc.select("ul.day-index").size() > 0) {
            Elements days = doc.select("ul.day-index li a");
            for (Element day : days) {
                String dayUrl = new URL(new URL(url), day.attr("href")).toString();
                Document dayDoc = Jsoup.parse((String)this.httpGet(dayUrl, ENCODING));
                schedule.addDay(this.parseDay(dayDoc));
            }
        } else {
            schedule.addDay(this.parseDay(doc));
        }
        schedule.setWebsite(url);
        schedule.setClasses(this.getAllClasses());
        schedule.setTeachers(this.getAllTeachers());
        return schedule;
    }

    private String urlFromOnclick(String onclick) {
        Pattern pattern = Pattern.compile("window\\.location\\.href='([^']+)'");
        Matcher matcher = pattern.matcher(onclick);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @NotNull
    private SubstitutionScheduleDay parseDay(Document doc) throws IOException {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        String title = doc.select("h1.list-table-caption").first().text();
        String klasse = null;
        if (title.matches("\\w+ \\d+\\.\\d+.\\d{4}")) {
            day.setDateString(title);
            day.setDate(ParserUtils.parseDate(title));
        } else {
            klasse = title;
            String nextText = doc.select("h1.list-table-caption").first().nextElementSibling().text();
            if (nextText.matches("\\w+ \\d+\\.\\d+.\\d{4}")) {
                day.setDateString(nextText);
                day.setDate(ParserUtils.parseDate(nextText));
            } else {
                throw new IOException("Could not find date");
            }
        }
        String lastChange = doc.select(".row.copyright div").first().ownText();
        Pattern pattern = Pattern.compile("(\\d{2}-\\d{2}-\\d{4} \\d{2}:\\d{2}) \\|");
        Matcher matcher = pattern.matcher(lastChange);
        if (matcher.find()) {
            LocalDateTime lastChangeTime = DateTimeFormat.forPattern((String)"dd-MM-yyyy HH:mm").parseLocalDateTime(matcher.group(1));
            day.setLastChange(lastChangeTime);
        }
        if (doc.select(".list-table").size() > 0 || !doc.select(".callout").text().contains("Es liegen keine")) {
            Element table = doc.select(".list-table").first();
            DaVinciParser.parseDaVinciTable(table, day, klasse, this.colorProvider);
        }
        return day;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        if (this.scheduleData.getData().has("classesSource")) {
            Document doc = Jsoup.parse((String)this.httpGet(this.scheduleData.getData().getString("classesSource"), ENCODING));
            ArrayList<String> classes = new ArrayList<String>();
            for (Element li : doc.select("li.Class")) {
                classes.add(li.text());
            }
            return classes;
        }
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

