/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.objects;

import java.util.HashSet;
import java.util.Set;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.utils.SubstitutionTextUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Substitution {
    private Set<String> classes;
    private String lesson;
    private String type;
    private String subject;
    private String previousSubject;
    private String teacher;
    private String previousTeacher;
    private String room;
    private String previousRoom;
    private String desc;
    private String color;
    private String substitutionFrom;
    private String teacherTo;

    public Substitution() {
        this.classes = new HashSet<String>();
    }

    public Substitution(Substitution substitution, Set<String> classes) {
        this.classes = classes;
        this.lesson = substitution.lesson;
        this.type = substitution.type;
        this.subject = substitution.type;
        this.previousSubject = substitution.previousSubject;
        this.teacher = substitution.teacher;
        this.previousTeacher = substitution.previousTeacher;
        this.room = substitution.room;
        this.previousRoom = substitution.previousRoom;
        this.desc = substitution.desc;
        this.color = substitution.color;
        this.substitutionFrom = substitution.substitutionFrom;
        this.teacherTo = substitution.teacherTo;
    }

    public String getText() {
        return SubstitutionTextUtils.getText(this);
    }

    public String getTeacherText() {
        return SubstitutionTextUtils.getTeacherText(this);
    }

    public String getTeachers() {
        return SubstitutionTextUtils.getTeachers(this);
    }

    @NotNull
    public Set<String> getClasses() {
        return this.classes;
    }

    public void setClasses(@NotNull Set<String> classes) {
        this.classes = classes;
    }

    @NotNull
    public String getLesson() {
        return this.lesson;
    }

    public void setLesson(@NotNull String lesson) {
        this.lesson = lesson;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public void setType(@NotNull String type) {
        this.type = type;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(@Nullable String subject) {
        this.subject = subject;
    }

    @Nullable
    public String getPreviousSubject() {
        return this.previousSubject;
    }

    public void setPreviousSubject(@Nullable String previousSubject) {
        this.previousSubject = previousSubject;
    }

    @Nullable
    public String getTeacher() {
        return this.teacher;
    }

    public void setTeacher(@Nullable String teacher) {
        this.teacher = teacher;
    }

    @Nullable
    public String getPreviousTeacher() {
        return this.previousTeacher;
    }

    public void setPreviousTeacher(@Nullable String previousTeacher) {
        this.previousTeacher = previousTeacher;
    }

    @Nullable
    public String getRoom() {
        return this.room;
    }

    public void setRoom(@Nullable String room) {
        this.room = room;
    }

    @Nullable
    public String getPreviousRoom() {
        return this.previousRoom;
    }

    public void setPreviousRoom(@Nullable String previousRoom) {
        this.previousRoom = previousRoom;
    }

    @Nullable
    public String getDesc() {
        return this.desc;
    }

    public void setDesc(@Nullable String desc) {
        this.desc = desc;
    }

    @NotNull
    public String getColor() {
        return this.color;
    }

    public void setColor(@NotNull String color) {
        this.color = color;
    }

    @Nullable
    public String getSubstitutionFrom() {
        return this.substitutionFrom;
    }

    public void setSubstitutionFrom(@Nullable String substitutionFrom) {
        this.substitutionFrom = substitutionFrom;
    }

    @Nullable
    public String getTeacherTo() {
        return this.teacherTo;
    }

    public void setTeacherTo(@Nullable String teacherTo) {
        this.teacherTo = teacherTo;
    }

    public boolean equalsExcludingClasses(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Substitution that = (Substitution)o;
        if (this.lesson != null ? !this.lesson.equals(that.lesson) : that.lesson != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.subject != null ? !this.subject.equals(that.subject) : that.subject != null) {
            return false;
        }
        if (this.previousSubject != null ? !this.previousSubject.equals(that.previousSubject) : that.previousSubject != null) {
            return false;
        }
        if (this.teacher != null ? !this.teacher.equals(that.teacher) : that.teacher != null) {
            return false;
        }
        if (this.previousTeacher != null ? !this.previousTeacher.equals(that.previousTeacher) : that.previousTeacher != null) {
            return false;
        }
        if (this.room != null ? !this.room.equals(that.room) : that.room != null) {
            return false;
        }
        if (this.previousRoom != null ? !this.previousRoom.equals(that.previousRoom) : that.previousRoom != null) {
            return false;
        }
        if (this.desc != null ? !this.desc.equals(that.desc) : that.desc != null) {
            return false;
        }
        if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
            return false;
        }
        if (this.substitutionFrom != null ? !this.substitutionFrom.equals(that.substitutionFrom) : that.substitutionFrom != null) {
            return false;
        }
        return !(this.teacherTo != null ? !this.teacherTo.equals(that.teacherTo) : that.teacherTo != null);
    }

    public String toString() {
        return this.toString(SubstitutionSchedule.Type.STUDENT);
    }

    public String toString(SubstitutionSchedule.Type type) {
        switch (type) {
            case STUDENT: {
                return this.classes.toString() + " " + this.getType() + " " + this.getText();
            }
            case TEACHER: {
                return this.getTeachers() + " " + this.getType() + " " + this.getTeacherText() + " (" + (this.substitutionFrom != null ? this.substitutionFrom : "") + "/" + (this.teacherTo != null ? this.teacherTo : "") + ")";
            }
        }
        return null;
    }
}

