/*
 * Decompiled with CFR 0.152.
 */
package me.tzion.identity;

import java.lang.reflect.ParameterizedType;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.tzion.identity.Current;
import me.tzion.identity.OptionalContainerRequestValueFactory;
import me.tzion.identity.PrincipalContainerRequestValueFactory;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
public class IdentityValueFactoryProvider<T>
extends AbstractValueFactoryProvider {
    private final PrincipalClassProvider<T> cl;
    private Class<T> principalClass;

    @Inject
    protected IdentityValueFactoryProvider(MultivaluedParameterExtractorProvider mpep, ServiceLocator locator, PrincipalClassProvider<T> principalClass) {
        super(mpep, locator, new Parameter.Source[]{Parameter.Source.UNKNOWN});
        this.principalClass = ((PrincipalClassProvider)principalClass).clazz;
        this.cl = principalClass;
    }

    protected Factory<?> createValueFactory(Parameter parameter) {
        if (!parameter.isAnnotationPresent(Current.class)) {
            return null;
        }
        if (this.principalClass.equals(parameter.getRawType())) {
            return new PrincipalContainerRequestValueFactory(this.cl);
        }
        boolean optional = parameter.getRawType() == Optional.class && ParameterizedType.class.isAssignableFrom(parameter.getType().getClass()) && ((ParameterizedType)parameter.getType()).getActualTypeArguments()[0] == this.principalClass;
        return optional ? new OptionalContainerRequestValueFactory(this.cl) : null;
    }

    public static class Binder<T>
    extends AbstractBinder {
        private Class<T> principalClass;

        public Binder(Class<T> principalClass) {
            this.principalClass = principalClass;
        }

        protected void configure() {
            this.bind(new PrincipalClassProvider(this.principalClass)).to(PrincipalClassProvider.class);
            this.bind(IdentityValueFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
            this.bind(CurrentInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<Current>>(){}).in(Singleton.class);
        }
    }

    @Singleton
    private static class CurrentInjectionResolver
    extends ParamInjectionResolver {
        public CurrentInjectionResolver() {
            super(IdentityValueFactoryProvider.class);
        }
    }

    @Singleton
    public static class PrincipalClassProvider<T> {
        private final Class<T> clazz;

        private PrincipalClassProvider(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Class<T> getClazz() {
            return this.clazz;
        }
    }
}

