/*
 * Decompiled with CFR 0.152.
 */
package me.tzion.identity;

import java.io.IOException;
import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import me.tzion.identity.Identifiable;
import me.tzion.identity.Identities;

public class IdentityFilter<C, P>
implements ContainerRequestFilter {
    private Identifiable<C> identifiable;
    private Unauthorized unauthorized;
    private Identities<C, P> identities;

    public IdentityFilter(Identifiable<C> identifiable, Identities<C, P> identities, Unauthorized unauthorized) {
        this.unauthorized = unauthorized;
        this.identities = identities;
        this.identifiable = identifiable;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Optional<C> identifiable = this.identifiable.from(requestContext);
        if (!identifiable.isPresent()) {
            throw new WebApplicationException(this.unauthorized.handle(requestContext));
        }
        if (!this.identified(requestContext, identifiable.get())) {
            throw new WebApplicationException(this.unauthorized.handle(requestContext));
        }
    }

    private boolean identified(ContainerRequestContext requestContext, C identifiable) {
        Optional<P> identity = this.identities.identify(identifiable);
        if (!identity.isPresent()) {
            return false;
        }
        requestContext.setProperty("__current__", identity.get());
        return true;
    }

    public static interface Unauthorized {
        public Response handle(ContainerRequestContext var1);
    }
}

