/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.spring.test;

import java.io.File;
import java.io.IOException;
import me.tfeng.play.spring.ApplicationContextHolder;
import me.tfeng.play.spring.test.TestLock;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import play.core.enhancers.PropertiesEnhancer;

@ContextConfiguration(value={"classpath*:spring/**/*.xml", "classpath*:play-plugins/spring/**/*.xml"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
@RunWith(value=SpringJUnit4ClassRunner.class)
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class AbstractSpringTest {
    private static final File TEMPORARY_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));
    @Autowired
    protected ConfigurableApplicationContext applicationContext;

    @After
    public void afterTest() throws IOException {
        TestLock.unlock();
    }

    @Before
    public void beforeTest() throws IOException, InterruptedException {
        TestLock.lock(this.lockFile());
        ApplicationContextHolder.set((ConfigurableApplicationContext)this.applicationContext);
    }

    protected File lockFile() throws IOException {
        return new File(TEMPORARY_DIRECTORY, "play-test.lock");
    }
}

