/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.spring.test;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class TestLock {
    private static FileLock fileLock;
    private static final Object LOCAL_LOCK;
    private static File lockFile;
    private static final Logger.ALogger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lock(File file) {
        Object object = LOCAL_LOCK;
        synchronized (object) {
            try {
                if (fileLock != null) {
                    throw new RuntimeException("Unexpected State!!!");
                }
                if (file != null) {
                    FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                    while (true) {
                        try {
                            fileLock = channel.lock();
                        }
                        catch (OverlappingFileLockException e) {
                            LOG.info("The lock is being held by anther test; waiting for 1 second before retrying ...");
                            LOCAL_LOCK.wait(1000L);
                            continue;
                        }
                        break;
                    }
                    lockFile = file;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to lock " + file, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlock() {
        Object object = LOCAL_LOCK;
        synchronized (object) {
            try {
                if (fileLock != null) {
                    fileLock.close();
                    fileLock = null;
                    lockFile = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to unlock " + lockFile, e);
            }
        }
    }

    static {
        LOCAL_LOCK = new Object();
        LOG = Logger.of(TestLock.class);
    }
}

