/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.spring.test;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockito.Mockito;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class MockingBeanPostProcessor
implements BeanPostProcessor {
    private Map<String, Class<?>> beans;
    private List<Class<?>> classes;
    private Map<Class<?>, Object> mocksForClasses = new HashMap();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass;
        if (this.beans != null && (beanClass = this.beans.get(beanName)) != null) {
            return this.getMockForClass(beanClass);
        }
        if (this.classes != null) {
            for (final Class<?> beanClass2 : this.classes) {
                if (beanClass2.isInstance(bean)) {
                    return this.getMockForClass(beanClass2);
                }
                if (!(bean instanceof FactoryBean) || !((FactoryBean)bean).getObjectType().isAssignableFrom(beanClass2)) continue;
                return new FactoryBean<Object>(){
                    private Object mock;
                    {
                        this.mock = MockingBeanPostProcessor.this.getMockForClass(beanClass2);
                    }

                    public Object getObject() throws Exception {
                        return this.mock;
                    }

                    public Class<?> getObjectType() {
                        return beanClass2;
                    }

                    public boolean isSingleton() {
                        return true;
                    }
                };
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setBeans(Map<String, Class<?>> beans) {
        this.beans = beans;
    }

    public void setClasses(List<Class<?>> classes) {
        this.classes = classes;
    }

    private Object getMockForClass(Class<?> beanClass) {
        Object mock = this.mocksForClasses.get(beanClass);
        if (mock == null) {
            mock = Mockito.mock(beanClass);
            this.mocksForClasses.put(beanClass, mock);
        }
        return mock;
    }
}

