/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.spring.test;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.Semaphore;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public final class TestLock {
    private static FileLock fileLock;
    private static File lockFile;
    private static final Semaphore SEMAPHORE;

    public static void lock(File file) {
        try {
            SEMAPHORE.acquire();
            if (fileLock != null) {
                throw new RuntimeException("Unexpected State!!!");
            }
            if (file != null) {
                FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
                fileLock = channel.lock(0L, 0L, false);
                lockFile = file;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to lock " + file, e);
        }
    }

    public static void unlock() {
        try {
            if (fileLock != null) {
                fileLock.close();
                fileLock = null;
                lockFile = null;
            }
            SEMAPHORE.release();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unlock " + lockFile, e);
        }
    }

    static {
        SEMAPHORE = new Semaphore(1);
    }
}

