/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.spring.test;

import java.util.List;
import java.util.Map;
import org.mockito.Mockito;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class MockingBeanPostProcessor
implements BeanPostProcessor {
    private Map<String, Class<?>> beans;
    private List<Class<?>> classes;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass;
        if (this.beans != null && (beanClass = this.beans.get(beanName)) != null) {
            return Mockito.mock(beanClass);
        }
        if (this.classes != null) {
            for (Class<?> beanClass2 : this.classes) {
                if (!beanClass2.isInstance(bean)) continue;
                return Mockito.mock(beanClass2);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setBeans(Map<String, Class<?>> beans) {
        this.beans = beans;
    }

    public void setClasses(List<Class<?>> classes) {
        this.classes = classes;
    }
}

