/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.spring.test;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessController;
import java.util.concurrent.Semaphore;
import me.tfeng.play.spring.ApplicationContextHolder;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import play.core.enhancers.PropertiesEnhancer;
import sun.security.action.GetPropertyAction;

@ContextConfiguration(value={"classpath*:spring/**/*.xml", "classpath*:play-plugins/spring/**/*.xml"})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
@RunWith(value=SpringJUnit4ClassRunner.class)
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class AbstractSpringTest {
    private static final Semaphore SEMAPHORE = new Semaphore(1);
    private static final File TEMPORARY_DIRECTORY = new File(AccessController.doPrivileged(new GetPropertyAction("java.io.tmpdir")));
    @Autowired
    protected ConfigurableApplicationContext applicationContext;
    private FileLock testLock;

    @After
    public void afterTest() throws IOException {
        if (this.requireLocking()) {
            SEMAPHORE.release();
            if (this.testLock != null) {
                this.testLock.release();
                this.testLock = null;
            }
        }
    }

    @Before
    public void beforeTest() throws IOException, InterruptedException {
        File file;
        if (this.requireLocking() && (file = this.lockFile()) != null) {
            FileChannel channel = new RandomAccessFile(file, "rw").getChannel();
            try {
                this.testLock = channel.lock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                // empty catch block
            }
            SEMAPHORE.acquire();
        }
        ApplicationContextHolder.set((ConfigurableApplicationContext)this.applicationContext);
    }

    protected File lockFile() throws IOException {
        return new File(TEMPORARY_DIRECTORY, "play-test.lock");
    }

    protected boolean requireLocking() {
        return true;
    }
}

