/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.spring;

import me.tfeng.play.plugins.SpringPlugin;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.ConfigurableApplicationContext;
import play.Application;
import play.GlobalSettings;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SpringGlobalSettings
extends GlobalSettings {
    public <A> A getControllerInstance(Class<A> clazz) {
        try {
            return (A)SpringPlugin.getInstance().getApplicationContext().getBean(clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public F.Promise<Result> onError(Http.RequestHeader request, Throwable t) {
        return F.Promise.pure((Object)Results.badRequest());
    }

    public void onStart(Application application) {
        AutowiredAnnotationBeanPostProcessor beanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        beanPostProcessor.setBeanFactory((BeanFactory)this.getApplicationContext(application).getBeanFactory());
        beanPostProcessor.processInjection((Object)this);
    }

    protected ConfigurableApplicationContext getApplicationContext(Application application) {
        return ((SpringPlugin)((Object)application.plugin(SpringPlugin.class))).getApplicationContext();
    }
}

