/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import me.tfeng.play.plugins.AbstractPlugin;
import me.tfeng.play.spring.ExtendedStartable;
import me.tfeng.play.spring.Startable;
import me.tfeng.play.utils.DependencyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import play.Application;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class StartablePlugin
extends AbstractPlugin {
    private static final Logger.ALogger LOG = Logger.of(StartablePlugin.class);
    private Set<Startable> startables = new HashSet<Startable>();

    public static StartablePlugin getInstance() {
        return (StartablePlugin)((Object)Play.application().plugin(StartablePlugin.class));
    }

    public StartablePlugin(Application application) {
        super(application);
    }

    public void addStartable(Startable startable) {
        this.startables.add(startable);
    }

    public void addStartables(Collection<? extends Startable> startables) {
        this.startables.addAll(startables);
    }

    public List<Startable> getStartables() {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.getApplicationContext().getAutowireCapableBeanFactory();
        Comparator beanDependencyComparator = (bean1, bean2) -> {
            String beanName1 = (String)bean1.getKey();
            String beanName2 = (String)bean2.getKey();
            BeanDefinition beanDefinition1 = registry.getBeanDefinition(beanName1);
            BeanDefinition beanDefinition2 = registry.getBeanDefinition(beanName2);
            if (beanDefinition1 == null || beanDefinition2 == null) {
                return 0;
            }
            if (ArrayUtils.contains((Object[])beanDefinition1.getDependsOn(), (Object)beanName2)) {
                return 1;
            }
            if (ArrayUtils.contains((Object[])beanDefinition2.getDependsOn(), (Object)beanName1)) {
                return -1;
            }
            return 0;
        };
        Set entries = this.getApplicationContext().getBeansOfType(Startable.class).entrySet();
        List sortedEntries = DependencyUtils.dependencySort(entries, beanDependencyComparator);
        ArrayList<Startable> result = new ArrayList<Startable>(this.startables.size() + sortedEntries.size());
        result.addAll(this.startables);
        for (Map.Entry entry : sortedEntries) {
            Startable startable = (Startable)entry.getValue();
            if (this.startables.contains(startable)) continue;
            result.add(startable);
        }
        return result;
    }

    @Override
    public void onStart() {
        super.onStart();
        List<Startable> startables = this.getStartables();
        for (Startable startable : startables) {
            if (!(startable instanceof ExtendedStartable)) continue;
            try {
                ((ExtendedStartable)startable).beforeStart();
            }
            catch (Throwable t) {
                this.onStartFailure(startable, t);
            }
        }
        for (Startable startable : startables) {
            try {
                startable.onStart();
            }
            catch (Throwable t) {
                this.onStartFailure(startable, t);
            }
        }
        for (Startable startable : startables) {
            if (!(startable instanceof ExtendedStartable)) continue;
            try {
                ((ExtendedStartable)startable).afterStart();
            }
            catch (Throwable t) {
                this.onStartFailure(startable, t);
            }
        }
    }

    public void onStartFailure(Startable startable, Throwable t) {
        throw new RuntimeException("Unable to start " + startable, t);
    }

    public void onStop() {
        Startable startable;
        List<Startable> startables = this.getStartables();
        ListIterator<Startable> iterator = startables.listIterator(startables.size());
        while (iterator.hasPrevious()) {
            startable = iterator.previous();
            if (!(startable instanceof ExtendedStartable)) continue;
            try {
                ((ExtendedStartable)startable).beforeStop();
            }
            catch (Throwable t) {
                this.onStartFailure(startable, t);
            }
        }
        iterator = startables.listIterator(startables.size());
        while (iterator.hasPrevious()) {
            startable = iterator.previous();
            try {
                startable.onStop();
            }
            catch (Throwable t) {
                this.onStopFailure(startable, t);
            }
        }
        iterator = startables.listIterator(startables.size());
        while (iterator.hasPrevious()) {
            startable = iterator.previous();
            if (!(startable instanceof ExtendedStartable)) continue;
            try {
                ((ExtendedStartable)startable).afterStop();
            }
            catch (Throwable t) {
                this.onStartFailure(startable, t);
            }
        }
        super.onStop();
    }

    public void onStopFailure(Startable startable, Throwable t) {
        LOG.error("Unable to stop " + startable, t);
    }
}

