/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.tfeng.play.plugins.AbstractPlugin;
import me.tfeng.play.spring.ApplicationContextHolder;
import me.tfeng.play.spring.WithSpringConfig;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import play.Application;
import play.Logger;
import play.Play;
import play.api.Plugin;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Scala;
import scala.collection.Seq;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SpringPlugin
extends AbstractPlugin {
    private static final Logger.ALogger LOG = Logger.of(SpringPlugin.class);
    private ConfigurableApplicationContext applicationContext;

    public static SpringPlugin getInstance() {
        return (SpringPlugin)((Object)Play.application().plugin(SpringPlugin.class));
    }

    public SpringPlugin(Application application) {
        super(application);
    }

    @Override
    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void onStart() {
        this.applicationContext = ApplicationContextHolder.get();
        if (this.applicationContext == null) {
            ArrayList configLocations = Lists.newArrayList((Iterable)this.getConfiguration().getStringList("spring-plugin.spring-config-locations", Collections.singletonList("classpath*:spring/**/*.xml")));
            List plugins = Scala.asJava((Seq)this.getApplication().getWrappedApplication().plugins());
            for (Plugin plugin : plugins) {
                WithSpringConfig annotation = plugin.getClass().getAnnotation(WithSpringConfig.class);
                if (annotation == null) continue;
                Collections.addAll(configLocations, annotation.value());
            }
            LOG.info("Starting spring application context with config locations " + configLocations);
            ClassPathXmlApplicationContext classPathApplicationContext = new ClassPathXmlApplicationContext();
            List activeProfiles = this.getConfiguration().getStringList("spring.profiles.active");
            List defaultProfiles = this.getConfiguration().getStringList("spring.profiles.default");
            if (activeProfiles != null) {
                classPathApplicationContext.getEnvironment().setActiveProfiles(activeProfiles.toArray(new String[activeProfiles.size()]));
            }
            if (defaultProfiles != null) {
                classPathApplicationContext.getEnvironment().setDefaultProfiles(defaultProfiles.toArray(new String[defaultProfiles.size()]));
            }
            classPathApplicationContext.setConfigLocations(configLocations.toArray(new String[configLocations.size()]));
            classPathApplicationContext.refresh();
            this.applicationContext = classPathApplicationContext;
        } else {
            LOG.info("Using spring application context in ApplicationContextHolder");
        }
        super.onStart();
    }

    public void onStop() {
        super.onStop();
        LOG.info("Stopping spring application context");
        this.applicationContext.close();
    }
}

