/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.utils;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DependencyUtils {
    public static <T> List<T> dependencySort(Collection<T> collection, Comparator<T> dependencyComparator) {
        ArrayList<Object> result = new ArrayList<Object>(collection.size());
        HashMultimap dependencies = HashMultimap.create();
        HashSet<T> elements = new HashSet<T>(collection);
        for (Object element1 : elements) {
            for (Object element2 : elements) {
                if (element1 == element2 || dependencyComparator.compare(element1, element2) <= 0) continue;
                dependencies.put(element1, element2);
            }
        }
        while (!elements.isEmpty()) {
            Object next = null;
            for (Object element : elements) {
                if (!dependencies.get(element).isEmpty()) continue;
                next = element;
                break;
            }
            if (next == null) {
                throw new RuntimeException("Unable to sort list with respect to element dependency; remaining elements that form dependency cycle(s) are: " + dependencies.keySet());
            }
            elements.remove(next);
            dependencies.removeAll(next);
            Iterator iterator = dependencies.entries().iterator();
            while (iterator.hasNext()) {
                if (next != ((Map.Entry)iterator.next()).getValue()) continue;
                iterator.remove();
            }
            result.add(next);
        }
        return result;
    }
}

