/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import java.util.List;
import me.tfeng.play.plugins.AbstractPlugin;
import me.tfeng.play.spring.Startable;
import play.Application;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class StartablePlugin
extends AbstractPlugin {
    private static final Logger.ALogger LOG = Logger.of(StartablePlugin.class);

    public StartablePlugin(Application application) {
        super(application);
    }

    @Override
    public void onStart() {
        super.onStart();
        List<Startable> startables = this.getStartables();
        for (Startable startable : startables) {
            try {
                startable.onStart();
            }
            catch (Throwable t) {
                this.onStartFailure(startable, t);
            }
        }
    }

    public void onStop() {
        super.onStop();
        List<Startable> startables = this.getStartables();
        for (Startable startable : startables) {
            try {
                startable.onStop();
            }
            catch (Throwable t) {
                this.onStopFailure(startable, t);
            }
        }
    }

    protected abstract List<Startable> getStartables();

    protected void onStartFailure(Startable startable, Throwable t) {
        throw new RuntimeException("Unable to start " + startable, t);
    }

    protected void onStopFailure(Startable startable, Throwable t) {
        LOG.error("Unable to stop " + startable, t);
    }
}

