/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.security.oauth2;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.tfeng.play.plugins.OAuth2Plugin;
import me.tfeng.play.security.oauth2.Authentication;
import me.tfeng.play.security.oauth2.ClientAuthentication;
import me.tfeng.play.security.oauth2.OAuth2Authentication;
import me.tfeng.play.security.oauth2.UserAuthentication;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Request;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OAuth2AuthenticationAction
extends Action<OAuth2Authentication> {
    public static String ACCESS_TOKEN = "access_token";
    public static String AUTHORIZATION = "Authorization";
    public static String BEARER = "Bearer";
    private static final Logger.ALogger LOG = Logger.of(OAuth2AuthenticationAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static F.Promise<Result> authorizeAndCall(Http.Context context, Action<?> delegate) throws Throwable {
        org.springframework.security.core.Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
        try {
            Http.Request request = context.request();
            String token = OAuth2AuthenticationAction.getAuthorizationToken(request);
            if (token == null) {
                SecurityContextHolder.clearContext();
                try {
                    F.Promise promise = delegate.call(context).recover(t -> OAuth2AuthenticationAction.handleAuthenticationError(t));
                    return promise;
                }
                catch (Throwable t2) {
                    F.Promise promise = F.Promise.pure((Object)OAuth2AuthenticationAction.handleAuthenticationError(t2));
                    SecurityContextHolder.getContext().setAuthentication(currentAuthentication);
                    return promise;
                }
            }
            F.Promise<Authentication> promise = OAuth2Plugin.getInstance().getAuthenticationManager().authenticate(token);
            F.Promise promise2 = promise.flatMap(authentication -> {
                org.springframework.security.oauth2.provider.OAuth2Authentication oauth2Authentication = new org.springframework.security.oauth2.provider.OAuth2Authentication(OAuth2AuthenticationAction.getOAuth2Request(authentication.getClient()), (org.springframework.security.core.Authentication)OAuth2AuthenticationAction.getAuthentication(authentication.getUser()));
                SecurityContextHolder.getContext().setAuthentication((org.springframework.security.core.Authentication)oauth2Authentication);
                try {
                    return delegate.call(context).recover(t -> OAuth2AuthenticationAction.handleAuthenticationError(t));
                }
                catch (Throwable t2) {
                    return F.Promise.pure((Object)OAuth2AuthenticationAction.handleAuthenticationError(t2));
                }
            }).recover(t -> OAuth2AuthenticationAction.handleAuthenticationError(t));
            return promise2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(currentAuthentication);
        }
    }

    protected static UsernamePasswordAuthenticationToken getAuthentication(UserAuthentication user) {
        if (user == null) {
            return null;
        }
        List authorities = user.getAuthorities().stream().map(authority -> new SimpleGrantedAuthority(authority.toString())).collect(Collectors.toList());
        return new UsernamePasswordAuthenticationToken((Object)user.getId().toString(), null, authorities);
    }

    private static String getAuthorizationToken(Http.Request request) {
        String[] headers = (String[])request.headers().get(AUTHORIZATION);
        if (headers != null) {
            for (String header : headers) {
                if (!header.toLowerCase().startsWith(BEARER.toLowerCase())) continue;
                String authHeaderValue = header.substring(BEARER.length()).trim();
                return authHeaderValue.split(",")[0];
            }
        }
        return request.getQueryString(ACCESS_TOKEN);
    }

    private static OAuth2Request getOAuth2Request(ClientAuthentication client) {
        List authorities = client.getAuthorities().stream().map(authority -> new SimpleGrantedAuthority(authority.toString())).collect(Collectors.toList());
        Set scopes = client.getScopes().stream().map(scope -> scope.toString()).collect(Collectors.toSet());
        return new OAuth2Request(Collections.emptyMap(), client.getId().toString(), authorities, true, scopes, Collections.emptySet(), null, Collections.emptySet(), Collections.emptyMap());
    }

    private static Result handleAuthenticationError(Throwable t) throws Throwable {
        if (OAuth2Plugin.isAuthenticationError(t)) {
            LOG.warn("Authentication failed", t);
            return Results.unauthorized();
        }
        throw t;
    }

    public F.Promise<Result> call(Http.Context context) throws Throwable {
        return OAuth2AuthenticationAction.authorizeAndCall(context, this.delegate);
    }
}

