/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.security.oauth2;

import java.lang.reflect.Method;
import me.tfeng.play.plugins.OAuth2Plugin;
import me.tfeng.play.security.oauth2.OAuth2AuthenticationAction;
import me.tfeng.play.spring.SpringGlobalSettings;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OAuth2GlobalSettings
extends SpringGlobalSettings {
    @Value(value="${oauth2-plugin.authenticate-all:true}")
    private boolean authenticateAll;

    public F.Promise<Result> onError(Http.RequestHeader request, Throwable t) {
        Throwable cause = t.getCause();
        if (OAuth2Plugin.isAuthenticationError(t)) {
            return F.Promise.pure((Object)Results.unauthorized());
        }
        if (cause instanceof OAuth2Exception) {
            OAuth2Exception oauth2Exception = (OAuth2Exception)cause;
            return F.Promise.pure((Object)Results.status((int)oauth2Exception.getHttpErrorCode(), (String)oauth2Exception.getMessage()));
        }
        return super.onError(request, t);
    }

    public Action<Void> onRequest(Http.Request request, Method actionMethod) {
        return new Action.Simple(){

            public F.Promise<Result> call(Http.Context context) throws Throwable {
                if (OAuth2GlobalSettings.this.authenticateAll) {
                    return OAuth2AuthenticationAction.authorizeAndCall(context, this.delegate);
                }
                return this.delegate.call(context);
            }
        };
    }
}

