/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.plugins;

import java.lang.reflect.InvocationTargetException;
import me.tfeng.play.plugins.AbstractPlugin;
import me.tfeng.play.security.oauth2.AuthenticationError;
import me.tfeng.play.security.oauth2.AuthenticationManagerClient;
import me.tfeng.play.spring.WithSpringConfig;
import org.apache.avro.ipc.AsyncHttpException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.ClientAuthenticationException;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import play.Application;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@WithSpringConfig(value={"classpath*:play-plugins/spring/oauth2-plugin.xml"})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OAuth2Plugin
extends AbstractPlugin {
    @Autowired
    @Qualifier(value="oauth2-plugin.authentication-manager")
    private AuthenticationManagerClient authenticationManager;
    @Autowired(required=false)
    @Qualifier(value="oauth2-plugin.permission-evaluator")
    private PermissionEvaluator permissionEvaluator;

    public static OAuth2Plugin getInstance() {
        return (OAuth2Plugin)((Object)Play.application().plugin(OAuth2Plugin.class));
    }

    public static boolean isAuthenticationError(Throwable t) {
        Throwable target;
        if (t instanceof AccessDeniedException || t instanceof AuthenticationException || t instanceof ClientAuthenticationException || t instanceof ClientRegistrationException || t instanceof AuthenticationError || t instanceof AsyncHttpException && ((AsyncHttpException)t).getStatusCode() == 401) {
            return true;
        }
        Throwable cause = t.getCause();
        if (cause != t && cause != null && OAuth2Plugin.isAuthenticationError(cause)) {
            return true;
        }
        return t instanceof InvocationTargetException && OAuth2Plugin.isAuthenticationError(target = ((InvocationTargetException)t).getTargetException());
    }

    public OAuth2Plugin(Application application) {
        super(application);
    }

    public AuthenticationManagerClient getAuthenticationManager() {
        return this.authenticationManager;
    }

    public PermissionEvaluator getPermissionEvaluator() {
        return this.permissionEvaluator;
    }
}

