/**
 * Copyright 2014 Thomas Feng
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.tfeng.play.security.oauth2;

import org.springframework.context.ApplicationListener;
import org.springframework.security.access.event.AuthenticationCredentialsNotFoundEvent;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;

import play.mvc.Http.Context;

/**
 * @author Thomas Feng (huining.feng@gmail.com)
 */
public class AuthenticationCredentialsNotFoundEventListener
    implements ApplicationListener<AuthenticationCredentialsNotFoundEvent> {

  private final long contextId;

  private AuthenticationCredentialsNotFoundException exception;

  public AuthenticationCredentialsNotFoundEventListener(long contextId) {
    this.contextId = contextId;
  }

  public AuthenticationCredentialsNotFoundException getException() {
    return exception;
  }

  @Override
  public void onApplicationEvent(AuthenticationCredentialsNotFoundEvent event) {
    if (Context.current().id().equals(contextId)) {
      exception = event.getCredentialsNotFoundException();
    }
  }
}
