/**
 * Copyright 2014 Thomas Feng
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.tfeng.play.plugins;

import me.tfeng.play.security.oauth2.AuthenticationManagerClient;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import play.Application;
import play.Play;

/**
 * @author Thomas Feng (huining.feng@gmail.com)
 */
public class OAuth2Plugin extends AbstractPlugin {

  public static OAuth2Plugin getInstance() {
    return Play.application().plugin(OAuth2Plugin.class);
  }

  @Autowired
  @Qualifier("oauth2-plugin.authentication-manager")
  private AuthenticationManagerClient authenticationManager;

  public OAuth2Plugin(Application application) {
    super(application);
  }

  public AuthenticationManagerClient getAuthenticationManager() {
    return authenticationManager;
  }
}
