/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.play.security.oauth2;

import me.tfeng.play.spring.SpringGlobalSettings;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.ClientAuthenticationException;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class OAuth2GlobalSettings
extends SpringGlobalSettings {
    public F.Promise<Result> onError(Http.RequestHeader request, Throwable t) {
        Throwable cause = t.getCause();
        if (cause instanceof AccessDeniedException || cause instanceof AuthenticationException || cause instanceof ClientAuthenticationException || cause instanceof ClientRegistrationException) {
            return F.Promise.pure((Object)Results.unauthorized());
        }
        if (cause instanceof OAuth2Exception) {
            return F.Promise.pure((Object)Results.status((int)((OAuth2Exception)cause).getHttpErrorCode()));
        }
        return super.onError(request, t);
    }
}

